/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyDoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Double negation #ref #loc" == null) {
            GroovyDoubleNegationInspection.$$$reportNull$$$0(0);
        }
        return "Double negation #ref #loc";
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyDoubleNegationInspection.$$$reportNull$$$0(1);
        }
        return new DoubleNegationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        DoubleNegationVisitor doubleNegationVisitor = new DoubleNegationVisitor();
        if (doubleNegationVisitor == null) {
            GroovyDoubleNegationInspection.$$$reportNull$$$0(2);
        }
        return doubleNegationVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                DoubleNegationVisitor.$$$reportNull$$$0(0);
            }
            super.visitUnaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mLNOT.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                DoubleNegationVisitor.$$$reportNull$$$0(1);
            }
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mNOT_EQUAL.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        private void checkParent(GrExpression expression) {
            PsiElement parent2 = expression.getParent();
            while (parent2 instanceof GrParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof GrUnaryExpression)) {
                return;
            }
            GrUnaryExpression prefixExpression = (GrUnaryExpression)parent2;
            IElementType parentTokenType = prefixExpression.getOperationTokenType();
            if (!GroovyTokenTypes.mLNOT.equals(parentTokenType)) {
                return;
            }
            this.registerError(prefixExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DoubleNegationFix
    extends GroovyFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove double negation" == null) {
                DoubleNegationFix.$$$reportNull$$$0(0);
            }
            return "Remove double negation";
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            GrUnaryExpression expression;
            GrExpression operand;
            if (project == null) {
                DoubleNegationFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                DoubleNegationFix.$$$reportNull$$$0(2);
            }
            if ((operand = (GrExpression)PsiUtil.skipParentheses((expression = (GrUnaryExpression)descriptor2.getPsiElement()).getOperand(), false)) instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)operand;
                GrExpression innerOperand = prefixExpression.getOperand();
                if (innerOperand == null) {
                    return;
                }
                DoubleNegationFix.replaceExpression(expression, innerOperand.getText());
            } else if (operand instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)operand;
                GrExpression lhs = binaryExpression.getLeftOperand();
                String lhsText = lhs.getText();
                StringBuilder builder = new StringBuilder(lhsText);
                builder.append("==");
                GrExpression rhs = binaryExpression.getRightOperand();
                if (rhs != null) {
                    String rhsText = rhs.getText();
                    builder.append(rhsText);
                }
                DoubleNegationFix.replaceExpression(expression, builder.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

