/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyConstructorNamedArgumentsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            GroovyConstructorNamedArgumentsInspection.$$$reportNull$$$0(0);
        }
        return myVisitor;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        assert (args.length == 1 && args[0] instanceof String);
        return (String)args[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyConstructorNamedArgumentsInspection", "buildVisitor"));
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression newExpression) {
            if (newExpression == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(newExpression);
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            GroovyResolveResult constructorResolveResult = newExpression.advancedResolve();
            PsiElement constructor = constructorResolveResult.getElement();
            if (constructor != null) {
                GrArgumentList argList = newExpression.getArgumentList();
                if (argList != null && argList.getExpressionArguments().length == 0 && !PsiUtil.isConstructorHasRequiredParameters((PsiMethod)constructor)) {
                    this.checkDefaultMapConstructor(argList, constructor);
                }
            } else {
                PsiType[] argumentTypes;
                GroovyResolveResult[] results = newExpression.multiResolve(false);
                GrArgumentList argList = newExpression.getArgumentList();
                PsiElement element = refElement.resolve();
                if (results.length == 0 && element instanceof PsiClass && ((argumentTypes = PsiUtil.getArgumentTypes(refElement, true)) == null || argumentTypes.length == 0 || argumentTypes.length == 1 && InheritanceUtil.isInheritor((PsiType)argumentTypes[0], (String)"java.util.Map"))) {
                    this.checkDefaultMapConstructor(argList, element);
                }
            }
        }

        private void checkDefaultMapConstructor(GrArgumentList argList, PsiElement element) {
            GrNamedArgument[] args;
            if (argList == null) {
                return;
            }
            for (GrNamedArgument arg : args = argList.getNamedArguments()) {
                GrArgumentLabel label = arg.getLabel();
                if (label == null) continue;
                if (label.getName() == null) {
                    PsiElement nameElement = label.getNameElement();
                    if (nameElement instanceof GrExpression) {
                        PsiType argType = ((GrExpression)nameElement).getType();
                        if (argType == null || TypesUtil.isAssignableByMethodCallConversion((PsiType)TypesUtil.createType("java.lang.String", arg), argType, arg)) continue;
                        this.registerError(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                        continue;
                    }
                    if ("*".equals(nameElement.getText())) continue;
                    this.registerError(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                    continue;
                }
                PsiElement resolved = label.resolve();
                if (resolved != null) continue;
                if (element instanceof PsiMember && !(element instanceof PsiClass)) {
                    element = ((PsiMember)element).getContainingClass();
                }
                ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(2);
                if (element instanceof GrTypeDefinition) {
                    fixes.add(GroovyQuickFixFactory.getInstance().createCreateFieldFromConstructorLabelFix((GrTypeDefinition)element, label.getNamedArgument()));
                }
                if (element instanceof PsiClass) {
                    fixes.add(GroovyQuickFixFactory.getInstance().createDynamicPropertyFix(label, (PsiClass)element));
                }
                this.registerError((PsiElement)label, GroovyBundle.message("no.such.property", label.getName()), fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyConstructorNamedArgumentsInspection$MyVisitor", "visitNewExpression"));
        }
    }
}

