/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.IntentionUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/AddParenthesisToLambdaParameterAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "parameterList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;)V", "myLambda", "Lcom/intellij/psi/SmartPsiElementPointer;", "closureText", "", "lambda", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.groovy.psi"})
public final class AddParenthesisToLambdaParameterAction
implements IntentionAction {
    private final SmartPsiElementPointer<GrLambdaExpression> myLambda;

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.parenthesis.to.lambda.parameter.list", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"add.parenthesis\u2026o.lambda.parameter.list\")");
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GroovyPsiElement groovyPsiElement = (GrLambdaExpression)this.myLambda.getElement();
        if (groovyPsiElement == null || (groovyPsiElement = groovyPsiElement.getParameterList()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyPsiElement, (String)"myLambda.element?.parameterList ?: return false");
        GroovyPsiElement parameterList = groovyPsiElement;
        return parameterList.getLParen() == null;
        {
        }
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GrLambdaExpression grLambdaExpression = (GrLambdaExpression)this.myLambda.getElement();
        if (grLambdaExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grLambdaExpression, (String)"myLambda.element ?: return");
        GrLambdaExpression lambda2 = grLambdaExpression;
        String string = this.closureText(lambda2);
        if (string == null) {
            return;
        }
        String closureText = string;
        GrLambdaExpression grLambdaExpression2 = GroovyPsiElementFactory.getInstance(project).createLambdaFromText(closureText);
        Intrinsics.checkExpressionValueIsNotNull((Object)grLambdaExpression2, (String)"GroovyPsiElementFactory.\u2026mbdaFromText(closureText)");
        GrLambdaExpression closure = grLambdaExpression2;
        lambda2.replaceWithExpression(closure, false);
    }

    private final String closureText(GrLambdaExpression lambda2) {
        StringBuilder closureText = new StringBuilder();
        closureText.append("(");
        GrParameterList grParameterList = lambda2.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)grParameterList, (String)"lambda.parameterList");
        GrParameterList parameterList = grParameterList;
        String string = parameterList.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parameterList.text");
        IntentionUtilKt.appendTextBetween(closureText, string, parameterList.getLParen(), parameterList.getRParen());
        closureText.append(")");
        String string2 = lambda2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"lambda.text");
        IntentionUtilKt.appendTextBetween(closureText, string2, parameterList, null);
        return closureText.toString();
    }

    public AddParenthesisToLambdaParameterAction(@NotNull GrLambdaExpression parameterList) {
        Intrinsics.checkParameterIsNotNull((Object)parameterList, (String)"parameterList");
        this.myLambda = PointersKt.createSmartPointer$default((PsiElement)parameterList, null, (int)1, null);
    }
}

