/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre18;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "version", "", "(Lcom/intellij/lang/annotation/AnnotationHolder;Ljava/lang/String;)V", "highlightMultilineSlashyString", "", "string", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "visitLiteralExpression", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "visitMethodCall", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "visitRegexExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrRegex;", "visitTypeArgumentList", "typeArgumentList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeArgumentList;", "intellij.groovy.psi"})
public final class GroovyAnnotatorPre18
extends GroovyElementVisitor {
    private final AnnotationHolder holder;
    private final String version;

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        Intrinsics.checkParameterIsNotNull((Object)typeArgumentList, (String)"typeArgumentList");
        if (typeArgumentList.isDiamond()) {
            this.holder.createErrorAnnotation((PsiElement)typeArgumentList, GroovyBundle.message("unsupported.diamonds.0", this.version));
        }
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        if (call.isCommandExpression()) {
            this.holder.createErrorAnnotation((PsiElement)call, GroovyBundle.message("unsupported.command.syntax.0", this.version));
        }
    }

    @Override
    public void visitRegexExpression(@NotNull GrRegex expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        ASTNode aSTNode = expression.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"expression.node");
        ASTNode aSTNode2 = aSTNode.getFirstChildNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"expression.node.firstChildNode");
        IElementType iElementType = aSTNode2.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.node.firstChildNode.elementType");
        IElementType tokenType = iElementType;
        if (Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.DOLLAR_SLASHY_BEGIN)) {
            this.holder.createErrorAnnotation((PsiElement)expression, GroovyBundle.message("unsupported.dollar.slashy.string.0", this.version));
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.SLASHY_BEGIN)) {
            this.highlightMultilineSlashyString(expression);
        }
    }

    @Override
    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        Intrinsics.checkParameterIsNotNull((Object)literal, (String)"literal");
        ASTNode aSTNode = literal.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"literal.node");
        ASTNode aSTNode2 = aSTNode.getFirstChildNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"literal.node.firstChildNode");
        IElementType iElementType = aSTNode2.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"literal.node.firstChildNode.elementType");
        IElementType tokenType = iElementType;
        if (Intrinsics.areEqual((Object)tokenType, (Object)((Object)GroovyElementTypes.DOLLAR_SLASHY_LITERAL))) {
            this.holder.createErrorAnnotation((PsiElement)literal, GroovyBundle.message("unsupported.dollar.slashy.string.0", this.version));
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)((Object)GroovyElementTypes.SLASHY_LITERAL))) {
            this.highlightMultilineSlashyString(literal);
        }
    }

    private final void highlightMultilineSlashyString(GroovyPsiElement string) {
        String string2 = string.getText();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        String string3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"\n", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"\r", (boolean)false, (int)2, null)) {
            this.holder.createErrorAnnotation((PsiElement)string, GroovyBundle.message("unsupported.multiline.slashy.string.0", this.version));
        }
    }

    public GroovyAnnotatorPre18(@NotNull AnnotationHolder holder, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.holder = holder;
        this.version = version;
    }
}

