/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class NewGroovyActionBase
extends CreateElementActionBase {
    @NonNls
    public static final String GROOVY_EXTENSION = ".groovy";

    public NewGroovyActionBase(@Nls(capitalization=Nls.Capitalization.Title) String text, @Nls(capitalization=Nls.Capitalization.Sentence) String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Messages.showInputDialog((Project)project, (String)this.getDialogPrompt(), (String)this.getDialogTitle(), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            NewGroovyActionBase.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    protected abstract String getDialogPrompt();

    protected abstract String getDialogTitle();

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return GroovyFacetUtil.isSuitableModule(module) && LibrariesUtil.hasGroovySdk(module);
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, PsiDirectory directory) throws Exception {
        if (newName == null) {
            NewGroovyActionBase.$$$reportNull$$$0(1);
        }
        PsiElement[] psiElementArray = this.doCreate(newName, directory);
        if (psiElementArray == null) {
            NewGroovyActionBase.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @NotNull
    protected abstract PsiElement[] doCreate(String var1, PsiDirectory var2) throws Exception;

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/actions/NewGroovyActionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/actions/NewGroovyActionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

