/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationAwareInjector;
import org.intellij.plugins.intelliLang.inject.groovy.GrInjectionUtil;
import org.intellij.plugins.intelliLang.inject.java.JavaLanguageInjectionSupport;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;

public class GroovyLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NonNls
    public static final String GROOVY_SUPPORT_ID = "groovy";

    @NotNull
    public String getId() {
        if (GROOVY_SUPPORT_ID == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return GROOVY_SUPPORT_ID;
    }

    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{GroovyPatterns.class};
        if (classArray == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<? super PsiElement> commentRef) {
        PsiFile containingFile;
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        boolean compiled = (containingFile = host.getContainingFile()) != null && containingFile.getOriginalFile() instanceof PsiCompiledFile;
        return compiled ? null : super.findCommentInjection(host, commentRef);
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof GroovyPsiElement;
    }

    public boolean useDefaultInjector(PsiLanguageInjectionHost host) {
        return true;
    }

    public String getHelpId() {
        return "reference.settings.language.injection.groovy";
    }

    public boolean addInjectionInPlace(Language language, @Nullable PsiLanguageInjectionHost psiElement) {
        if (language == null) {
            return false;
        }
        if (!GroovyLanguageInjectionSupport.isStringLiteral(psiElement)) {
            return false;
        }
        return GroovyLanguageInjectionSupport.doInject(language.getID(), (PsiElement)psiElement, psiElement);
    }

    public boolean removeInjectionInPlace(@Nullable PsiLanguageInjectionHost psiElement) {
        if (!GroovyLanguageInjectionSupport.isStringLiteral(psiElement)) {
            return false;
        }
        GrLiteralContainer host = (GrLiteralContainer)psiElement;
        HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap = new HashMap<BaseInjection, Pair<PsiMethod, Integer>>();
        ArrayList<PsiElement> annotations2 = new ArrayList<PsiElement>();
        Project project = host.getProject();
        Configuration configuration = Configuration.getProjectInstance((Project)project);
        GroovyLanguageInjectionSupport.collectInjections(host, configuration, (LanguageInjectionSupport)this, injectionsMap, annotations2);
        if (injectionsMap.isEmpty() && annotations2.isEmpty()) {
            return false;
        }
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>(injectionsMap.keySet());
        List newInjections = ContainerUtil.mapNotNull(originalInjections, (Function)((NullableFunction)injection -> {
            Pair pair = (Pair)injectionsMap.get(injection);
            String placeText = JavaLanguageInjectionSupport.getPatternStringForJavaPlace((PsiMethod)((PsiMethod)pair.first), (int)((Integer)pair.second));
            BaseInjection newInjection = injection.copy();
            newInjection.setPlaceEnabled(placeText, false);
            return InjectorUtils.canBeRemoved((BaseInjection)newInjection) ? null : newInjection;
        }));
        configuration.replaceInjectionsWithUndo(project, psiElement.getContainingFile(), newInjections, originalInjections, annotations2);
        return true;
    }

    private static void collectInjections(@NotNull GrLiteralContainer host, @NotNull Configuration configuration, @NotNull LanguageInjectionSupport support, final @NotNull HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap, final @NotNull ArrayList<PsiElement> annotations2) {
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(4);
        }
        if (support == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(5);
        }
        if (injectionsMap == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(6);
        }
        if (annotations2 == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(7);
        }
        new GrConcatenationAwareInjector.InjectionProcessor(configuration, support, new PsiElement[]{host}){

            @Override
            protected boolean processCommentInjectionInner(PsiVariable owner, PsiElement comment, BaseInjection injection) {
                ContainerUtil.addAll((Collection)annotations2, (Object[])new PsiElement[]{comment});
                return true;
            }

            @Override
            protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annos) {
                ContainerUtil.addAll((Collection)annotations2, (Object[])annos);
                return true;
            }

            @Override
            protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
                injectionsMap.put(injection, Pair.create((Object)method, (Object)paramIndex));
                return true;
            }
        }.processInjections();
    }

    private static boolean doInject(@NotNull String languageId, @NotNull PsiElement psiElement, @NotNull PsiLanguageInjectionHost host) {
        if (languageId == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(8);
        }
        if (psiElement == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(9);
        }
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(10);
        }
        PsiElement target = GroovyLanguageInjectionSupport.getTopLevelInjectionTarget(psiElement);
        PsiElement parent2 = target.getParent();
        Project project = psiElement.getProject();
        if (parent2 instanceof GrReturnStatement) {
            GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(parent2);
            if (owner instanceof GrOpenBlock && owner.getParent() instanceof GrMethod) {
                return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)((PsiMethod)owner.getParent()), (int)-1, (PsiLanguageInjectionHost)host, (String)languageId);
            }
        } else {
            Processor<PsiLanguageInjectionHost> fixer;
            if (parent2 instanceof GrMethod) {
                return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)((GrMethod)parent2), (int)-1, (PsiLanguageInjectionHost)host, (String)languageId);
            }
            if (parent2 instanceof GrAnnotationNameValuePair) {
                PsiElement resolved;
                PsiReference ref = parent2.getReference();
                if (ref != null && (resolved = ref.resolve()) instanceof PsiMethod) {
                    return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)((PsiMethod)resolved), (int)-1, (PsiLanguageInjectionHost)host, (String)languageId);
                }
            } else if (parent2 instanceof GrArgumentList && parent2.getParent() instanceof GrMethodCall) {
                int index;
                PsiMethod method = ((GrMethodCall)parent2.getParent()).resolveMethod();
                if (method != null && (index = GrInjectionUtil.findParameterIndex(target, (GrMethodCall)parent2.getParent())) >= 0) {
                    return JavaLanguageInjectionSupport.doInjectInJavaMethod((Project)project, (PsiMethod)method, (int)index, (PsiLanguageInjectionHost)host, (String)languageId);
                }
            } else if (parent2 instanceof GrAssignmentExpression) {
                PsiElement element;
                GrExpression expr = ((GrAssignmentExpression)parent2).getLValue();
                if (expr instanceof GrReferenceExpression && (element = ((GrReferenceExpression)expr).resolve()) != null) {
                    return GroovyLanguageInjectionSupport.doInject(languageId, element, host);
                }
            } else if (parent2 instanceof PsiVariable ? JavaLanguageInjectionSupport.doAddLanguageAnnotation((Project)project, (PsiModifierListOwner)((PsiModifierListOwner)parent2), (PsiLanguageInjectionHost)host, (String)languageId, fixer = GroovyLanguageInjectionSupport.getAnnotationFixer(project, languageId)) : target instanceof PsiVariable && !(target instanceof LightElement) && JavaLanguageInjectionSupport.doAddLanguageAnnotation((Project)project, (PsiModifierListOwner)((PsiModifierListOwner)target), (PsiLanguageInjectionHost)host, (String)languageId, fixer = GroovyLanguageInjectionSupport.getAnnotationFixer(project, languageId))) {
                return true;
            }
        }
        return false;
    }

    private static Processor<PsiLanguageInjectionHost> getAnnotationFixer(@NotNull Project project, @NotNull String languageId) {
        if (project == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(11);
        }
        if (languageId == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(12);
        }
        return host -> {
            if (host == null) {
                return false;
            }
            Configuration.AdvancedConfiguration configuration = Configuration.getProjectInstance((Project)project).getAdvancedConfiguration();
            boolean allowed = configuration.isSourceModificationAllowed();
            configuration.setSourceModificationAllowed(true);
            try {
                boolean bl = GroovyLanguageInjectionSupport.doInject(languageId, (PsiElement)host, host);
                return bl;
            }
            finally {
                configuration.setSourceModificationAllowed(allowed);
            }
        };
    }

    @Contract(value="null -> false")
    private static boolean isStringLiteral(@Nullable PsiLanguageInjectionHost element) {
        if (element instanceof GrStringContent) {
            return true;
        }
        if (element instanceof GrLiteral) {
            IElementType type2 = GrLiteralImpl.getLiteralType((GrLiteral)element);
            return TokenSets.STRING_LITERALS.contains(type2);
        }
        return false;
    }

    @NotNull
    public static PsiElement getTopLevelInjectionTarget(@NotNull PsiElement host) {
        if (host == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(13);
        }
        PsiElement target = host;
        PsiElement parent2 = target.getParent();
        while (parent2 != null) {
            if (!(parent2 instanceof GrBinaryExpression || parent2 instanceof GrString || parent2 instanceof GrParenthesizedExpression || parent2 instanceof GrConditionalExpression && ((GrConditionalExpression)parent2).getCondition() != target || parent2 instanceof GrAnnotationArrayInitializer)) {
                if (!(parent2 instanceof GrListOrMap)) break;
                parent2 = parent2.getParent();
            }
            target = parent2;
            parent2 = target.getParent();
        }
        PsiElement psiElement = target;
        if (psiElement == null) {
            GroovyLanguageInjectionSupport.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/groovy/GroovyLanguageInjectionSupport";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionsMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/groovy/GroovyLanguageInjectionSupport";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelInjectionTarget";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectInjections";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doInject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationFixer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelInjectionTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

