/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deploy.swapper.ClassRedefiner;
import com.android.tools.deploy.swapper.DexArchive;
import com.android.tools.deploy.swapper.DexArchiveComparator;
import com.android.tools.deploy.swapper.DexArchiveDatabase;
import com.android.tools.deploy.swapper.InstallerBasedClassRedefiner;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApkDump;
import com.android.tools.deployer.ApkFull;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.Logger;
import com.android.tools.deployer.StopWatch;
import com.android.utils.ILogger;
import com.google.protobuf.ByteString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;

public class Deployer {
    private static final ILogger LOGGER = Logger.getLogger(Deployer.class);
    private final String packageName;
    private final List<ApkFull> apks;
    private final AdbClient adb;
    private final DexArchiveDatabase db;
    private final Installer installer;
    private StopWatch stopWatch = new StopWatch();

    public Deployer(String packageName, List<String> apkPaths, InstallerCallBack cb, AdbClient adb, DexArchiveDatabase db, Installer installer) {
        this.packageName = packageName;
        this.adb = adb;
        this.db = db;
        this.installer = installer;
        this.apks = apkPaths.stream().map(ApkFull::new).collect(Collectors.toList());
    }

    public RunResponse install() throws IOException {
        for (ApkFull apk : this.apks) {
            this.cache(apk);
        }
        RunResponse response = new RunResponse();
        this.diffInstall(true, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ApkDump> diffInstall(boolean kill, RunResponse response) throws IOException {
        this.stopWatch.start();
        Map<String, ApkDump> dumps = this.installer.dump(this.packageName);
        this.stopWatch.mark("Dumps retrieved");
        try {
            Deployer.chechDumps(this.apks, dumps, response);
            if (response.status == RunResponse.Status.ERROR) {
                Map<String, ApkDump> map = dumps;
                return map;
            }
            this.generateHashs(this.apks, dumps, response);
            if (response.status == RunResponse.Status.NOT_INSTALLED) {
                Map<String, ApkDump> map = dumps;
                return map;
            }
            this.generateDiffs(this.apks, dumps, response);
        }
        finally {
            this.doInstall(kill);
        }
        return dumps;
    }

    public RunResponse fullSwap() throws IOException {
        RunResponse response = new RunResponse();
        Map<String, ApkDump> dumps = this.diffInstall(false, response);
        this.swap(response, dumps);
        return response;
    }

    private static void chechDumps(List<ApkFull> apks, Map<String, ApkDump> dumps, RunResponse response) {
        int remoteApks = dumps.size();
        if (remoteApks == 0) {
            response.status = RunResponse.Status.NOT_INSTALLED;
            response.errorMessage = "App not installed";
        } else if (remoteApks != apks.size()) {
            response.status = RunResponse.Status.ERROR;
            response.errorMessage = "Remote apks count differ, unable to generate a diff.";
        }
    }

    private RunResponse.Analysis findOrCreateAnalysis(RunResponse response, String apkName) {
        RunResponse.Analysis analysis = response.result.get(apkName);
        if (analysis == null) {
            analysis = new RunResponse.Analysis();
            response.result.put(apkName, analysis);
        }
        return analysis;
    }

    private void generateHashs(List<ApkFull> apks, Map<String, ApkDump> dumps, RunResponse response) {
        for (ApkFull apk : apks) {
            RunResponse.Analysis analysis = this.findOrCreateAnalysis(response, apk.getPath());
            analysis.localApkHash = apk.getDigest();
            String name = apk.retrieveOnDeviceName();
            ApkDump dump = dumps.get(name);
            if (dump == null) continue;
            analysis.remoteApkHash = dump.getDigest();
        }
    }

    private void generateDiffs(List<ApkFull> apks, Map<String, ApkDump> dumps, RunResponse response) {
        for (ApkFull apk : apks) {
            try {
                ApkDump dump = dumps.get(apk.retrieveOnDeviceName());
                if (dump == null) {
                    response.status = RunResponse.Status.ERROR;
                    response.errorMessage = "Cannot find dump for local apk: " + apk.getPath();
                    return;
                }
                RunResponse.Analysis analysis = this.findOrCreateAnalysis(response, apk.getPath());
                ApkDiffer apkDiffer1 = new ApkDiffer();
                analysis.diffs = apkDiffer1.diff(apk, dump);
                response.result.put(apk.getPath(), analysis);
            }
            catch (DeployerException e) {
                response.status = RunResponse.Status.ERROR;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                response.errorMessage = stringWriter.toString();
            }
        }
    }

    private void doInstall(boolean kill) {
        try {
            this.adb.installMultiple(this.apks, kill);
            this.stopWatch.mark("Install succeeded");
        }
        catch (DeployerException e) {
            this.stopWatch.mark("Install failed");
            LOGGER.error((Throwable)e, null, new Object[0]);
        }
    }

    private void swap(RunResponse response, Map<String, ApkDump> dumps) throws DeployerException {
        this.stopWatch.mark("Swap started.");
        InstallerBasedClassRedefiner redefiner = new InstallerBasedClassRedefiner(this.installer);
        Deploy.SwapRequest.Builder request = Deploy.SwapRequest.newBuilder();
        request.setPackageName(this.packageName);
        request.setRestartActivity(true);
        for (ApkFull apk : this.apks) {
            HashMap<String, ApkDiffer.ApkEntryStatus> diffs = response.result.get((Object)apk.getPath()).diffs;
            try {
                DexArchive newApk = this.cache(apk);
                if (diffs.isEmpty()) {
                    System.out.println("Swapper: apk " + apk.getPath() + " has not changed.");
                    continue;
                }
                System.out.println("Swapper found " + diffs.size() + " changes in apk '" + apk.getPath() + "'.");
                ApkDump apkDump = dumps.get(apk.retrieveOnDeviceName());
                DexArchive prevApk = DexArchive.buildFromDatabase(this.db, apkDump.getDigest());
                if (prevApk == null) {
                    System.out.println("Unable to retrieve apk in DB ''" + apkDump.getDigest() + "', skipping this apk.");
                    return;
                }
                DexArchiveComparator comparator = new DexArchiveComparator();
                comparator.compare((DexArchive)prevApk, (DexArchive)newApk).changedClasses.forEach(e -> request.addClasses((Deploy.ClassDef)Deploy.ClassDef.newBuilder().setName(e.name).setDex(ByteString.copyFrom((byte[])e.dex)).build()));
            }
            catch (Exception e2) {
                System.out.println("Error while creating proto");
                throw new DeployerException(e2);
            }
        }
        this.stopWatch.mark("Piping request...");
        ((ClassRedefiner)redefiner).redefine((Deploy.SwapRequest)request.build());
        this.stopWatch.mark("Swap finished.");
    }

    private DexArchive cache(ApkFull apk) throws IOException {
        DexArchive newApk = DexArchive.buildFromHostFileSystem(new ZipInputStream(new FileInputStream(apk.getPath())), apk.getDigest());
        newApk.cache(this.db);
        return newApk;
    }

    public static interface InstallerCallBack {
        public void onInstallationFinished(boolean var1);
    }

    public static class RunResponse {
        public Status status = Status.OK;
        public String errorMessage;
        public HashMap<String, Analysis> result = new HashMap();

        public static class Analysis {
            public HashMap<String, ApkDiffer.ApkEntryStatus> diffs;
            public String localApkHash;
            public String remoteApkHash;
        }

        public static enum Status {
            OK,
            NOT_INSTALLED,
            ERROR;

        }
    }
}

