/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.deployer.ApkFull;
import com.android.tools.deployer.DeployerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdbClient {
    private IDevice device;

    public AdbClient(IDevice device) {
        this.device = device;
    }

    public void shell(String[] parameters) throws DeployerException {
        try {
            this.device.executeShellCommand(String.join((CharSequence)" ", parameters), (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (Exception e) {
            throw new DeployerException("Unable to run shell command.", e);
        }
    }

    public byte[] shell(String[] parameters, byte[] input) throws DeployerException {
        System.out.println("SHELL:" + Arrays.toString(parameters));
        ByteArrayOutputReceiver receiver = null;
        try {
            receiver = new ByteArrayOutputReceiver();
            this.device.executeShellCommand(String.join((CharSequence)" ", parameters), (IShellOutputReceiver)receiver, (long)DdmPreferences.getTimeOut(), TimeUnit.MILLISECONDS, (InputStream)(input == null ? null : new ByteArrayInputStream(input)));
            byte[] byArray = receiver.toByteArray();
            return byArray;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            throw new DeployerException("Unable to run shell command", e);
        }
        finally {
            System.out.println("OUTPUT_START:");
            System.out.println(new String(receiver.toByteArray(), StandardCharsets.UTF_8));
            System.out.println("OUTPUT_END:");
        }
    }

    public void pull(String srcDirectory, String dstDirectory) throws DeployerException {
        try {
            final ArrayList files = new ArrayList();
            this.device.executeShellCommand("ls -A1 " + srcDirectory, (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    for (String line : lines) {
                        if (line.trim().isEmpty()) continue;
                        files.add(line.trim());
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            });
            String dirName = new File(srcDirectory).getName();
            File dstDir = new File(dstDirectory, dirName);
            dstDir.mkdirs();
            for (String file : files) {
                this.device.pullFile(srcDirectory + "/" + file, dstDir.getPath() + "/" + file);
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | SyncException | TimeoutException | IOException e) {
            throw new DeployerException("Unable to pull files.", e);
        }
    }

    public void installMultiple(List<ApkFull> apks, boolean kill) throws DeployerException {
        ArrayList<File> files = new ArrayList<File>();
        for (ApkFull apk : apks) {
            files.add(new File(apk.getPath()));
        }
        try {
            ArrayList<String> options = new ArrayList<String>();
            options.add("-t");
            options.add("-r");
            if (!kill) {
                options.add("--dont-kill");
            }
            this.device.installPackages(files, true, options, 10L, TimeUnit.SECONDS);
        }
        catch (InstallException e) {
            throw new DeployerException("Unable to install packages.", e);
        }
    }

    public List<String> getAbis() {
        return this.device.getAbis();
    }

    public void push(String from, String to) {
        try {
            this.device.pushFile(from, to);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e) {
            throw new DeployerException("Unable to push files", e);
        }
    }

    private class ByteArrayOutputReceiver
    implements IShellOutputReceiver {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();

        private ByteArrayOutputReceiver() {
        }

        public void addOutput(byte[] data, int offset, int length) {
            this.stream.write(data, offset, length);
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return false;
        }

        byte[] toByteArray() {
            return this.stream.toByteArray();
        }
    }
}

