/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deploy.swapper.ClassRedefiner;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.tools.jdi.SocketAttachingConnector;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

class JdiBasedClassRedefiner
extends ClassRedefiner {
    private static final long DEBUGGER_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private VirtualMachine vm;

    static VirtualMachine attach(String hostname, int portNumber) throws IOException, IllegalConnectorArgumentsException {
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        for (AttachingConnector connector : manager.attachingConnectors()) {
            if (!(connector instanceof SocketAttachingConnector)) continue;
            HashMap<String, Connector.Argument> args = new HashMap<String, Connector.Argument>(connector.defaultArguments());
            args.get("timeout").setValue(String.valueOf(DEBUGGER_TIMEOUT_MS));
            args.get("hostname").setValue(hostname);
            args.get("port").setValue("" + portNumber);
            return connector.attach(args);
        }
        return null;
    }

    JdiBasedClassRedefiner(VirtualMachine vm) {
        this.vm = vm;
    }

    @Override
    public void redefine(Deploy.SwapRequest request) {
        HashMap<ReferenceType, byte[]> redefinitionRequest = new HashMap<ReferenceType, byte[]>();
        for (Deploy.ClassDef redefinition : request.getClassesList()) {
            List<ReferenceType> classes = this.getReferenceTypeByName(redefinition.getName());
            for (ReferenceType classRef : classes) {
                redefinitionRequest.put(classRef, redefinition.getDex().toByteArray());
            }
        }
        this.vm.redefineClasses(redefinitionRequest);
    }

    List<ReferenceType> getReferenceTypeByName(String name) {
        return this.vm.classesByName(name);
    }

    boolean hasRedefineClassesCapabilities() {
        return this.vm.canRedefineClasses();
    }
}

