/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.swapper.DexArchive;
import com.android.tools.deploy.swapper.DexFile;
import com.android.tools.deploy.swapper.OnCacheDexFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DexArchiveDatabase {
    public DexArchive retrieveCache(String checksum) {
        HashMap<String, DexFile> dexFiles = new HashMap<String, DexFile>();
        List<DexFileEntry> dexFileEntries = this.getDexFiles(checksum);
        if (dexFileEntries == null) {
            return null;
        }
        for (DexFileEntry entry : dexFileEntries) {
            dexFiles.put(entry.name, new OnCacheDexFile(entry.checksum, entry.name, this.getDexFileIndex(entry.checksum), this));
        }
        return new DexArchive(checksum, dexFiles);
    }

    public void close() {
    }

    public abstract Map<String, Long> getClassesChecksum(int var1);

    public abstract List<DexFileEntry> getDexFiles(String var1);

    public abstract int getDexFileIndex(long var1);

    public abstract int addDexFile(long var1, String var3);

    public abstract void fillEntriesChecksum(int var1, Map<String, Long> var2);

    public abstract void fillDexFileList(String var1, List<Integer> var2);

    protected static class DexFileEntry
    implements Serializable {
        public final int index;
        public final long checksum;
        public final String name;

        public DexFileEntry(int index, long checksum, String name) {
            this.index = index;
            this.checksum = checksum;
            this.name = name;
        }
    }
}

