/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.swapper.DexArchive;
import com.android.tools.deploy.swapper.DexFile;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DexArchiveComparator {
    public Result compare(DexArchive oldApk, DexArchive newApk) {
        Map<String, DexFile> oldDexFiles = oldApk.getDexFiles();
        Map<String, DexFile> newDexFiles = newApk.getDexFiles();
        ArrayList<String> changedDexFiles = new ArrayList<String>(newDexFiles.size());
        if (oldDexFiles.size() != newDexFiles.size()) {
            throw new UnsupportedOperationException("new .dex added. Not supported.");
        }
        for (Map.Entry<String, DexFile> entry : newDexFiles.entrySet()) {
            String dexFileName = entry.getKey();
            DexFile newDexFile = entry.getValue();
            DexFile oldDexFile = oldDexFiles.get(dexFileName);
            assert (oldDexFile != null) : "Different dex file naming scheme between APK?";
            if (!oldDexFile.differs(newDexFile)) continue;
            changedDexFiles.add(dexFileName);
        }
        HashMap<String, Long> prevDexesChecksum = new HashMap<String, Long>();
        ArrayList<byte[]> newDexes = new ArrayList<byte[]>(changedDexFiles.size());
        for (String s : changedDexFiles) {
            prevDexesChecksum.putAll(oldDexFiles.get(s).getClasssesChecksum());
            newDexes.add(newDexFiles.get(s).getCode());
        }
        return this.compare(prevDexesChecksum, newDexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result compare(Map<String, Long> prevDexesChecksum, List<byte[]> newDexes) {
        Result result = new Result();
        NewDexConsumer newDexConsumer = new NewDexConsumer(prevDexesChecksum, result);
        if (newDexes.isEmpty()) {
            return result;
        }
        for (byte[] newDex : newDexes) {
            try {
                D8Command.Builder newBuilder = D8Command.builder();
                newBuilder.addDexProgramData(newDex, Origin.unknown());
                newBuilder.setDisableDesugaring(true);
                newBuilder.setProgramConsumer((ProgramConsumer)newDexConsumer);
                D8.run((D8Command)((D8Command)newBuilder.build()));
            }
            catch (CompilationFailedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!newDexConsumer.done) {
            DexArchiveComparator dexArchiveComparator = this;
            synchronized (dexArchiveComparator) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return result;
    }

    private byte[] getFileFromApk(File apk, String name) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(apk));
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals(name)) {
                int len;
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream dexContent = new ByteArrayOutputStream();
                while ((len = zis.read(buffer)) > 0) {
                    dexContent.write(buffer, 0, len);
                }
                zis.closeEntry();
                zis.close();
                return dexContent.toByteArray();
            }
            entry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return null;
    }

    private static String typeNameToClassName(String typeName) {
        assert (typeName.startsWith("L"));
        assert (typeName.endsWith(";"));
        return typeName.substring(1, typeName.length() - 1).replace('/', '.');
    }

    private class NewDexConsumer
    implements DexFilePerClassFileConsumer {
        private final Map<String, Long> prevDexesChecksum;
        private final Result result;
        private boolean done = false;

        private NewDexConsumer(Map<String, Long> prevDexesChecksum, Result result) {
            this.prevDexesChecksum = prevDexesChecksum;
            this.result = result;
        }

        public synchronized void accept(String name, byte[] newDexData, Set<String> descriptors, DiagnosticsHandler handler) {
            Long oldDexChecksum = this.prevDexesChecksum.get(name);
            if (oldDexChecksum == null) {
                this.result.addedClasses.add(new Entry(DexArchiveComparator.typeNameToClassName(name), newDexData));
            } else {
                CRC32 crc = new CRC32();
                crc.update(newDexData);
                if (crc.getValue() != oldDexChecksum.longValue()) {
                    this.result.changedClasses.add(new Entry(DexArchiveComparator.typeNameToClassName(name), newDexData));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(DiagnosticsHandler handler) {
            DexArchiveComparator dexArchiveComparator = DexArchiveComparator.this;
            synchronized (dexArchiveComparator) {
                this.done = true;
                DexArchiveComparator.this.notify();
            }
        }
    }

    public static class Result {
        public final List<Entry> changedClasses = new ArrayList<Entry>();
        public final List<Entry> addedClasses = new ArrayList<Entry>();
    }

    public static class Entry {
        public final String name;
        public final byte[] dex;

        public Entry(String name, byte[] dex) {
            this.name = name;
            this.dex = dex;
        }
    }
}

