/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageType;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImageDescriptor {
    private static final ConcurrentMap<String, Pair<Image, ImageLoader.Dimension2DDouble>> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    @NotNull
    final String path;
    public final double scale;
    @NotNull
    public final ImageType type;
    final boolean original;
    @NotNull
    public final ImageLoader.Dimension2DDouble origUsrSize;
    @Nullable
    static volatile LoadTimeConsumer loadTimeConsumer;

    /*
     * WARNING - void declaration
     */
    public ImageDescriptor(@NotNull String path, double scale, @NotNull ImageType imageType) {
        void type;
        if (path == null) {
            ImageDescriptor.$$$reportNull$$$0(0);
        }
        if (imageType == null) {
            ImageDescriptor.$$$reportNull$$$0(1);
        }
        this(path, scale, (ImageType)type, false);
    }

    public ImageDescriptor(double scale) {
        this("", scale, ImageType.IMG, false);
    }

    public static void setLoadTimeConsumer(@Nullable LoadTimeConsumer loadTimeConsumer) {
        ImageDescriptor.loadTimeConsumer = loadTimeConsumer;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.util.ImageLoader");
        if (logger == null) {
            ImageDescriptor.$$$reportNull$$$0(2);
        }
        return logger;
    }

    public static void clearCache() {
        ourCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    public ImageDescriptor(@NotNull String path, double scale, @NotNull ImageType type, boolean bl) {
        void original;
        if (path == null) {
            ImageDescriptor.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ImageDescriptor.$$$reportNull$$$0(4);
        }
        this.path = path;
        this.scale = scale;
        this.type = type;
        this.original = original;
        this.origUsrSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
    }

    @Nullable
    public Image load(boolean useCache) throws IOException {
        return this.load(useCache, null);
    }

    @Nullable
    public Image load(boolean useCache, @Nullable Class<?> resourceClass) throws IOException {
        Pair pair;
        if (StringUtilRt.isEmpty((CharSequence)this.path)) {
            ImageDescriptor.getLogger().warn("empty image path", new Throwable());
            return null;
        }
        if (resourceClass != null) {
            InputStream stream = resourceClass.getResourceAsStream(this.path);
            return stream == null ? null : this.loadFromStream(stream, resourceClass.getResource(this.path), null);
        }
        String cacheKey = null;
        if (useCache && (pair = (Pair)ourCache.get(cacheKey = this.path + (this.type == ImageType.SVG ? "_@" + this.scale + "x" : ""))) != null) {
            this.origUsrSize.setSize((ImageLoader.Dimension2DDouble)pair.second);
            return (Image)pair.first;
        }
        URL url = new URL(this.path);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            if (!this.original) {
                return null;
            }
            connection.addRequestProperty("User-Agent", "IntelliJ");
        }
        return this.loadFromStream(connection.getInputStream(), url, cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Image loadFromStream(@NotNull InputStream stream, @Nullable URL url, @Nullable String cacheKey) throws IOException {
        Image image;
        if (stream == null) {
            ImageDescriptor.$$$reportNull$$$0(5);
        }
        try {
            image = this.loadImpl(url, stream);
        }
        finally {
            stream.close();
        }
        if (image != null && cacheKey != null && 4L * (long)image.getWidth(null) * (long)image.getHeight(null) <= ImageLoader.CACHED_IMAGE_MAX_SIZE) {
            ourCache.put(cacheKey, (Pair<Image, ImageLoader.Dimension2DDouble>)Pair.create((Object)image, (Object)this.origUsrSize));
        }
        return image;
    }

    @Nullable
    private Image loadImpl(@Nullable URL url, @NotNull InputStream stream) throws IOException {
        Image image;
        if (stream == null) {
            ImageDescriptor.$$$reportNull$$$0(6);
        }
        LoadTimeConsumer loadTimeConsumer = ImageDescriptor.loadTimeConsumer;
        long start = StartUpMeasurer.isEnabled() || loadTimeConsumer != null ? StartUpMeasurer.getCurrentTime() : -1L;
        switch (this.type) {
            case SVG: {
                image = SVGLoader.load(url, stream, this.scale, this.origUsrSize);
                break;
            }
            case IMG: {
                image = this.loadImpl(stream);
                break;
            }
            default: {
                return null;
            }
        }
        if (start != -1L) {
            int duration = (int)(StartUpMeasurer.getCurrentTime() - start);
            IconLoadMeasurer.addDecoding(this.type, duration);
            if (loadTimeConsumer != null) {
                loadTimeConsumer.accept(this.type, duration);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Image loadImpl(@NotNull InputStream stream) {
        if (stream == null) {
            ImageDescriptor.$$$reportNull$$$0(7);
        }
        try {
            Image image;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (stream instanceof BufferExposingByteArrayInputStream) {
                BufferExposingByteArrayInputStream byteInput = (BufferExposingByteArrayInputStream)stream;
                image = toolkit.createImage(byteInput.getInternalBuffer(), 0, byteInput.available());
            } else {
                BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
                try {
                    FileUtilRt.copy((InputStream)stream, (OutputStream)outputStream);
                }
                finally {
                    stream.close();
                }
                image = toolkit.createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            }
            ImageDescriptor.waitForImage(image);
            this.origUsrSize.setSize((double)image.getWidth(null) / this.scale, (double)image.getHeight(null) / this.scale);
            return image;
        }
        catch (Exception ex) {
            ImageDescriptor.getLogger().error((Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
    }

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ImageLoader.ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            ImageDescriptor.getLogger().info((Throwable)ex);
        }
        return !mediatracker.isErrorID(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/icons/ImageDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/icons/ImageDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface LoadTimeConsumer {
        public void accept(@NotNull ImageType var1, int var2);
    }
}

