/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.tasks;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.jetbrains.plugins.gradle.tooling.tasks.ArtifactComponentNode;
import org.jetbrains.plugins.gradle.tooling.tasks.BaseComponentNode;
import org.jetbrains.plugins.gradle.tooling.tasks.ComponentNode;
import org.jetbrains.plugins.gradle.tooling.tasks.ConfigurationNode;
import org.jetbrains.plugins.gradle.tooling.tasks.ProjectComponentNode;
import org.jetbrains.plugins.gradle.tooling.tasks.ReferenceNode;

public class ComponentNodeDeserializer
implements JsonDeserializer<ComponentNode> {
    public ComponentNode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.get("configurationName") != null) {
            return (ComponentNode)context.deserialize(json, ConfigurationNode.class);
        }
        if (jsonObject.get("projectPath") != null) {
            return (ComponentNode)context.deserialize(json, ProjectComponentNode.class);
        }
        if (jsonObject.get("module") != null) {
            return (ComponentNode)context.deserialize(json, ArtifactComponentNode.class);
        }
        if (jsonObject.size() == 1 && jsonObject.get("id") != null) {
            return (ComponentNode)context.deserialize(json, ReferenceNode.class);
        }
        return (ComponentNode)context.deserialize(json, BaseComponentNode.class);
    }
}

