/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ThrowableConsumer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.ExternalProjectSerializationService;

public class ToolingStreamUtils {
    public static final String OBJECT_ID_FIELD = "objectID";

    @Nullable
    public static String readString(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(0);
        }
        IonType type = reader.next();
        ToolingStreamUtils.assertFieldName(reader, fieldName);
        if (type == null) {
            return null;
        }
        return reader.stringValue();
    }

    public static int readInt(@NotNull IonReader reader, @NotNull String fieldName) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(2);
        }
        reader.next();
        ToolingStreamUtils.assertFieldName(reader, fieldName);
        return reader.intValue();
    }

    public static boolean readBoolean(@NotNull IonReader reader, @NotNull String fieldName) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(3);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(4);
        }
        reader.next();
        ToolingStreamUtils.assertFieldName(reader, fieldName);
        return reader.booleanValue();
    }

    public static List<File> readFiles(@NotNull IonReader reader) {
        File file;
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(5);
        }
        reader.next();
        ArrayList<File> list = new ArrayList<File>();
        reader.stepIn();
        while ((file = ToolingStreamUtils.readFile(reader, null)) != null) {
            list.add(file);
        }
        reader.stepOut();
        return list;
    }

    public static Set<File> readFilesSet(@NotNull IonReader reader) {
        File file;
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(6);
        }
        reader.next();
        THashSet set = new THashSet();
        reader.stepIn();
        while ((file = ToolingStreamUtils.readFile(reader, null)) != null) {
            set.add(file);
        }
        reader.stepOut();
        return set;
    }

    @Nullable
    public static File readFile(@NotNull IonReader reader, @Nullable String fieldName) {
        String filePath;
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(7);
        }
        return (filePath = ToolingStreamUtils.readString(reader, fieldName)) == null ? null : new File(filePath);
    }

    public static <K, V> Map<K, V> readMap(@NotNull IonReader reader, @NotNull Getter<? extends K> keyReader, @NotNull Getter<? extends V> valueReader) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(8);
        }
        if (keyReader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(9);
        }
        if (valueReader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(10);
        }
        reader.next();
        reader.stepIn();
        THashMap map = new THashMap();
        while (reader.next() != null) {
            reader.stepIn();
            map.put(keyReader.get(), valueReader.get());
            reader.stepOut();
        }
        reader.stepOut();
        return map;
    }

    public static Map<String, Set<File>> readStringToFileSetMap(final @NotNull IonReader reader) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(11);
        }
        return ToolingStreamUtils.readMap(reader, new Getter<String>(){

            public String get() {
                return ToolingStreamUtils.readString(reader, null);
            }
        }, new Getter<Set<File>>(){

            public Set<File> get() {
                return ToolingStreamUtils.readFilesSet(reader);
            }
        });
    }

    public static void writeString(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable String value) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(12);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(13);
        }
        writer.setFieldName(fieldName);
        writer.writeString(value);
    }

    public static void writeBoolean(@NotNull IonWriter writer, @NotNull String fieldName, boolean value) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(14);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(15);
        }
        writer.setFieldName(fieldName);
        writer.writeBool(value);
    }

    public static void writeFile(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable File file) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(16);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(17);
        }
        ToolingStreamUtils.writeString(writer, fieldName, file == null ? null : file.getPath());
    }

    public static <K, V> void writeMap(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Map<K, V> map, @NotNull ThrowableConsumer<? super K, ? extends IOException> keyWriter, @NotNull ThrowableConsumer<? super V, ? extends IOException> valueWriter) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(18);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(19);
        }
        if (map == null) {
            ToolingStreamUtils.$$$reportNull$$$0(20);
        }
        if (keyWriter == null) {
            ToolingStreamUtils.$$$reportNull$$$0(21);
        }
        if (valueWriter == null) {
            ToolingStreamUtils.$$$reportNull$$$0(22);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            writer.stepIn(IonType.STRUCT);
            writer.setFieldName("key");
            keyWriter.consume(entry.getKey());
            writer.setFieldName("value");
            valueWriter.consume(entry.getValue());
            writer.stepOut();
        }
        writer.stepOut();
    }

    public static void writeFiles(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<File> files) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(23);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(24);
        }
        if (files == null) {
            ToolingStreamUtils.$$$reportNull$$$0(25);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (File file : files) {
            writer.writeString(file.getPath());
        }
        writer.stepOut();
    }

    public static void writeStrings(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<String> strings) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(26);
        }
        if (fieldName == null) {
            ToolingStreamUtils.$$$reportNull$$$0(27);
        }
        if (strings == null) {
            ToolingStreamUtils.$$$reportNull$$$0(28);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (String str : strings) {
            writer.writeString(str);
        }
        writer.stepOut();
    }

    public static Set<String> readStringSet(@NotNull IonReader reader) {
        String nextString;
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(29);
        }
        THashSet set = new THashSet();
        reader.next();
        reader.stepIn();
        while ((nextString = ToolingStreamUtils.readString(reader, null)) != null) {
            set.add(nextString);
        }
        reader.stepOut();
        return set;
    }

    public static ExternalDependency readDependency(@NotNull IonReader reader, @NotNull ExternalProjectSerializationService.ReadContext context) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(30);
        }
        if (context == null) {
            ToolingStreamUtils.$$$reportNull$$$0(31);
        }
        return ExternalProjectSerializationService.readDependency(reader, context);
    }

    public static void writeDependency(@NotNull IonWriter writer, @NotNull ExternalProjectSerializationService.WriteContext context, @NotNull ExternalDependency dependency) throws IOException {
        if (writer == null) {
            ToolingStreamUtils.$$$reportNull$$$0(32);
        }
        if (context == null) {
            ToolingStreamUtils.$$$reportNull$$$0(33);
        }
        if (dependency == null) {
            ToolingStreamUtils.$$$reportNull$$$0(34);
        }
        ExternalProjectSerializationService.writeDependency(writer, context, dependency);
    }

    public static void assertFieldName(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamUtils.$$$reportNull$$$0(35);
        }
        String readerFieldName = reader.getFieldName();
        assert (fieldName == null || fieldName.equals(readerFieldName)) : "Expected field name '" + fieldName + "', got `" + readerFieldName + "' ";
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        assert (t != null);
        T t2 = t;
        if (t2 == null) {
            ToolingStreamUtils.$$$reportNull$$$0(36);
        }
        return t2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyReader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueReader";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyWriter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueWriter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingStreamUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingStreamUtils";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readInt";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readBoolean";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readFilesSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readStringToFileSetMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeBoolean";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeMap";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeFiles";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readStringSet";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readDependency";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeDependency";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "assertFieldName";
                break;
            }
            case 36: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

