/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.MavenRepositoryModel;
import org.jetbrains.plugins.gradle.model.RepositoriesModel;
import org.jetbrains.plugins.gradle.tooling.internal.MavenRepositoryModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.RepositoriesModelImpl;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public class RepositoriesModelSerializationService
implements SerializationService<RepositoriesModel> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(RepositoriesModel repositoriesModel, Class<? extends RepositoriesModel> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = IonBinaryWriterBuilder.standard().build((OutputStream)out);
        try {
            RepositoriesModelSerializationService.write(writer, this.myWriteContext, repositoriesModel);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoriesModel read(byte[] object, Class<? extends RepositoriesModel> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            RepositoriesModel repositoriesModel = RepositoriesModelSerializationService.read(reader, this.myReadContext);
            return repositoriesModel;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends RepositoriesModel> getModelClass() {
        return RepositoriesModel.class;
    }

    private static void write(final IonWriter writer, final WriteContext context, final RepositoriesModel model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    RepositoriesModelSerializationService.writeRepositories(writer, context, model.getAll());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeRepositories(IonWriter writer, WriteContext context, Collection<MavenRepositoryModel> repositoryModels) throws IOException {
        writer.setFieldName("repositories");
        writer.stepIn(IonType.LIST);
        for (MavenRepositoryModel repositoryModel : repositoryModels) {
            RepositoriesModelSerializationService.writeRepositoryModel(writer, context, repositoryModel);
        }
        writer.stepOut();
    }

    private static void writeRepositoryModel(final IonWriter writer, WriteContext context, final MavenRepositoryModel repositoryModel) throws IOException {
        context.repositoryCollector.add(repositoryModel, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamUtils.writeString(writer, "name", repositoryModel.getName());
                    ToolingStreamUtils.writeString(writer, "url", repositoryModel.getUrl());
                }
                writer.stepOut();
            }
        });
    }

    @Nullable
    private static RepositoriesModel read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        RepositoriesModel model = context.objectMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<RepositoriesModelImpl>(){

            @Override
            public RepositoriesModelImpl create() {
                RepositoriesModelImpl repositoriesModel = new RepositoriesModelImpl();
                List repositoryModels = RepositoriesModelSerializationService.readRepositories(reader, context);
                for (MavenRepositoryModel entry : repositoryModels) {
                    repositoriesModel.add(entry);
                }
                return repositoriesModel;
            }
        });
        reader.stepOut();
        return model;
    }

    private static List<MavenRepositoryModel> readRepositories(IonReader reader, ReadContext context) {
        MavenRepositoryModel entry;
        ArrayList<MavenRepositoryModel> list = new ArrayList<MavenRepositoryModel>();
        reader.next();
        reader.stepIn();
        while ((entry = RepositoriesModelSerializationService.readRepositoryModel(reader, context)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static MavenRepositoryModel readRepositoryModel(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        MavenRepositoryModel dependency = context.repositoryMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<MavenRepositoryModel>(){

            @Override
            public MavenRepositoryModel create() {
                return new MavenRepositoryModelImpl(ToolingStreamUtils.readString(reader, "name"), ToolingStreamUtils.readString(reader, "url"));
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static class WriteContext {
        private final ObjectCollector<RepositoriesModel, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<MavenRepositoryModel, IOException> repositoryCollector = new ObjectCollector();

        private WriteContext() {
        }
    }

    private static class ReadContext {
        private final IntObjectMap<RepositoriesModelImpl> objectMap = new IntObjectMap();
        private final IntObjectMap<MavenRepositoryModel> repositoryMap = new IntObjectMap();

        private ReadContext() {
        }
    }
}

