/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultGradleConfiguration;
import org.jetbrains.plugins.gradle.model.DefaultGradleConvention;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtension;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.DefaultGradleProperty;
import org.jetbrains.plugins.gradle.model.GradleConfiguration;
import org.jetbrains.plugins.gradle.model.GradleConvention;
import org.jetbrains.plugins.gradle.model.GradleExtension;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public class GradleExtensionsSerializationService
implements SerializationService<GradleExtensions> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(GradleExtensions gradleExtensions, Class<? extends GradleExtensions> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = IonBinaryWriterBuilder.standard().build((OutputStream)out);
        try {
            GradleExtensionsSerializationService.write(writer, this.myWriteContext, gradleExtensions);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleExtensions read(byte[] object, Class<? extends GradleExtensions> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            GradleExtensions gradleExtensions = GradleExtensionsSerializationService.read(reader, this.myReadContext);
            return gradleExtensions;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends GradleExtensions> getModelClass() {
        return GradleExtensions.class;
    }

    private static void write(final IonWriter writer, final WriteContext context, final GradleExtensions model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamUtils.writeString(writer, "parentProjectPath", model.getParentProjectPath());
                    GradleExtensionsSerializationService.writeConfigurations(writer, context, model.getConfigurations());
                    GradleExtensionsSerializationService.writeConventions(writer, context, model.getConventions());
                    GradleExtensionsSerializationService.writeExtensions(writer, context, model.getExtensions());
                    GradleExtensionsSerializationService.writeGradleProperties(writer, context, model.getGradleProperties());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeConfigurations(IonWriter writer, WriteContext context, List<? extends GradleConfiguration> configurations) throws IOException {
        writer.setFieldName("configurations");
        writer.stepIn(IonType.LIST);
        for (GradleConfiguration gradleConfiguration : configurations) {
            GradleExtensionsSerializationService.writeConfiguration(writer, context, gradleConfiguration);
        }
        writer.stepOut();
    }

    static void writeConfiguration(final IonWriter writer, WriteContext context, final GradleConfiguration configuration) throws IOException {
        context.configurationsCollector.add(configuration, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamUtils.writeString(writer, "name", configuration.getName());
                    ToolingStreamUtils.writeString(writer, "description", configuration.getDescription());
                    ToolingStreamUtils.writeBoolean(writer, "visible", configuration.isVisible());
                    ToolingStreamUtils.writeBoolean(writer, "scriptClasspathConfiguration", configuration.isScriptClasspathConfiguration());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeConventions(IonWriter writer, WriteContext context, List<? extends GradleConvention> conventions) throws IOException {
        writer.setFieldName("conventions");
        writer.stepIn(IonType.LIST);
        for (GradleConvention gradleConvention : conventions) {
            GradleExtensionsSerializationService.write(writer, context, (GradleProperty)gradleConvention);
        }
        writer.stepOut();
    }

    private static void writeExtensions(IonWriter writer, WriteContext context, List<? extends GradleExtension> extensions) throws IOException {
        writer.setFieldName("extensions");
        writer.stepIn(IonType.LIST);
        for (GradleExtension gradleExtension : extensions) {
            GradleExtensionsSerializationService.write(writer, context, (GradleProperty)gradleExtension);
        }
        writer.stepOut();
    }

    private static void writeGradleProperties(IonWriter writer, WriteContext context, List<? extends GradleProperty> properties) throws IOException {
        writer.setFieldName("properties");
        writer.stepIn(IonType.LIST);
        for (GradleProperty gradleProperty : properties) {
            GradleExtensionsSerializationService.write(writer, context, gradleProperty);
        }
        writer.stepOut();
    }

    static void write(final IonWriter writer, WriteContext context, final GradleProperty property) throws IOException {
        context.propertiesCollector.add(property, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamUtils.writeString(writer, "name", property.getName());
                    ToolingStreamUtils.writeString(writer, "typeFqn", property.getTypeFqn());
                }
                writer.stepOut();
            }
        });
    }

    @Nullable
    private static GradleExtensions read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultGradleExtensions extensions = context.objectMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<DefaultGradleExtensions>(){

            @Override
            public DefaultGradleExtensions create() {
                DefaultGradleExtensions gradleExtensions = new DefaultGradleExtensions();
                gradleExtensions.setParentProjectPath(ToolingStreamUtils.readString(reader, "parentProjectPath"));
                gradleExtensions.getConfigurations().addAll(GradleExtensionsSerializationService.readConfigurations(reader, context));
                gradleExtensions.getConventions().addAll(GradleExtensionsSerializationService.readConventions(reader, context));
                gradleExtensions.getExtensions().addAll(GradleExtensionsSerializationService.readExtensions(reader, context));
                gradleExtensions.getGradleProperties().addAll(GradleExtensionsSerializationService.readGradleProperties(reader, context));
                return gradleExtensions;
            }
        });
        reader.stepOut();
        return extensions;
    }

    private static List<DefaultGradleConfiguration> readConfigurations(IonReader reader, ReadContext context) {
        DefaultGradleConfiguration configuration;
        ArrayList<DefaultGradleConfiguration> list = new ArrayList<DefaultGradleConfiguration>();
        reader.next();
        reader.stepIn();
        while ((configuration = GradleExtensionsSerializationService.readConfiguration(reader, context)) != null) {
            list.add(configuration);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static DefaultGradleConfiguration readConfiguration(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultGradleConfiguration configuration = context.configurationsMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<DefaultGradleConfiguration>(){

            @Override
            public DefaultGradleConfiguration create() {
                return new DefaultGradleConfiguration(ToolingStreamUtils.assertNotNull(ToolingStreamUtils.readString(reader, "name")), ToolingStreamUtils.readString(reader, "description"), ToolingStreamUtils.readBoolean(reader, "visible"), ToolingStreamUtils.readBoolean(reader, "scriptClasspathConfiguration"));
            }
        });
        reader.stepOut();
        return configuration;
    }

    private static List<DefaultGradleConvention> readConventions(IonReader reader, ReadContext context) {
        DefaultGradleConvention entry;
        ArrayList<DefaultGradleConvention> list = new ArrayList<DefaultGradleConvention>();
        reader.next();
        reader.stepIn();
        while ((entry = GradleExtensionsSerializationService.readConvention(reader, context)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static DefaultGradleConvention readConvention(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultGradleConvention convention = context.conventionsMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<DefaultGradleConvention>(){

            @Override
            public DefaultGradleConvention create() {
                return new DefaultGradleConvention(ToolingStreamUtils.assertNotNull(ToolingStreamUtils.readString(reader, "name")), ToolingStreamUtils.readString(reader, "typeFqn"));
            }
        });
        reader.stepOut();
        return convention;
    }

    private static List<DefaultGradleExtension> readExtensions(IonReader reader, ReadContext context) {
        DefaultGradleExtension entry;
        ArrayList<DefaultGradleExtension> list = new ArrayList<DefaultGradleExtension>();
        reader.next();
        reader.stepIn();
        while ((entry = GradleExtensionsSerializationService.readExtension(reader, context)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static DefaultGradleExtension readExtension(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultGradleExtension convention = context.extensionsMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<DefaultGradleExtension>(){

            @Override
            public DefaultGradleExtension create() {
                return new DefaultGradleExtension(ToolingStreamUtils.assertNotNull(ToolingStreamUtils.readString(reader, "name")), ToolingStreamUtils.readString(reader, "typeFqn"));
            }
        });
        reader.stepOut();
        return convention;
    }

    private static List<DefaultGradleProperty> readGradleProperties(IonReader reader, ReadContext context) {
        DefaultGradleProperty entry;
        ArrayList<DefaultGradleProperty> list = new ArrayList<DefaultGradleProperty>();
        reader.next();
        reader.stepIn();
        while ((entry = GradleExtensionsSerializationService.readGradleProperty(reader, context)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static DefaultGradleProperty readGradleProperty(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultGradleProperty convention = context.propertiesMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<DefaultGradleProperty>(){

            @Override
            public DefaultGradleProperty create() {
                return new DefaultGradleProperty(ToolingStreamUtils.assertNotNull(ToolingStreamUtils.readString(reader, "name")), ToolingStreamUtils.readString(reader, "typeFqn"));
            }
        });
        reader.stepOut();
        return convention;
    }

    private static class WriteContext {
        private final ObjectCollector<GradleExtensions, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<GradleConfiguration, IOException> configurationsCollector = new ObjectCollector();
        private final ObjectCollector<GradleProperty, IOException> propertiesCollector = new ObjectCollector();

        private WriteContext() {
        }
    }

    private static class ReadContext {
        private final IntObjectMap<DefaultGradleExtensions> objectMap = new IntObjectMap();
        private final IntObjectMap<DefaultGradleConfiguration> configurationsMap = new IntObjectMap();
        private final IntObjectMap<DefaultGradleConvention> conventionsMap = new IntObjectMap();
        private final IntObjectMap<DefaultGradleExtension> extensionsMap = new IntObjectMap();
        private final IntObjectMap<DefaultGradleProperty> propertiesMap = new IntObjectMap();

        private ReadContext() {
        }
    }
}

