/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public class BuildScriptClasspathModelSerializationService
implements SerializationService<BuildScriptClasspathModel> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(BuildScriptClasspathModel classpathModel, Class<? extends BuildScriptClasspathModel> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = IonBinaryWriterBuilder.standard().build((OutputStream)out);
        try {
            BuildScriptClasspathModelSerializationService.write(writer, this.myWriteContext, classpathModel);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildScriptClasspathModel read(byte[] object, Class<? extends BuildScriptClasspathModel> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            BuildScriptClasspathModel buildScriptClasspathModel = BuildScriptClasspathModelSerializationService.read(reader, this.myReadContext);
            return buildScriptClasspathModel;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends BuildScriptClasspathModel> getModelClass() {
        return BuildScriptClasspathModel.class;
    }

    private static void write(final IonWriter writer, WriteContext context, final BuildScriptClasspathModel model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamUtils.writeString(writer, "gradleVersion", model.getGradleVersion());
                    ToolingStreamUtils.writeFile(writer, "gradleHomeDir", model.getGradleHomeDir());
                    BuildScriptClasspathModelSerializationService.writeClasspath(writer, (Set)model.getClasspath());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeClasspath(IonWriter writer, Set<? extends ClasspathEntryModel> classpath) throws IOException {
        writer.setFieldName("classpath");
        writer.stepIn(IonType.LIST);
        for (ClasspathEntryModel classpathEntryModel : classpath) {
            BuildScriptClasspathModelSerializationService.writeClasspathEntry(writer, classpathEntryModel);
        }
        writer.stepOut();
    }

    private static void writeClasspathEntry(IonWriter writer, ClasspathEntryModel entry) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamUtils.writeStrings(writer, "classes", entry.getClasses());
        ToolingStreamUtils.writeStrings(writer, "sources", entry.getSources());
        ToolingStreamUtils.writeStrings(writer, "javadoc", entry.getJavadoc());
        writer.stepOut();
    }

    @Nullable
    private static BuildScriptClasspathModel read(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        BuildScriptClasspathModelImpl model = context.objectMap.computeIfAbsent(ToolingStreamUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<BuildScriptClasspathModelImpl>(){

            @Override
            public BuildScriptClasspathModelImpl create() {
                BuildScriptClasspathModelImpl classpathModel = new BuildScriptClasspathModelImpl();
                classpathModel.setGradleVersion(ToolingStreamUtils.assertNotNull(ToolingStreamUtils.readString(reader, "gradleVersion")));
                classpathModel.setGradleHomeDir(ToolingStreamUtils.readFile(reader, "gradleHomeDir"));
                List classpathEntries = BuildScriptClasspathModelSerializationService.readClasspath(reader);
                for (ClasspathEntryModel entry : classpathEntries) {
                    classpathModel.add(entry);
                }
                return classpathModel;
            }
        });
        reader.stepOut();
        return model;
    }

    private static List<ClasspathEntryModel> readClasspath(IonReader reader) {
        ClasspathEntryModel entry;
        ArrayList<ClasspathEntryModel> list = new ArrayList<ClasspathEntryModel>();
        reader.next();
        reader.stepIn();
        while ((entry = BuildScriptClasspathModelSerializationService.readClasspathEntry(reader)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    private static ClasspathEntryModel readClasspathEntry(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ClasspathEntryModelImpl entryModel = new ClasspathEntryModelImpl(ToolingStreamUtils.readStringSet(reader), ToolingStreamUtils.readStringSet(reader), ToolingStreamUtils.readStringSet(reader));
        reader.stepOut();
        return entryModel;
    }

    private static class WriteContext {
        private final ObjectCollector<BuildScriptClasspathModel, IOException> objectCollector = new ObjectCollector();

        private WriteContext() {
        }
    }

    private static class ReadContext {
        private final IntObjectMap<BuildScriptClasspathModelImpl> objectMap = new IntObjectMap();

        private ReadContext() {
        }
    }
}

