/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.FilePatternSet;
import org.jetbrains.plugins.gradle.model.FilePatternSetImpl;

public final class DefaultExternalSourceDirectorySet
implements ExternalSourceDirectorySet {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String name;
    @NotNull
    private Set<File> srcDirs;
    private File outputDir;
    private final List<File> gradleOutputDirs;
    private final FilePatternSetImpl patterns;
    @NotNull
    private List<DefaultExternalFilter> filters;
    private boolean inheritedCompilerOutput;

    public DefaultExternalSourceDirectorySet() {
        this.srcDirs = new HashSet<File>(0);
        this.filters = new ArrayList<DefaultExternalFilter>(0);
        this.gradleOutputDirs = new ArrayList<File>(0);
        this.patterns = new FilePatternSetImpl();
    }

    public DefaultExternalSourceDirectorySet(ExternalSourceDirectorySet sourceDirectorySet) {
        this.name = sourceDirectorySet.getName();
        this.srcDirs = new HashSet<File>(sourceDirectorySet.getSrcDirs());
        this.outputDir = sourceDirectorySet.getOutputDir();
        this.gradleOutputDirs = new ArrayList<File>(sourceDirectorySet.getGradleOutputDirs());
        this.patterns = new FilePatternSetImpl(sourceDirectorySet.getIncludes(), sourceDirectorySet.getExcludes());
        this.filters = new ArrayList<DefaultExternalFilter>(sourceDirectorySet.getFilters().size());
        for (ExternalFilter filter : sourceDirectorySet.getFilters()) {
            this.filters.add(new DefaultExternalFilter(filter));
        }
        this.inheritedCompilerOutput = sourceDirectorySet.isCompilerOutputPathInherited();
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(1);
        }
        this.name = name;
    }

    @NotNull
    public Set<File> getSrcDirs() {
        Set<File> set = this.srcDirs;
        if (set == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void setSrcDirs(@NotNull Set<File> srcDirs) {
        if (srcDirs == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(3);
        }
        this.srcDirs = srcDirs;
    }

    @NotNull
    public File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(4);
        }
        return file;
    }

    public void setOutputDir(@NotNull File outputDir) {
        if (outputDir == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(5);
        }
        this.outputDir = outputDir;
    }

    @NotNull
    public File getGradleOutputDir() {
        assert (this.gradleOutputDirs.size() > 0);
        File file = this.gradleOutputDirs.get(0);
        if (file == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public Collection<File> getGradleOutputDirs() {
        List<File> list = this.gradleOutputDirs;
        if (list == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void addGradleOutputDir(@NotNull File outputDir) {
        if (outputDir == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(8);
        }
        this.gradleOutputDirs.add(outputDir);
    }

    public boolean isCompilerOutputPathInherited() {
        return this.inheritedCompilerOutput;
    }

    @NotNull
    public Set<String> getExcludes() {
        Set<String> set = this.patterns.getExcludes();
        if (set == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(9);
        }
        return set;
    }

    public void setExcludes(Set<String> excludes) {
        this.patterns.setExcludes(excludes);
    }

    @NotNull
    public Set<String> getIncludes() {
        Set<String> set = this.patterns.getIncludes();
        if (set == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(10);
        }
        return set;
    }

    public void setIncludes(Set<String> includes) {
        this.patterns.setIncludes(includes);
    }

    @NotNull
    public FilePatternSet getPatterns() {
        FilePatternSetImpl filePatternSetImpl = this.patterns;
        if (filePatternSetImpl == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(11);
        }
        return filePatternSetImpl;
    }

    public void setInheritedCompilerOutput(boolean inheritedCompilerOutput) {
        this.inheritedCompilerOutput = inheritedCompilerOutput;
    }

    @NotNull
    public List<? extends ExternalFilter> getFilters() {
        List<DefaultExternalFilter> list = this.filters;
        if (list == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void setFilters(@NotNull List<DefaultExternalFilter> filters) {
        if (filters == null) {
            DefaultExternalSourceDirectorySet.$$$reportNull$$$0(13);
        }
        this.filters = filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcDirs";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSrcDirs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleOutputDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleOutputDirs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSrcDirs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOutputDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addGradleOutputDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

