/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;

public class DefaultExternalProjectDependency
extends AbstractExternalDependency
implements ExternalProjectDependency {
    private static final long serialVersionUID = 1L;
    private String projectPath;
    private String configurationName = "default";
    private Collection<File> projectDependencyArtifacts;
    private Collection<File> projectDependencyArtifactsSources;

    public DefaultExternalProjectDependency() {
    }

    public DefaultExternalProjectDependency(ExternalProjectDependency dependency) {
        super((ExternalDependency)dependency);
        this.projectPath = dependency.getProjectPath();
        this.configurationName = dependency.getConfigurationName();
        this.projectDependencyArtifacts = dependency.getProjectDependencyArtifacts() == null ? new ArrayList<File>() : new ArrayList(dependency.getProjectDependencyArtifacts());
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
        if (!"default".equals(configurationName)) {
            this.setClassifier(configurationName);
        }
    }

    public Collection<File> getProjectDependencyArtifacts() {
        return this.projectDependencyArtifacts;
    }

    public void setProjectDependencyArtifacts(Collection<File> projectArtifacts) {
        this.projectDependencyArtifacts = projectArtifacts;
    }

    public Collection<File> getProjectDependencyArtifactsSources() {
        return this.projectDependencyArtifactsSources;
    }

    public void setProjectDependencyArtifactsSources(Collection<File> projectArtifactsSources) {
        this.projectDependencyArtifactsSources = projectArtifactsSources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultExternalProjectDependency)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultExternalProjectDependency that = (DefaultExternalProjectDependency)o;
        return Objects.equal((Object)this.projectPath, (Object)that.projectPath) && Objects.equal((Object)this.configurationName, (Object)that.configurationName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.projectPath, this.configurationName});
    }

    public String toString() {
        return "project dependency '" + this.projectPath + ", " + this.configurationName + '\'';
    }
}

