/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;

public class DebugLocalsChange
extends Instruction {
    private final Int2ReferenceMap<DebugLocalInfo> ending;
    private final Int2ReferenceMap<DebugLocalInfo> starting;

    public DebugLocalsChange(Int2ReferenceMap<DebugLocalInfo> ending, Int2ReferenceMap<DebugLocalInfo> starting) {
        super(null);
        assert (!ending.isEmpty() || !starting.isEmpty());
        this.ending = ending;
        this.starting = starting;
        super.setPosition(Position.none());
    }

    @Override
    public void setPosition(Position position) {
        throw new Unreachable();
    }

    @Override
    public boolean verifyValidPositionInfo(boolean debug) {
        return true;
    }

    public Int2ReferenceMap<DebugLocalInfo> getEnding() {
        return this.ending;
    }

    public Int2ReferenceMap<DebugLocalInfo> getStarting() {
        return this.starting;
    }

    @Override
    public boolean isDebugLocalsChange() {
        return true;
    }

    @Override
    public DebugLocalsChange asDebugLocalsChange() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addNothing(this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isDebugLocalsChange()) {
            return false;
        }
        DebugLocalsChange o = other.asDebugLocalsChange();
        return DebugLocalInfo.localsInfoMapsEqual(this.ending, o.ending) && DebugLocalInfo.localsInfoMapsEqual(this.starting, o.starting);
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isDebugLocalsChange());
        return 0;
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable();
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable();
    }

    @Override
    public boolean canBeDeadCode(IRCode code, InternalOptions options) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("ending: ");
        StringUtils.append(builder, this.ending.int2ReferenceEntrySet());
        builder.append(", starting: ");
        StringUtils.append(builder, this.starting.int2ReferenceEntrySet());
        return builder.toString();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forDebugLocalsChange();
    }

    public boolean apply(Int2ReferenceMap<DebugLocalInfo> locals) {
        boolean changed = false;
        for (Int2ReferenceMap.Entry entry : this.getEnding().int2ReferenceEntrySet()) {
            assert (locals.get(entry.getIntKey()) == entry.getValue());
            if (locals.remove(entry.getIntKey()) == null) continue;
            changed = true;
        }
        for (Int2ReferenceMap.Entry entry : this.getStarting().int2ReferenceEntrySet()) {
            assert (!locals.containsKey(entry.getIntKey()));
            DebugLocalInfo old = locals.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            changed |= old == null || old != entry.getValue();
        }
        return changed;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable();
    }
}

