/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.VMRuntime;
import java.lang.ref.Reference;
import libcore.util.Cleaner;
import libcore.util.NativeAllocationRegistry_Delegate;

public class NativeAllocationRegistry {
    private final ClassLoader classLoader;
    public final long freeFunction;
    public final long size;
    private static final long IS_MALLOCED = 1L;

    public static NativeAllocationRegistry createNonmalloced(ClassLoader classLoader, long freeFunction, long size) {
        return new NativeAllocationRegistry(classLoader, freeFunction, size, false);
    }

    public static NativeAllocationRegistry createMalloced(ClassLoader classLoader, long freeFunction, long size) {
        return new NativeAllocationRegistry(classLoader, freeFunction, size, true);
    }

    public static NativeAllocationRegistry createMalloced(ClassLoader classLoader, long freeFunction) {
        return new NativeAllocationRegistry(classLoader, freeFunction, 0L, true);
    }

    private NativeAllocationRegistry(ClassLoader classLoader, long freeFunction, long size, boolean mallocAllocation) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid native allocation size: " + size);
        }
        this.classLoader = classLoader;
        this.freeFunction = freeFunction;
        this.size = mallocAllocation ? size | 1L : size & 0xFFFFFFFFFFFFFFFEL;
    }

    public NativeAllocationRegistry(ClassLoader classLoader, long freeFunction, long size) {
        this(classLoader, freeFunction, size, size == 0L);
    }

    public Runnable registerNativeAllocation_Original(Object referent, long nativePtr) {
        CleanerRunner result;
        CleanerThunk thunk;
        if (referent == null) {
            throw new IllegalArgumentException("referent is null");
        }
        if (nativePtr == 0L) {
            throw new IllegalArgumentException("nativePtr is null");
        }
        try {
            thunk = new CleanerThunk();
            Cleaner cleaner = Cleaner.create(referent, thunk);
            result = new CleanerRunner(cleaner);
            NativeAllocationRegistry.registerNativeAllocation(this.size);
        }
        catch (VirtualMachineError vme) {
            NativeAllocationRegistry.applyFreeFunction(this.freeFunction, nativePtr);
            throw vme;
        }
        thunk.setNativePtr(nativePtr);
        Reference.reachabilityFence(referent);
        return result;
    }

    @LayoutlibDelegate
    public Runnable registerNativeAllocation(Object object, long l) {
        return NativeAllocationRegistry_Delegate.registerNativeAllocation(this, object, l);
    }

    static void registerNativeAllocation_Original(long size) {
        VMRuntime runtime = VMRuntime.getRuntime();
        if ((size & 1L) != 0L) {
            long notifyImmediateThreshold = 300000L;
            if (size >= 300000L) {
                runtime.notifyNativeAllocationsInternal();
            } else {
                runtime.notifyNativeAllocation();
            }
        } else {
            runtime.registerNativeAllocation(size);
        }
    }

    @LayoutlibDelegate
    private static void registerNativeAllocation(long l) {
        NativeAllocationRegistry_Delegate.registerNativeAllocation(l);
    }

    private static void registerNativeFree(long size) {
        if ((size & 1L) == 0L) {
            VMRuntime.getRuntime().registerNativeFree(size);
        }
    }

    @LayoutlibDelegate
    public static void applyFreeFunction(long l, long l2) {
        NativeAllocationRegistry_Delegate.applyFreeFunction(l, l2);
    }

    private static class CleanerRunner
    implements Runnable {
        private final Cleaner cleaner;

        public CleanerRunner(Cleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        public void run() {
            this.cleaner.clean();
        }
    }

    private class CleanerThunk
    implements Runnable {
        private long nativePtr = 0L;

        @Override
        public void run() {
            if (this.nativePtr != 0L) {
                NativeAllocationRegistry.applyFreeFunction(NativeAllocationRegistry.this.freeFunction, this.nativePtr);
                NativeAllocationRegistry.registerNativeFree(NativeAllocationRegistry.this.size);
            }
        }

        public void setNativePtr(long nativePtr) {
            this.nativePtr = nativePtr;
        }
    }
}

