/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;

public class Cleaner
extends PhantomReference<Object> {
    private static final ReferenceQueue<Object> dummyQueue = new ReferenceQueue();
    private static Cleaner first = null;
    private Cleaner next = null;
    private Cleaner prev = null;
    private final Runnable thunk;

    private static synchronized Cleaner add(Cleaner cl) {
        if (first != null) {
            cl.next = first;
            Cleaner.first.prev = cl;
        }
        first = cl;
        return cl;
    }

    private static synchronized boolean remove(Cleaner cl) {
        if (cl.next == cl) {
            return false;
        }
        if (first == cl) {
            first = cl.next != null ? cl.next : cl.prev;
        }
        if (cl.next != null) {
            cl.next.prev = cl.prev;
        }
        if (cl.prev != null) {
            cl.prev.next = cl.next;
        }
        cl.next = cl;
        cl.prev = cl;
        return true;
    }

    private Cleaner(Object referent, Runnable thunk) {
        super(referent, dummyQueue);
        this.thunk = thunk;
    }

    public static Cleaner create(Object ob, Runnable thunk) {
        if (thunk == null) {
            return null;
        }
        return Cleaner.add(new Cleaner(ob, thunk));
    }

    public void clean() {
        if (!Cleaner.remove(this)) {
            return;
        }
        try {
            this.thunk.run();
        }
        catch (Throwable x) {
            AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
    }
}

