/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.event;

import com.android.tools.layoutlib.java.System_Delegate;
import dalvik.annotation.compat.UnsupportedAppUsage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import libcore.net.event.NetworkEventListener;

public class NetworkEventDispatcher {
    private static final NetworkEventDispatcher instance = new NetworkEventDispatcher();
    private final List<NetworkEventListener> listeners = new CopyOnWriteArrayList<NetworkEventListener>();

    @UnsupportedAppUsage
    public static NetworkEventDispatcher getInstance() {
        return instance;
    }

    protected NetworkEventDispatcher() {
    }

    @UnsupportedAppUsage
    public void addListener(NetworkEventListener toAdd) {
        if (toAdd == null) {
            throw new NullPointerException("toAdd == null");
        }
        this.listeners.add(toAdd);
    }

    public void removeListener(NetworkEventListener toRemove) {
        for (NetworkEventListener listener : this.listeners) {
            if (listener != toRemove) continue;
            this.listeners.remove(listener);
            return;
        }
    }

    public void onNetworkConfigurationChanged() {
        for (NetworkEventListener listener : this.listeners) {
            try {
                listener.onNetworkConfigurationChanged();
            }
            catch (RuntimeException e) {
                System_Delegate.log("Exception thrown during network event propagation", e);
            }
        }
    }
}

