/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.textclassifier;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.concurrent.atomic.AtomicBoolean;

public class LangIdModel
implements AutoCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private long modelPtr;

    public LangIdModel(int fd) {
        this.modelPtr = LangIdModel.nativeNew(fd);
        if (this.modelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize LangId from given file descriptor.");
        }
    }

    public LangIdModel(String modelPath) {
        this.modelPtr = LangIdModel.nativeNewFromPath(modelPath);
        if (this.modelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize LangId from given file.");
        }
    }

    public LanguageResult[] detectLanguages(String text) {
        return this.nativeDetectLanguages(this.modelPtr, text);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.nativeClose(this.modelPtr);
            this.modelPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getVersion() {
        return this.nativeGetVersion(this.modelPtr);
    }

    public float getLangIdThreshold() {
        return this.nativeGetLangIdThreshold(this.modelPtr);
    }

    public static int getVersion(int fd) {
        return LangIdModel.nativeGetVersionFromFd(fd);
    }

    private static long nativeNew(int n) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.LangIdModel#nativeNew(I)J", true, null);
    }

    private static long nativeNewFromPath(String string2) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.LangIdModel#nativeNewFromPath(Ljava/lang/String;)J", true, null);
    }

    private LanguageResult[] nativeDetectLanguages(long l, String string2) {
        return (LanguageResult[])OverrideMethod.invokeA("com.google.android.textclassifier.LangIdModel#nativeDetectLanguages(JLjava/lang/String;)[Lcom/google/android/textclassifier/LangIdModel$LanguageResult;", true, this);
    }

    private void nativeClose(long l) {
        OverrideMethod.invokeV("com.google.android.textclassifier.LangIdModel#nativeClose(J)V", true, this);
    }

    private int nativeGetVersion(long l) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.LangIdModel#nativeGetVersion(J)I", true, this);
    }

    private static int nativeGetVersionFromFd(int n) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.LangIdModel#nativeGetVersionFromFd(I)I", true, null);
    }

    private float nativeGetLangIdThreshold(long l) {
        return OverrideMethod.invokeF("com.google.android.textclassifier.LangIdModel#nativeGetLangIdThreshold(J)F", true, this);
    }

    static {
        System.loadLibrary("textclassifier");
    }

    public static class LanguageResult {
        final String mLanguage;
        final float mScore;

        LanguageResult(String language, float score) {
            this.mLanguage = language;
            this.mScore = score;
        }

        public String getLanguage() {
            return this.mLanguage;
        }

        public float getScore() {
            return this.mScore;
        }
    }
}

