/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.textclassifier;

import com.android.tools.layoutlib.create.OverrideMethod;
import com.google.android.textclassifier.AnnotatorModel;
import com.google.android.textclassifier.NamedVariant;
import com.google.android.textclassifier.RemoteActionTemplate;
import java.util.concurrent.atomic.AtomicBoolean;

public class ActionsSuggestionsModel
implements AutoCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private long actionsModelPtr;

    public ActionsSuggestionsModel(int fileDescriptor, byte[] serializedPreconditions) {
        this.actionsModelPtr = ActionsSuggestionsModel.nativeNewActionsModel(fileDescriptor, serializedPreconditions);
        if (this.actionsModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize actions model from file descriptor.");
        }
    }

    public ActionsSuggestionsModel(int fileDescriptor) {
        this(fileDescriptor, null);
    }

    public ActionsSuggestionsModel(String path, byte[] serializedPreconditions) {
        this.actionsModelPtr = ActionsSuggestionsModel.nativeNewActionsModelFromPath(path, serializedPreconditions);
        if (this.actionsModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize actions model from given file.");
        }
    }

    public ActionsSuggestionsModel(String path) {
        this(path, null);
    }

    public ActionSuggestion[] suggestActions(Conversation conversation, ActionSuggestionOptions options, AnnotatorModel annotator) {
        return this.nativeSuggestActions(this.actionsModelPtr, conversation, options, annotator != null ? annotator.getNativeAnnotator() : 0L, null, null, false);
    }

    public ActionSuggestion[] suggestActionsWithIntents(Conversation conversation, ActionSuggestionOptions options, Object appContext, String deviceLocales, AnnotatorModel annotator) {
        return this.nativeSuggestActions(this.actionsModelPtr, conversation, options, annotator != null ? annotator.getNativeAnnotator() : 0L, appContext, deviceLocales, true);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.nativeCloseActionsModel(this.actionsModelPtr);
            this.actionsModelPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static String getLocales(int fd) {
        return ActionsSuggestionsModel.nativeGetLocales(fd);
    }

    public static int getVersion(int fd) {
        return ActionsSuggestionsModel.nativeGetVersion(fd);
    }

    public static String getName(int fd) {
        return ActionsSuggestionsModel.nativeGetName(fd);
    }

    private static long nativeNewActionsModel(int n, byte[] byArray) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.ActionsSuggestionsModel#nativeNewActionsModel(I[B)J", true, null);
    }

    private static long nativeNewActionsModelFromPath(String string2, byte[] byArray) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.ActionsSuggestionsModel#nativeNewActionsModelFromPath(Ljava/lang/String;[B)J", true, null);
    }

    private static String nativeGetLocales(int n) {
        return (String)OverrideMethod.invokeA("com.google.android.textclassifier.ActionsSuggestionsModel#nativeGetLocales(I)Ljava/lang/String;", true, null);
    }

    private static int nativeGetVersion(int n) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.ActionsSuggestionsModel#nativeGetVersion(I)I", true, null);
    }

    private static String nativeGetName(int n) {
        return (String)OverrideMethod.invokeA("com.google.android.textclassifier.ActionsSuggestionsModel#nativeGetName(I)Ljava/lang/String;", true, null);
    }

    private ActionSuggestion[] nativeSuggestActions(long l, Conversation conversation, ActionSuggestionOptions actionSuggestionOptions, long l2, Object object, String string2, boolean bl) {
        return (ActionSuggestion[])OverrideMethod.invokeA("com.google.android.textclassifier.ActionsSuggestionsModel#nativeSuggestActions(JLcom/google/android/textclassifier/ActionsSuggestionsModel$Conversation;Lcom/google/android/textclassifier/ActionsSuggestionsModel$ActionSuggestionOptions;JLjava/lang/Object;Ljava/lang/String;Z)[Lcom/google/android/textclassifier/ActionsSuggestionsModel$ActionSuggestion;", true, this);
    }

    private void nativeCloseActionsModel(long l) {
        OverrideMethod.invokeV("com.google.android.textclassifier.ActionsSuggestionsModel#nativeCloseActionsModel(J)V", true, this);
    }

    static {
        System.loadLibrary("textclassifier");
    }

    public static class ActionSuggestionOptions {
    }

    public static class Conversation {
        public final ConversationMessage[] conversationMessages;

        public Conversation(ConversationMessage[] conversationMessages) {
            this.conversationMessages = conversationMessages;
        }

        public ConversationMessage[] getConversationMessages() {
            return this.conversationMessages;
        }
    }

    public static class ConversationMessage {
        private final int userId;
        private final String text;
        private final long referenceTimeMsUtc;
        private final String referenceTimezone;
        private final String detectedTextLanguageTags;

        public ConversationMessage(int userId, String text, long referenceTimeMsUtc, String referenceTimezone, String detectedTextLanguageTags) {
            this.userId = userId;
            this.text = text;
            this.referenceTimeMsUtc = referenceTimeMsUtc;
            this.referenceTimezone = referenceTimezone;
            this.detectedTextLanguageTags = detectedTextLanguageTags;
        }

        public int getUserId() {
            return this.userId;
        }

        public String getText() {
            return this.text;
        }

        public long getReferenceTimeMsUtc() {
            return this.referenceTimeMsUtc;
        }

        public String getReferenceTimezone() {
            return this.referenceTimezone;
        }

        public String getDetectedTextLanguageTags() {
            return this.detectedTextLanguageTags;
        }
    }

    public static class ActionSuggestion {
        private final String responseText;
        private final String actionType;
        private final float score;
        private final NamedVariant[] entityData;
        private final byte[] serializedEntityData;
        private final RemoteActionTemplate[] remoteActionTemplates;

        public ActionSuggestion(String responseText, String actionType, float score, NamedVariant[] entityData, byte[] serializedEntityData, RemoteActionTemplate[] remoteActionTemplates) {
            this.responseText = responseText;
            this.actionType = actionType;
            this.score = score;
            this.entityData = entityData;
            this.serializedEntityData = serializedEntityData;
            this.remoteActionTemplates = remoteActionTemplates;
        }

        public String getResponseText() {
            return this.responseText;
        }

        public String getActionType() {
            return this.actionType;
        }

        public float getScore() {
            return this.score;
        }

        public NamedVariant[] getEntityData() {
            return this.entityData;
        }

        public byte[] getSerializedEntityData() {
            return this.serializedEntityData;
        }

        public RemoteActionTemplate[] getRemoteActionTemplates() {
            return this.remoteActionTemplates;
        }
    }
}

