/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.AttachInfo_Accessor;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.bars.AppCompatActionBar;
import com.android.layoutlib.bridge.bars.BridgeActionBar;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.FrameworkActionBar;
import com.android.layoutlib.bridge.bars.NavigationBar;
import com.android.layoutlib.bridge.bars.StatusBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.impl.SysUiOverlay;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;

class Layout
extends FrameLayout {
    private static final String ATTR_WINDOW_FLOATING = "windowIsFloating";
    private static final String ATTR_WINDOW_BACKGROUND = "windowBackground";
    private static final String ATTR_WINDOW_FULL_SCREEN = "windowFullscreen";
    private static final String ATTR_NAV_BAR_HEIGHT = "navigation_bar_height";
    private static final String ATTR_NAV_BAR_WIDTH = "navigation_bar_width";
    private static final String ATTR_STATUS_BAR_HEIGHT = "status_bar_height";
    private static final String ATTR_WINDOW_ACTION_BAR = "windowActionBar";
    private static final String ATTR_ACTION_BAR_SIZE = "actionBarSize";
    private static final String ATTR_WINDOW_NO_TITLE = "windowNoTitle";
    private static final String ATTR_WINDOW_TITLE_SIZE = "windowTitleSize";
    private static final String ATTR_WINDOW_TRANSLUCENT_STATUS = "windowTranslucentStatus";
    private static final String ATTR_WINDOW_TRANSLUCENT_NAV = "windowTranslucentNavigation";
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_NAV_BAR_SIZE = 48;
    private static final String ID_NAV_BAR = "navBar";
    private static final String ID_STATUS_BAR = "statusBar";
    private static final String ID_APP_COMPAT_ACTION_BAR = "appCompatActionBar";
    private static final String ID_FRAMEWORK_BAR = "frameworkBar";
    private static final String ID_PREFIX = "android_layoutlib_";
    private Builder mBuilder;
    private RelativeLayout mSysUiRoot;
    private FrameLayout mContentRoot;

    public Layout(Builder builder) {
        super(builder.mContext);
        View view;
        BridgeActionBar bar;
        this.mBuilder = builder;
        View frameworkActionBar = null;
        View appCompatActionBar = null;
        TitleBar titleBar = null;
        StatusBar statusBar = null;
        NavigationBar navBar = null;
        if (builder.mWindowBackground != null) {
            Drawable d = ResourceHelper.getDrawable(builder.mWindowBackground, builder.mContext);
            this.setBackground(d);
        }
        int simulatedPlatformVersion = this.getParams().getSimulatedPlatformVersion();
        HardwareConfig hwConfig = this.getParams().getHardwareConfig();
        Density density = hwConfig.getDensity();
        boolean isRtl = Bridge.isLocaleRtl(this.getParams().getLocale());
        this.setLayoutDirection(isRtl ? 1 : 0);
        if (this.mBuilder.hasNavBar()) {
            navBar = this.createNavBar(this.getContext(), density, isRtl, this.getParams().isRtlSupported(), simulatedPlatformVersion, false);
        }
        if (builder.hasStatusBar()) {
            statusBar = this.createStatusBar(this.getContext(), density, isRtl, this.getParams().isRtlSupported(), simulatedPlatformVersion);
        }
        if (this.mBuilder.hasAppCompatActionBar()) {
            bar = this.createActionBar(this.getContext(), this.getParams(), true);
            this.mContentRoot = bar.getContentRoot();
            appCompatActionBar = bar.getRootView();
        }
        if (this.mBuilder.hasTitleBar()) {
            titleBar = this.createTitleBar(this.getContext(), this.getParams().getAppLabel(), simulatedPlatformVersion);
        } else if (this.mBuilder.hasFrameworkActionBar()) {
            bar = this.createActionBar(this.getContext(), this.getParams(), false);
            if (this.mContentRoot == null) {
                this.mContentRoot = bar.getContentRoot();
            }
            frameworkActionBar = bar.getRootView();
        }
        this.mSysUiRoot = new RelativeLayout(builder.mContext);
        View[] viewArray = new View[5];
        viewArray[0] = titleBar;
        if (this.mContentRoot == null) {
            this.mContentRoot = this.createContentFrame();
            view = this.mContentRoot;
        } else {
            view = frameworkActionBar;
        }
        viewArray[1] = view;
        viewArray[2] = statusBar;
        viewArray[3] = navBar;
        viewArray[4] = appCompatActionBar;
        this.addSystemUiViews(viewArray);
        this.addView(this.mSysUiRoot);
        this.mBuilder = null;
    }

    private static View createSysUiOverlay(BridgeContext context) {
        SysUiOverlay overlay = new SysUiOverlay(context, 20, 10, 50, 40, 60);
        overlay.setNotchColor(-16777216);
        overlay.setLayoutParams(new FrameLayout.LayoutParams(-1, -1));
        return overlay;
    }

    private FrameLayout createContentFrame() {
        int rule;
        FrameLayout contentRoot = new FrameLayout(this.getContext());
        RelativeLayout.LayoutParams params = this.createSysUiLayoutParams(-1, -1);
        int n = rule = this.mBuilder.isNavBarVertical() ? 16 : 2;
        if (this.mBuilder.hasSolidNavBar()) {
            params.addRule(rule, this.getId(ID_NAV_BAR));
        }
        int below = -1;
        if (this.mBuilder.mAppCompatActionBarSize > 0) {
            below = this.getId(ID_APP_COMPAT_ACTION_BAR);
        } else if (this.mBuilder.hasFrameworkActionBar() || this.mBuilder.hasTitleBar()) {
            below = this.getId(ID_FRAMEWORK_BAR);
        } else if (this.mBuilder.hasSolidStatusBar()) {
            below = this.getId(ID_STATUS_BAR);
        }
        if (below != -1) {
            params.addRule(3, below);
        }
        contentRoot.setLayoutParams(params);
        return contentRoot;
    }

    private RelativeLayout.LayoutParams createSysUiLayoutParams(int width, int height) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        if (width > 0) {
            width = (int)TypedValue.applyDimension(1, width, metrics);
        }
        if (height > 0) {
            height = (int)TypedValue.applyDimension(1, height, metrics);
        }
        return new RelativeLayout.LayoutParams(width, height);
    }

    public FrameLayout getContentRoot() {
        return this.mContentRoot;
    }

    private SessionParams getParams() {
        return this.mBuilder.mParams;
    }

    @Override
    public BridgeContext getContext() {
        return (BridgeContext)super.getContext();
    }

    private StatusBar createStatusBar(BridgeContext context, Density density, boolean isRtl, boolean isRtlSupported, int simulatedPlatformVersion) {
        StatusBar statusBar = new StatusBar(context, density, isRtl, isRtlSupported, simulatedPlatformVersion);
        RelativeLayout.LayoutParams params = this.createSysUiLayoutParams(-1, this.mBuilder.mStatusBarSize);
        if (this.mBuilder.isNavBarVertical()) {
            params.addRule(16, this.getId(ID_NAV_BAR));
        }
        statusBar.setLayoutParams(params);
        statusBar.setId(this.getId(ID_STATUS_BAR));
        return statusBar;
    }

    private BridgeActionBar createActionBar(BridgeContext context, SessionParams params, boolean appCompatActionBar) {
        String id2;
        BridgeActionBar actionBar;
        int rule;
        boolean isMenu = "menu".equals(params.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG));
        int heightRule = appCompatActionBar || !this.mBuilder.hasAppCompatActionBar() ? -1 : -2;
        RelativeLayout.LayoutParams layoutParams = this.createSysUiLayoutParams(-1, heightRule);
        int n = rule = this.mBuilder.isNavBarVertical() ? 16 : 2;
        if (this.mBuilder.hasSolidNavBar() && (rule == 16 || appCompatActionBar || !this.mBuilder.hasAppCompatActionBar())) {
            layoutParams.addRule(rule, this.getId(ID_NAV_BAR));
        }
        if (appCompatActionBar && !isMenu) {
            actionBar = new AppCompatActionBar(context, params);
            id2 = ID_APP_COMPAT_ACTION_BAR;
            if (this.mBuilder.hasTitleBar() || this.mBuilder.hasFrameworkActionBar()) {
                layoutParams.addRule(3, this.getId(ID_FRAMEWORK_BAR));
            } else if (this.mBuilder.hasSolidStatusBar()) {
                layoutParams.addRule(3, this.getId(ID_STATUS_BAR));
            }
        } else {
            actionBar = new FrameworkActionBar(context, params);
            id2 = ID_FRAMEWORK_BAR;
            if (this.mBuilder.hasSolidStatusBar()) {
                layoutParams.addRule(3, this.getId(ID_STATUS_BAR));
            }
        }
        actionBar.getRootView().setLayoutParams(layoutParams);
        actionBar.getRootView().setId(this.getId(id2));
        actionBar.createMenuPopup();
        return actionBar;
    }

    private TitleBar createTitleBar(BridgeContext context, String title, int simulatedPlatformVersion) {
        TitleBar titleBar = new TitleBar(context, title, simulatedPlatformVersion);
        RelativeLayout.LayoutParams params = this.createSysUiLayoutParams(-1, this.mBuilder.mTitleBarSize);
        if (this.mBuilder.hasSolidStatusBar()) {
            params.addRule(3, this.getId(ID_STATUS_BAR));
        }
        if (this.mBuilder.isNavBarVertical() && this.mBuilder.hasSolidNavBar()) {
            params.addRule(16, this.getId(ID_NAV_BAR));
        }
        titleBar.setLayoutParams(params);
        titleBar.setId(this.getId(ID_FRAMEWORK_BAR));
        return titleBar;
    }

    private NavigationBar createNavBar(BridgeContext context, Density density, boolean isRtl, boolean isRtlSupported, int simulatedPlatformVersion, boolean isQuickStepEnabled) {
        int orientation = this.mBuilder.mNavBarOrientation;
        int size = this.mBuilder.mNavBarSize;
        isQuickStepEnabled = isQuickStepEnabled && (simulatedPlatformVersion == 0 || simulatedPlatformVersion >= 28);
        NavigationBar navBar = new NavigationBar(context, density, orientation, isRtl, isRtlSupported, simulatedPlatformVersion, isQuickStepEnabled);
        boolean isVertical = this.mBuilder.isNavBarVertical();
        int w = isVertical ? size : -1;
        int h = isVertical ? -1 : size;
        RelativeLayout.LayoutParams params = this.createSysUiLayoutParams(w, h);
        params.addRule(isVertical ? 21 : 12);
        navBar.setLayoutParams(params);
        navBar.setId(this.getId(ID_NAV_BAR));
        return navBar;
    }

    private void addSystemUiViews(View ... views) {
        for (View view : views) {
            if (view == null) continue;
            this.mSysUiRoot.addView(view);
        }
    }

    private int getId(String name) {
        return Bridge.getResourceId(ResourceType.ID, ID_PREFIX + name);
    }

    @Override
    public void requestFitSystemWindows() {
        ViewRootImpl root = AttachInfo_Accessor.getRootView(this);
        if (root != null) {
            ViewRootImpl_Accessor.dispatchApplyInsets(root, this);
        }
    }

    static class Builder {
        private final SessionParams mParams;
        private final BridgeContext mContext;
        private final RenderResources mResources;
        private final boolean mWindowIsFloating;
        private ResourceValue mWindowBackground;
        private int mStatusBarSize;
        private int mNavBarSize;
        private int mNavBarOrientation;
        private int mAppCompatActionBarSize;
        private int mFrameworkActionBarSize;
        private int mTitleBarSize;
        private boolean mTranslucentStatus;
        private boolean mTranslucentNav;

        public Builder(SessionParams params, BridgeContext context) {
            this.mParams = params;
            this.mContext = context;
            this.mResources = this.mParams.getResources();
            this.mWindowIsFloating = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_FLOATING, true);
            this.findBackground();
            if (!this.mParams.isForceNoDecor()) {
                this.findStatusBar();
                this.findFrameworkBar();
                this.findAppCompatActionBar();
                this.findNavBar();
            }
        }

        private void findBackground() {
            if (!this.mParams.isBgColorOverridden()) {
                this.mWindowBackground = this.mResources.findItemInTheme(BridgeContext.createFrameworkAttrReference(Layout.ATTR_WINDOW_BACKGROUND));
                this.mWindowBackground = this.mResources.resolveResValue(this.mWindowBackground);
            }
        }

        private void findStatusBar() {
            boolean windowFullScreen = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_FULL_SCREEN, false);
            if (!windowFullScreen && !this.mWindowIsFloating) {
                this.mStatusBarSize = this.getFrameworkAttrDimension(Layout.ATTR_STATUS_BAR_HEIGHT, 25);
                this.mTranslucentStatus = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_TRANSLUCENT_STATUS, false);
            }
        }

        private void findAppCompatActionBar() {
            if (this.mWindowIsFloating || !this.mContext.isAppCompatTheme()) {
                return;
            }
            boolean windowNoTitle = ResourceHelper.getBooleanThemeValue(this.mResources, this.mContext.createAppCompatAttrReference(Layout.ATTR_WINDOW_NO_TITLE), false);
            boolean windowActionBar = ResourceHelper.getBooleanThemeValue(this.mResources, this.mContext.createAppCompatAttrReference(Layout.ATTR_WINDOW_ACTION_BAR), true);
            if (!windowNoTitle && windowActionBar) {
                this.mAppCompatActionBarSize = this.getDimension(this.mContext.createAppCompatAttrReference(Layout.ATTR_ACTION_BAR_SIZE), 25);
            }
        }

        private void findFrameworkBar() {
            if (this.mWindowIsFloating) {
                return;
            }
            boolean frameworkWindowNoTitle = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_NO_TITLE, false);
            boolean isMenu = "menu".equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG));
            boolean windowActionBar = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_ACTION_BAR, true);
            if (!frameworkWindowNoTitle || isMenu) {
                if (isMenu || windowActionBar) {
                    this.mFrameworkActionBarSize = this.getFrameworkAttrDimension(Layout.ATTR_ACTION_BAR_SIZE, 25);
                } else {
                    this.mTitleBarSize = this.getDimension(this.mContext.createAppCompatAttrReference(Layout.ATTR_WINDOW_TITLE_SIZE), 25);
                }
            }
        }

        private void findNavBar() {
            if (this.hasSoftwareButtons() && !this.mWindowIsFloating) {
                HardwareConfig hwConfig = this.mParams.getHardwareConfig();
                boolean barOnBottom = true;
                if (hwConfig.getOrientation() == ScreenOrientation.LANDSCAPE) {
                    int shortSize = hwConfig.getScreenHeight();
                    int shortSizeDp = shortSize * 160 / hwConfig.getDensity().getDpiValue();
                    barOnBottom = shortSizeDp >= 600;
                }
                this.mNavBarOrientation = barOnBottom ? 0 : 1;
                this.mNavBarSize = this.getFrameworkAttrDimension(barOnBottom ? Layout.ATTR_NAV_BAR_HEIGHT : Layout.ATTR_NAV_BAR_WIDTH, 48);
                this.mTranslucentNav = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_TRANSLUCENT_NAV, false);
            }
        }

        private int getDimension(ResourceReference attrRef, int defaultValue) {
            TypedValue typedValue;
            ResourceValue value = this.mResources.findItemInTheme(attrRef);
            if ((value = this.mResources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue(attrRef.getName(), value.getValue(), true)) != null) {
                return (int)typedValue.getDimension(this.mContext.getMetrics());
            }
            return defaultValue;
        }

        private int getFrameworkAttrDimension(String attr2, int defaultValue) {
            return this.getDimension(BridgeContext.createFrameworkAttrReference(attr2), defaultValue);
        }

        private boolean hasSoftwareButtons() {
            return this.mParams.getHardwareConfig().hasSoftwareButtons();
        }

        private boolean hasSolidNavBar() {
            return this.hasNavBar() && !this.mTranslucentNav;
        }

        private boolean hasSolidStatusBar() {
            return this.hasStatusBar() && !this.mTranslucentStatus;
        }

        private boolean hasNavBar() {
            return Config.showOnScreenNavBar(this.mParams.getSimulatedPlatformVersion()) && this.hasSoftwareButtons() && this.mNavBarSize > 0;
        }

        private boolean hasTitleBar() {
            return this.mTitleBarSize > 0;
        }

        private boolean hasStatusBar() {
            return this.mStatusBarSize > 0;
        }

        private boolean hasAppCompatActionBar() {
            return this.mAppCompatActionBarSize > 0;
        }

        private boolean isNavBarVertical() {
            return this.hasNavBar() && this.mNavBarOrientation == 1;
        }

        private boolean hasFrameworkActionBar() {
            return this.mFrameworkActionBarSize > 0;
        }

        private boolean hasNotch() {
            return !this.mParams.isForceNoDecor();
        }
    }
}

