/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.bridge.util.SparseWeakArray;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class DelegateManager<T> {
    private static final SparseWeakArray<Object> sDelegates = new SparseWeakArray();
    private static final Set<Object> sJavaReferences = new HashSet<Object>();
    private static final AtomicLong sDelegateCounter = new AtomicLong(1L);
    private static final LinkedList<NativeAllocationHolder> sNativeAllocations = new LinkedList();
    @GuardedBy(value={"sNativeAllocations"})
    private static final WeakHashMap<Object, WeakReference<NativeAllocationHolder>> sNativeAllocationsReferences = new WeakHashMap();
    @GuardedBy(value={"sNativeAllocations"})
    private static long sNativeAllocationsCount = 0L;
    private final Class<T> mClass;

    public DelegateManager(Class<T> theClass) {
        this.mClass = theClass;
    }

    public static synchronized void dump(PrintStream out) {
        for (Object reference : sJavaReferences) {
            int idx = sDelegates.indexOfValue(reference);
            out.printf("[%d] %s\n", sDelegates.keyAt(idx), reference.getClass().getSimpleName());
        }
        out.printf("\nTotal number of objects: %d\n", sJavaReferences.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDelegate(long native_object) {
        if (native_object > 0L) {
            Class<DelegateManager> clazz = DelegateManager.class;
            synchronized (DelegateManager.class) {
                Object delegate = sDelegates.get(native_object);
                // ** MonitorExit[var4_2] (shouldn't be in output)
                assert (delegate != null);
                return (T)delegate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addNewDelegate(T newDelegate) {
        long native_object = sDelegateCounter.getAndIncrement();
        Class<DelegateManager> clazz = DelegateManager.class;
        synchronized (DelegateManager.class) {
            sDelegates.put(native_object, newDelegate);
            sJavaReferences.add(newDelegate);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return native_object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJavaReferenceFor(long native_object) {
        Class<DelegateManager> clazz = DelegateManager.class;
        synchronized (DelegateManager.class) {
            T delegate = this.getDelegate(native_object);
            if (!sJavaReferences.remove(delegate)) {
                LinkedList<NativeAllocationHolder> linkedList = sNativeAllocations;
                synchronized (linkedList) {
                    WeakReference<NativeAllocationHolder> holderRef = sNativeAllocationsReferences.get(delegate);
                    NativeAllocationHolder holder = (NativeAllocationHolder)holderRef.get();
                    if (holder != null) {
                        holder.mReferred = null;
                    }
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsNativeAllocation(Object referent, long native_object) {
        Object object = DelegateManager.class;
        synchronized (DelegateManager.class) {
            T delegate = this.getDelegate(native_object);
            assert (delegate != null);
            NativeAllocationHolder holder = sJavaReferences.remove(delegate) ? new NativeAllocationHolder(referent, delegate) : null;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (holder != null) {
                object = sNativeAllocations;
                synchronized (object) {
                    sNativeAllocations.add(holder);
                    sNativeAllocationsReferences.put(holder.mReferred, new WeakReference<NativeAllocationHolder>(holder));
                    if (++sNativeAllocationsCount % 50L == 0L) {
                        boolean bl = sNativeAllocations.removeIf(e -> ((NativeAllocationHolder)e).mReferent.get() == null);
                    }
                }
            }
            return;
        }
    }

    private static class NativeAllocationHolder {
        private final WeakReference<Object> mReferent;
        private Object mReferred;

        private NativeAllocationHolder(Object referent, Object referred) {
            this.mReferent = new WeakReference<Object>(referent);
            this.mReferred = referred;
        }
    }
}

