/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.ImageView;
import android.widget.RemoteViews;
import java.util.Objects;

@RemoteViews.RemoteView
public class CachingIconView
extends ImageView {
    private String mLastPackage;
    private int mLastResId;
    private boolean mInternalSetDrawable;
    private boolean mForceHidden;
    private int mDesiredVisibility;

    @UnsupportedAppUsage
    public CachingIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon) {
        if (!this.testAndSetCache(icon)) {
            this.mInternalSetDrawable = true;
            super.setImageIcon(icon);
            this.mInternalSetDrawable = false;
        }
    }

    @Override
    public Runnable setImageIconAsync(Icon icon) {
        this.resetCache();
        return super.setImageIconAsync(icon);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageResourceAsync")
    public void setImageResource(int resId) {
        if (!this.testAndSetCache(resId)) {
            this.mInternalSetDrawable = true;
            super.setImageResource(resId);
            this.mInternalSetDrawable = false;
        }
    }

    @Override
    public Runnable setImageResourceAsync(int resId) {
        this.resetCache();
        return super.setImageResourceAsync(resId);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(Uri uri) {
        this.resetCache();
        super.setImageURI(uri);
    }

    @Override
    public Runnable setImageURIAsync(Uri uri) {
        this.resetCache();
        return super.setImageURIAsync(uri);
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        if (!this.mInternalSetDrawable) {
            this.resetCache();
        }
        super.setImageDrawable(drawable2);
    }

    @Override
    @RemotableViewMethod
    public void setImageBitmap(Bitmap bm) {
        this.resetCache();
        super.setImageBitmap(bm);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resetCache();
    }

    private synchronized boolean testAndSetCache(Icon icon) {
        if (icon != null && icon.getType() == 2) {
            String iconPackage = this.normalizeIconPackage(icon);
            boolean isCached = this.mLastResId != 0 && icon.getResId() == this.mLastResId && Objects.equals(iconPackage, this.mLastPackage);
            this.mLastPackage = iconPackage;
            this.mLastResId = icon.getResId();
            return isCached;
        }
        this.resetCache();
        return false;
    }

    private synchronized boolean testAndSetCache(int resId) {
        boolean isCached = resId == 0 || this.mLastResId == 0 ? false : resId == this.mLastResId && null == this.mLastPackage;
        this.mLastPackage = null;
        this.mLastResId = resId;
        return isCached;
    }

    private String normalizeIconPackage(Icon icon) {
        if (icon == null) {
            return null;
        }
        String pkg = icon.getResPackage();
        if (TextUtils.isEmpty(pkg)) {
            return null;
        }
        if (pkg.equals(this.mContext.getPackageName())) {
            return null;
        }
        return pkg;
    }

    private synchronized void resetCache() {
        this.mLastResId = 0;
        this.mLastPackage = null;
    }

    public void setForceHidden(boolean forceHidden) {
        this.mForceHidden = forceHidden;
        this.updateVisibility();
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int visibility) {
        this.mDesiredVisibility = visibility;
        this.updateVisibility();
    }

    private void updateVisibility() {
        int visibility = this.mDesiredVisibility == 0 && this.mForceHidden ? 4 : this.mDesiredVisibility;
        super.setVisibility(visibility);
    }
}

