/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputContentInfo;
import com.android.internal.view.IInputContextCallback;

public interface IInputContext
extends IInterface {
    public void getTextBeforeCursor(int var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void getTextAfterCursor(int var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void getCursorCapsMode(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void getExtractedText(ExtractedTextRequest var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void deleteSurroundingText(int var1, int var2) throws RemoteException;

    public void deleteSurroundingTextInCodePoints(int var1, int var2) throws RemoteException;

    public void setComposingText(CharSequence var1, int var2) throws RemoteException;

    public void finishComposingText() throws RemoteException;

    public void commitText(CharSequence var1, int var2) throws RemoteException;

    public void commitCompletion(CompletionInfo var1) throws RemoteException;

    public void commitCorrection(CorrectionInfo var1) throws RemoteException;

    public void setSelection(int var1, int var2) throws RemoteException;

    public void performEditorAction(int var1) throws RemoteException;

    public void performContextMenuAction(int var1) throws RemoteException;

    public void beginBatchEdit() throws RemoteException;

    public void endBatchEdit() throws RemoteException;

    public void sendKeyEvent(KeyEvent var1) throws RemoteException;

    public void clearMetaKeyStates(int var1) throws RemoteException;

    public void performPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public void setComposingRegion(int var1, int var2) throws RemoteException;

    public void getSelectedText(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void requestUpdateCursorAnchorInfo(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void commitContent(InputContentInfo var1, int var2, Bundle var3, int var4, IInputContextCallback var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputContext {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputContext";
        static final int TRANSACTION_getTextBeforeCursor = 1;
        static final int TRANSACTION_getTextAfterCursor = 2;
        static final int TRANSACTION_getCursorCapsMode = 3;
        static final int TRANSACTION_getExtractedText = 4;
        static final int TRANSACTION_deleteSurroundingText = 5;
        static final int TRANSACTION_deleteSurroundingTextInCodePoints = 6;
        static final int TRANSACTION_setComposingText = 7;
        static final int TRANSACTION_finishComposingText = 8;
        static final int TRANSACTION_commitText = 9;
        static final int TRANSACTION_commitCompletion = 10;
        static final int TRANSACTION_commitCorrection = 11;
        static final int TRANSACTION_setSelection = 12;
        static final int TRANSACTION_performEditorAction = 13;
        static final int TRANSACTION_performContextMenuAction = 14;
        static final int TRANSACTION_beginBatchEdit = 15;
        static final int TRANSACTION_endBatchEdit = 16;
        static final int TRANSACTION_sendKeyEvent = 17;
        static final int TRANSACTION_clearMetaKeyStates = 18;
        static final int TRANSACTION_performPrivateCommand = 19;
        static final int TRANSACTION_setComposingRegion = 20;
        static final int TRANSACTION_getSelectedText = 21;
        static final int TRANSACTION_requestUpdateCursorAnchorInfo = 22;
        static final int TRANSACTION_commitContent = 23;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputContext asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputContext) {
                return (IInputContext)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getTextBeforeCursor";
                }
                case 2: {
                    return "getTextAfterCursor";
                }
                case 3: {
                    return "getCursorCapsMode";
                }
                case 4: {
                    return "getExtractedText";
                }
                case 5: {
                    return "deleteSurroundingText";
                }
                case 6: {
                    return "deleteSurroundingTextInCodePoints";
                }
                case 7: {
                    return "setComposingText";
                }
                case 8: {
                    return "finishComposingText";
                }
                case 9: {
                    return "commitText";
                }
                case 10: {
                    return "commitCompletion";
                }
                case 11: {
                    return "commitCorrection";
                }
                case 12: {
                    return "setSelection";
                }
                case 13: {
                    return "performEditorAction";
                }
                case 14: {
                    return "performContextMenuAction";
                }
                case 15: {
                    return "beginBatchEdit";
                }
                case 16: {
                    return "endBatchEdit";
                }
                case 17: {
                    return "sendKeyEvent";
                }
                case 18: {
                    return "clearMetaKeyStates";
                }
                case 19: {
                    return "performPrivateCommand";
                }
                case 20: {
                    return "setComposingRegion";
                }
                case 21: {
                    return "getSelectedText";
                }
                case 22: {
                    return "requestUpdateCursorAnchorInfo";
                }
                case 23: {
                    return "commitContent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IInputContextCallback _arg3 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getTextBeforeCursor(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IInputContextCallback _arg3 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getTextAfterCursor(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInputContextCallback _arg2 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getCursorCapsMode(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ExtractedTextRequest _arg0 = 0 != data.readInt() ? ExtractedTextRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IInputContextCallback _arg3 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getExtractedText(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.deleteSurroundingText(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.deleteSurroundingTextInCodePoints(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    CharSequence _arg0 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.setComposingText(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    this.finishComposingText();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    CharSequence _arg0 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.commitText(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    CompletionInfo _arg0 = 0 != data.readInt() ? CompletionInfo.CREATOR.createFromParcel(data) : null;
                    this.commitCompletion(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    CorrectionInfo _arg0 = 0 != data.readInt() ? CorrectionInfo.CREATOR.createFromParcel(data) : null;
                    this.commitCorrection(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setSelection(_arg0, _arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.performEditorAction(_arg0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.performContextMenuAction(_arg0);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    this.beginBatchEdit();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    this.endBatchEdit();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    KeyEvent _arg0 = 0 != data.readInt() ? KeyEvent.CREATOR.createFromParcel(data) : null;
                    this.sendKeyEvent(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.clearMetaKeyStates(_arg0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.performPrivateCommand(_arg0, _arg1);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setComposingRegion(_arg0, _arg1);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInputContextCallback _arg2 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getSelectedText(_arg0, _arg1, _arg2);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInputContextCallback _arg2 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.requestUpdateCursorAnchorInfo(_arg0, _arg1, _arg2);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    InputContentInfo _arg0 = 0 != data.readInt() ? InputContentInfo.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    IInputContextCallback _arg4 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.commitContent(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInputContext impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInputContext getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInputContext {
            private IBinder mRemote;
            public static IInputContext sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getTextBeforeCursor(int length, int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getTextBeforeCursor(length, flags, seq, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getTextAfterCursor(int length, int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getTextAfterCursor(length, flags, seq, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCursorCapsMode(int reqModes, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reqModes);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getCursorCapsMode(reqModes, seq, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getExtractedText(ExtractedTextRequest request, int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getExtractedText(request, flags, seq, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSurroundingText(int beforeLength, int afterLength) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteSurroundingText(beforeLength, afterLength);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteSurroundingTextInCodePoints(beforeLength, afterLength);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComposingText(CharSequence text, int newCursorPosition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setComposingText(text, newCursorPosition);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finishComposingText() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finishComposingText();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitText(CharSequence text, int newCursorPosition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().commitText(text, newCursorPosition);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitCompletion(CompletionInfo completion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (completion != null) {
                        _data.writeInt(1);
                        completion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().commitCompletion(completion);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitCorrection(CorrectionInfo correction) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (correction != null) {
                        _data.writeInt(1);
                        correction.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().commitCorrection(correction);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSelection(int start, int end) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSelection(start, end);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performEditorAction(int actionCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(actionCode);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().performEditorAction(actionCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performContextMenuAction(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().performContextMenuAction(id2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void beginBatchEdit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().beginBatchEdit();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void endBatchEdit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().endBatchEdit();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendKeyEvent(KeyEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendKeyEvent(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearMetaKeyStates(int states) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(states);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearMetaKeyStates(states);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performPrivateCommand(String action, Bundle data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().performPrivateCommand(action, data);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComposingRegion(int start, int end) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setComposingRegion(start, end);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSelectedText(int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getSelectedText(flags, seq, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUpdateCursorAnchorInfo(int cursorUpdateMode, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cursorUpdateMode);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestUpdateCursorAnchorInfo(cursorUpdateMode, seq, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts, int sec, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputContentInfo != null) {
                        _data.writeInt(1);
                        inputContentInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    if (opts != null) {
                        _data.writeInt(1);
                        opts.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sec);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(23, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().commitContent(inputContentInfo, flags, opts, sec, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputContext {
        @Override
        public void getTextBeforeCursor(int length, int flags, int seq, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public void getTextAfterCursor(int length, int flags, int seq, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public void getCursorCapsMode(int reqModes, int seq, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public void getExtractedText(ExtractedTextRequest request, int flags, int seq, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public void deleteSurroundingText(int beforeLength, int afterLength) throws RemoteException {
        }

        @Override
        public void deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) throws RemoteException {
        }

        @Override
        public void setComposingText(CharSequence text, int newCursorPosition) throws RemoteException {
        }

        @Override
        public void finishComposingText() throws RemoteException {
        }

        @Override
        public void commitText(CharSequence text, int newCursorPosition) throws RemoteException {
        }

        @Override
        public void commitCompletion(CompletionInfo completion) throws RemoteException {
        }

        @Override
        public void commitCorrection(CorrectionInfo correction) throws RemoteException {
        }

        @Override
        public void setSelection(int start, int end) throws RemoteException {
        }

        @Override
        public void performEditorAction(int actionCode) throws RemoteException {
        }

        @Override
        public void performContextMenuAction(int id2) throws RemoteException {
        }

        @Override
        public void beginBatchEdit() throws RemoteException {
        }

        @Override
        public void endBatchEdit() throws RemoteException {
        }

        @Override
        public void sendKeyEvent(KeyEvent event) throws RemoteException {
        }

        @Override
        public void clearMetaKeyStates(int states) throws RemoteException {
        }

        @Override
        public void performPrivateCommand(String action, Bundle data) throws RemoteException {
        }

        @Override
        public void setComposingRegion(int start, int end) throws RemoteException {
        }

        @Override
        public void getSelectedText(int flags, int seq, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public void requestUpdateCursorAnchorInfo(int cursorUpdateMode, int seq, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public void commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts, int sec, IInputContextCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

