/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import java.util.ArrayList;
import java.util.Arrays;

class ZygoteArguments {
    int mUid = 0;
    boolean mUidSpecified;
    int mGid = 0;
    boolean mGidSpecified;
    int[] mGids;
    int mRuntimeFlags;
    int mMountExternal = 0;
    int mTargetSdkVersion;
    boolean mTargetSdkVersionSpecified;
    String mNiceName;
    boolean mCapabilitiesSpecified;
    long mPermittedCapabilities;
    long mEffectiveCapabilities;
    boolean mSeInfoSpecified;
    String mSeInfo;
    boolean mUsapPoolEnabled;
    boolean mUsapPoolStatusSpecified = false;
    ArrayList<int[]> mRLimits;
    String mInvokeWith;
    String mPackageName;
    String[] mRemainingArgs;
    boolean mAbiListQuery;
    String mInstructionSet;
    String mAppDataDir;
    String mPreloadPackage;
    String mPreloadApp;
    String mPreloadPackageLibs;
    String mPreloadPackageLibFileName;
    String mPreloadPackageCacheKey;
    boolean mPreloadDefault;
    boolean mStartChildZygote;
    boolean mPidQuery;
    String[] mApiBlacklistExemptions;
    int mHiddenApiAccessLogSampleRate = -1;
    int mHiddenApiAccessStatslogSampleRate = -1;

    ZygoteArguments(String[] args) throws IllegalArgumentException {
        this.parseArgs(args);
    }

    private void parseArgs(String[] args) throws IllegalArgumentException {
        int curArg;
        boolean seenRuntimeArgs = false;
        boolean expectRuntimeArgs = true;
        for (curArg = 0; curArg < args.length; ++curArg) {
            String rateStr;
            String arg = args[curArg];
            if (arg.equals("--")) {
                ++curArg;
                break;
            }
            if (arg.startsWith("--setuid=")) {
                if (this.mUidSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mUidSpecified = true;
                this.mUid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                continue;
            }
            if (arg.startsWith("--setgid=")) {
                if (this.mGidSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mGidSpecified = true;
                this.mGid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                continue;
            }
            if (arg.startsWith("--target-sdk-version=")) {
                if (this.mTargetSdkVersionSpecified) {
                    throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                }
                this.mTargetSdkVersionSpecified = true;
                this.mTargetSdkVersion = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                continue;
            }
            if (arg.equals("--runtime-args")) {
                seenRuntimeArgs = true;
                continue;
            }
            if (arg.startsWith("--runtime-flags=")) {
                this.mRuntimeFlags = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                continue;
            }
            if (arg.startsWith("--seinfo=")) {
                if (this.mSeInfoSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mSeInfoSpecified = true;
                this.mSeInfo = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.startsWith("--capabilities=")) {
                if (this.mCapabilitiesSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mCapabilitiesSpecified = true;
                String capString = arg.substring(arg.indexOf(61) + 1);
                String[] capStrings = capString.split(",", 2);
                if (capStrings.length == 1) {
                    this.mPermittedCapabilities = this.mEffectiveCapabilities = Long.decode(capStrings[0]).longValue();
                    continue;
                }
                this.mPermittedCapabilities = Long.decode(capStrings[0]);
                this.mEffectiveCapabilities = Long.decode(capStrings[1]);
                continue;
            }
            if (arg.startsWith("--rlimit=")) {
                String[] limitStrings = arg.substring(arg.indexOf(61) + 1).split(",");
                if (limitStrings.length != 3) {
                    throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                }
                int[] rlimitTuple = new int[limitStrings.length];
                for (int i = 0; i < limitStrings.length; ++i) {
                    rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                }
                if (this.mRLimits == null) {
                    this.mRLimits = new ArrayList();
                }
                this.mRLimits.add(rlimitTuple);
                continue;
            }
            if (arg.startsWith("--setgroups=")) {
                if (this.mGids != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                String[] params = arg.substring(arg.indexOf(61) + 1).split(",");
                this.mGids = new int[params.length];
                for (int i = params.length - 1; i >= 0; --i) {
                    this.mGids[i] = Integer.parseInt(params[i]);
                }
                continue;
            }
            if (arg.equals("--invoke-with")) {
                if (this.mInvokeWith != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                try {
                    this.mInvokeWith = args[++curArg];
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalArgumentException("--invoke-with requires argument");
                }
            }
            if (arg.startsWith("--nice-name=")) {
                if (this.mNiceName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mNiceName = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.equals("--mount-external-default")) {
                this.mMountExternal = 1;
                continue;
            }
            if (arg.equals("--mount-external-read")) {
                this.mMountExternal = 2;
                continue;
            }
            if (arg.equals("--mount-external-write")) {
                this.mMountExternal = 3;
                continue;
            }
            if (arg.equals("--mount-external-full")) {
                this.mMountExternal = 6;
                continue;
            }
            if (arg.equals("--mount-external-installer")) {
                this.mMountExternal = 5;
                continue;
            }
            if (arg.equals("--mount-external-legacy")) {
                this.mMountExternal = 4;
                continue;
            }
            if (arg.equals("--query-abi-list")) {
                this.mAbiListQuery = true;
                continue;
            }
            if (arg.equals("--get-pid")) {
                this.mPidQuery = true;
                continue;
            }
            if (arg.startsWith("--instruction-set=")) {
                this.mInstructionSet = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.startsWith("--app-data-dir=")) {
                this.mAppDataDir = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.equals("--preload-app")) {
                this.mPreloadApp = args[++curArg];
                continue;
            }
            if (arg.equals("--preload-package")) {
                this.mPreloadPackage = args[++curArg];
                this.mPreloadPackageLibs = args[++curArg];
                this.mPreloadPackageLibFileName = args[++curArg];
                this.mPreloadPackageCacheKey = args[++curArg];
                continue;
            }
            if (arg.equals("--preload-default")) {
                this.mPreloadDefault = true;
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.equals("--start-child-zygote")) {
                this.mStartChildZygote = true;
                continue;
            }
            if (arg.equals("--set-api-blacklist-exemptions")) {
                this.mApiBlacklistExemptions = Arrays.copyOfRange(args, curArg + 1, args.length);
                curArg = args.length;
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--hidden-api-log-sampling-rate=")) {
                rateStr = arg.substring(arg.indexOf(61) + 1);
                try {
                    this.mHiddenApiAccessLogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid log sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--hidden-api-statslog-sampling-rate=")) {
                rateStr = arg.substring(arg.indexOf(61) + 1);
                try {
                    this.mHiddenApiAccessStatslogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid statslog sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--package-name=")) {
                if (this.mPackageName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mPackageName = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (!arg.startsWith("--usap-pool-enabled=")) break;
            this.mUsapPoolStatusSpecified = true;
            this.mUsapPoolEnabled = Boolean.parseBoolean(arg.substring(arg.indexOf(61) + 1));
            expectRuntimeArgs = false;
        }
        if (this.mAbiListQuery || this.mPidQuery) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --query-abi-list.");
            }
        } else if (this.mPreloadPackage != null) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --preload-package.");
            }
        } else if (this.mPreloadApp != null) {
            if (args.length - curArg > 0) {
                throw new IllegalArgumentException("Unexpected arguments after --preload-app.");
            }
        } else if (expectRuntimeArgs) {
            if (!seenRuntimeArgs) {
                throw new IllegalArgumentException("Unexpected argument : " + args[curArg]);
            }
            this.mRemainingArgs = new String[args.length - curArg];
            System.arraycopy(args, curArg, this.mRemainingArgs, 0, this.mRemainingArgs.length);
        }
        if (this.mStartChildZygote) {
            boolean seenChildSocketArg = false;
            for (String arg : this.mRemainingArgs) {
                if (!arg.startsWith("--zygote-socket=")) continue;
                seenChildSocketArg = true;
                break;
            }
            if (!seenChildSocketArg) {
                throw new IllegalArgumentException("--start-child-zygote specified without --zygote-socket=");
            }
        }
    }
}

