/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.TableMaskFilter;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterViewAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.tools.layoutlib.java.System_Delegate;
import java.lang.ref.WeakReference;

@RemoteViews.RemoteView
public class StackView
extends AdapterViewAnimator {
    private final String TAG = "StackView";
    private static final int DEFAULT_ANIMATION_DURATION = 400;
    private static final int MINIMUM_ANIMATION_DURATION = 50;
    private static final int STACK_RELAYOUT_DURATION = 100;
    private static final float PERSPECTIVE_SHIFT_FACTOR_Y = 0.1f;
    private static final float PERSPECTIVE_SHIFT_FACTOR_X = 0.1f;
    private float mPerspectiveShiftX;
    private float mPerspectiveShiftY;
    private float mNewPerspectiveShiftX;
    private float mNewPerspectiveShiftY;
    private static final float PERSPECTIVE_SCALE_FACTOR = 0.0f;
    private static final int ITEMS_SLIDE_UP = 0;
    private static final int ITEMS_SLIDE_DOWN = 1;
    private static final int GESTURE_NONE = 0;
    private static final int GESTURE_SLIDE_UP = 1;
    private static final int GESTURE_SLIDE_DOWN = 2;
    private static final float SWIPE_THRESHOLD_RATIO = 0.2f;
    private static final float SLIDE_UP_RATIO = 0.7f;
    private static final int INVALID_POINTER = -1;
    private static final int NUM_ACTIVE_VIEWS = 5;
    private static final int FRAME_PADDING = 4;
    private final Rect mTouchRect = new Rect();
    private static final int MIN_TIME_BETWEEN_INTERACTION_AND_AUTOADVANCE = 5000;
    private static final long MIN_TIME_BETWEEN_SCROLLS = 100L;
    private float mInitialY;
    private float mInitialX;
    private int mActivePointerId;
    private int mYVelocity = 0;
    private int mSwipeGestureType = 0;
    private int mSlideAmount;
    private int mSwipeThreshold;
    private int mTouchSlop;
    private int mMaximumVelocity;
    private VelocityTracker mVelocityTracker;
    private boolean mTransitionIsSetup = false;
    private int mResOutColor;
    private int mClickColor;
    private static HolographicHelper sHolographicHelper;
    private ImageView mHighlight;
    private ImageView mClickFeedback;
    private boolean mClickFeedbackIsValid = false;
    private StackSlider mStackSlider;
    private boolean mFirstLayoutHappened = false;
    private long mLastInteractionTime = 0L;
    private long mLastScrollTime;
    private int mStackMode;
    private int mFramePadding;
    private final Rect stackInvalidateRect = new Rect();

    public StackView(Context context) {
        this(context, null);
    }

    public StackView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843838);
    }

    public StackView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public StackView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StackView, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.StackView, attrs, a, defStyleAttr, defStyleRes);
        this.mResOutColor = a.getColor(1, 0);
        this.mClickColor = a.getColor(0, 0);
        a.recycle();
        this.initStackView();
    }

    private void initStackView() {
        this.configureViewAnimator(5, 1);
        this.setStaticTransformationsEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mActivePointerId = -1;
        this.mHighlight = new ImageView(this.getContext());
        this.mHighlight.setLayoutParams(new LayoutParams(this.mHighlight));
        this.addViewInLayout(this.mHighlight, -1, new LayoutParams(this.mHighlight));
        this.mClickFeedback = new ImageView(this.getContext());
        this.mClickFeedback.setLayoutParams(new LayoutParams(this.mClickFeedback));
        this.addViewInLayout(this.mClickFeedback, -1, new LayoutParams(this.mClickFeedback));
        this.mClickFeedback.setVisibility(4);
        this.mStackSlider = new StackSlider();
        if (sHolographicHelper == null) {
            sHolographicHelper = new HolographicHelper(this.mContext);
        }
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mStackMode = 1;
        this.mWhichChild = -1;
        float density = this.mContext.getResources().getDisplayMetrics().density;
        this.mFramePadding = (int)Math.ceil(density * 4.0f);
    }

    @Override
    void transformViewForTransition(int fromIndex, int toIndex, final View view, boolean animate) {
        LayoutParams lp;
        if (!animate) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setRotationX(0.0f);
            lp = (LayoutParams)view.getLayoutParams();
            lp.setVerticalOffset(0);
            lp.setHorizontalOffset(0);
        }
        if (fromIndex == -1 && toIndex == this.getNumActiveViews() - 1) {
            this.transformViewAtIndex(toIndex, view, false);
            view.setVisibility(0);
            view.setAlpha(1.0f);
        } else if (fromIndex == 0 && toIndex == 1) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setVisibility(0);
            int duration = Math.round(this.mStackSlider.getDurationForNeutralPosition(this.mYVelocity));
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            animationSlider.setView(view);
            if (animate) {
                PropertyValuesHolder slideInY = PropertyValuesHolder.ofFloat("YProgress", 0.0f);
                PropertyValuesHolder slideInX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
                ObjectAnimator slideIn = ObjectAnimator.ofPropertyValuesHolder(animationSlider, slideInX, slideInY);
                slideIn.setDuration(duration);
                slideIn.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(slideIn);
                slideIn.start();
            } else {
                animationSlider.setYProgress(0.0f);
                animationSlider.setXProgress(0.0f);
            }
        } else if (fromIndex == 1 && toIndex == 0) {
            ((StackFrame)view).cancelSliderAnimator();
            int duration = Math.round(this.mStackSlider.getDurationForOffscreenPosition(this.mYVelocity));
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            animationSlider.setView(view);
            if (animate) {
                PropertyValuesHolder slideOutY = PropertyValuesHolder.ofFloat("YProgress", 1.0f);
                PropertyValuesHolder slideOutX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
                ObjectAnimator slideOut = ObjectAnimator.ofPropertyValuesHolder(animationSlider, slideOutX, slideOutY);
                slideOut.setDuration(duration);
                slideOut.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(slideOut);
                slideOut.start();
            } else {
                animationSlider.setYProgress(1.0f);
                animationSlider.setXProgress(0.0f);
            }
        } else if (toIndex == 0) {
            view.setAlpha(0.0f);
            view.setVisibility(4);
        } else if ((fromIndex == 0 || fromIndex == 1) && toIndex > 1) {
            view.setVisibility(0);
            view.setAlpha(1.0f);
            view.setRotationX(0.0f);
            lp = (LayoutParams)view.getLayoutParams();
            lp.setVerticalOffset(0);
            lp.setHorizontalOffset(0);
        } else if (fromIndex == -1) {
            view.setAlpha(1.0f);
            view.setVisibility(0);
        } else if (toIndex == -1) {
            if (animate) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        view.setAlpha(0.0f);
                    }
                }, 100L);
            } else {
                view.setAlpha(0.0f);
            }
        }
        if (toIndex != -1) {
            this.transformViewAtIndex(toIndex, view, animate);
        }
    }

    private void transformViewAtIndex(int index, View view, boolean animate) {
        float maxPerspectiveShiftY = this.mPerspectiveShiftY;
        float maxPerspectiveShiftX = this.mPerspectiveShiftX;
        if (this.mStackMode == 1) {
            if ((index = this.mMaxNumActiveViews - index - 1) == this.mMaxNumActiveViews - 1) {
                --index;
            }
        } else if (--index < 0) {
            ++index;
        }
        float r = (float)index * 1.0f / (float)(this.mMaxNumActiveViews - 2);
        float scale = 1.0f - 0.0f * (1.0f - r);
        float perspectiveTranslationY = r * maxPerspectiveShiftY;
        float scaleShiftCorrectionY = (scale - 1.0f) * ((float)this.getMeasuredHeight() * 0.9f / 2.0f);
        float transY = perspectiveTranslationY + scaleShiftCorrectionY;
        float perspectiveTranslationX = (1.0f - r) * maxPerspectiveShiftX;
        float scaleShiftCorrectionX = (1.0f - scale) * ((float)this.getMeasuredWidth() * 0.9f / 2.0f);
        float transX = perspectiveTranslationX + scaleShiftCorrectionX;
        if (view instanceof StackFrame) {
            ((StackFrame)view).cancelTransformAnimator();
        }
        if (animate) {
            PropertyValuesHolder translationX = PropertyValuesHolder.ofFloat("translationX", transX);
            PropertyValuesHolder translationY = PropertyValuesHolder.ofFloat("translationY", transY);
            PropertyValuesHolder scalePropX = PropertyValuesHolder.ofFloat("scaleX", scale);
            PropertyValuesHolder scalePropY = PropertyValuesHolder.ofFloat("scaleY", scale);
            ObjectAnimator oa = ObjectAnimator.ofPropertyValuesHolder(view, scalePropX, scalePropY, translationY, translationX);
            oa.setDuration(100L);
            if (view instanceof StackFrame) {
                ((StackFrame)view).setTransformAnimator(oa);
            }
            oa.start();
        } else {
            view.setTranslationX(transX);
            view.setTranslationY(transY);
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private void setupStackSlider(View v, int mode) {
        this.mStackSlider.setMode(mode);
        if (v != null) {
            this.mHighlight.setImageBitmap(sHolographicHelper.createResOutline(v, this.mResOutColor));
            this.mHighlight.setRotation(v.getRotation());
            this.mHighlight.setTranslationY(v.getTranslationY());
            this.mHighlight.setTranslationX(v.getTranslationX());
            this.mHighlight.bringToFront();
            v.bringToFront();
            this.mStackSlider.setView(v);
            v.setVisibility(0);
        }
    }

    @Override
    @RemotableViewMethod
    public void showNext() {
        View v;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (v = this.getViewAtRelativeIndex(1)) != null) {
            this.setupStackSlider(v, 0);
            this.mStackSlider.setYProgress(0.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showNext();
    }

    @Override
    @RemotableViewMethod
    public void showPrevious() {
        View v;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (v = this.getViewAtRelativeIndex(0)) != null) {
            this.setupStackSlider(v, 0);
            this.mStackSlider.setYProgress(1.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showPrevious();
    }

    @Override
    void showOnly(int childIndex, boolean animate) {
        super.showOnly(childIndex, animate);
        for (int i = this.mCurrentWindowEnd; i >= this.mCurrentWindowStart; --i) {
            View v;
            int index = this.modulo(i, this.getWindowSize());
            AdapterViewAnimator.ViewAndMetaData vm = (AdapterViewAnimator.ViewAndMetaData)this.mViewsMap.get(index);
            if (vm == null || (v = ((AdapterViewAnimator.ViewAndMetaData)this.mViewsMap.get((Object)Integer.valueOf((int)index))).view) == null) continue;
            v.bringToFront();
        }
        if (this.mHighlight != null) {
            this.mHighlight.bringToFront();
        }
        this.mTransitionIsSetup = false;
        this.mClickFeedbackIsValid = false;
    }

    void updateClickFeedback() {
        if (!this.mClickFeedbackIsValid) {
            View v = this.getViewAtRelativeIndex(1);
            if (v != null) {
                this.mClickFeedback.setImageBitmap(sHolographicHelper.createClickOutline(v, this.mClickColor));
                this.mClickFeedback.setTranslationX(v.getTranslationX());
                this.mClickFeedback.setTranslationY(v.getTranslationY());
            }
            this.mClickFeedbackIsValid = true;
        }
    }

    @Override
    void showTapFeedback(View v) {
        this.updateClickFeedback();
        this.mClickFeedback.setVisibility(0);
        this.mClickFeedback.bringToFront();
        this.invalidate();
    }

    @Override
    void hideTapFeedback(View v) {
        this.mClickFeedback.setVisibility(4);
        this.invalidate();
    }

    private void updateChildTransforms() {
        for (int i = 0; i < this.getNumActiveViews(); ++i) {
            View v = this.getViewAtRelativeIndex(i);
            if (v == null) continue;
            this.transformViewAtIndex(i, v, false);
        }
    }

    @Override
    FrameLayout getFrameForChild() {
        StackFrame fl = new StackFrame(this.mContext);
        fl.setPadding(this.mFramePadding, this.mFramePadding, this.mFramePadding, this.mFramePadding);
        return fl;
    }

    @Override
    void applyTransformForChildAtIndex(View child, int relativeIndex) {
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean expandClipRegion = false;
        canvas.getClipBounds(this.stackInvalidateRect);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Rect childInvalidateRect;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.horizontalOffset == 0 && lp.verticalOffset == 0 || child.getAlpha() == 0.0f || child.getVisibility() != 0) {
                lp.resetInvalidateRect();
            }
            if ((childInvalidateRect = lp.getInvalidateRect()).isEmpty()) continue;
            expandClipRegion = true;
            this.stackInvalidateRect.union(childInvalidateRect);
        }
        if (expandClipRegion) {
            canvas.save();
            canvas.clipRectUnion(this.stackInvalidateRect);
            super.dispatchDraw(canvas);
            canvas.restore();
        } else {
            super.dispatchDraw(canvas);
        }
    }

    private void onLayout() {
        int newSlideAmount;
        if (!this.mFirstLayoutHappened) {
            this.mFirstLayoutHappened = true;
            this.updateChildTransforms();
        }
        if (this.mSlideAmount != (newSlideAmount = Math.round(0.7f * (float)this.getMeasuredHeight()))) {
            this.mSlideAmount = newSlideAmount;
            this.mSwipeThreshold = Math.round(0.2f * (float)newSlideAmount);
        }
        if (Float.compare(this.mPerspectiveShiftY, this.mNewPerspectiveShiftY) != 0 || Float.compare(this.mPerspectiveShiftX, this.mNewPerspectiveShiftX) != 0) {
            this.mPerspectiveShiftY = this.mNewPerspectiveShiftY;
            this.mPerspectiveShiftX = this.mNewPerspectiveShiftX;
            this.updateChildTransforms();
        }
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    float vscroll = event.getAxisValue(9);
                    if (vscroll < 0.0f) {
                        this.pacedScroll(false);
                        return true;
                    }
                    if (!(vscroll > 0.0f)) break;
                    this.pacedScroll(true);
                    return true;
                }
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private void pacedScroll(boolean up) {
        long timeSinceLastScroll = System_Delegate.currentTimeMillis() - this.mLastScrollTime;
        if (timeSinceLastScroll > 100L) {
            if (up) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mLastScrollTime = System_Delegate.currentTimeMillis();
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                if (this.mActivePointerId != -1) break;
                this.mInitialX = ev.getX();
                this.mInitialY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    Log.d("StackView", "Error: No data for our primary pointer.");
                    return false;
                }
                float newY = ev.getY(pointerIndex);
                float deltaY = newY - this.mInitialY;
                this.beginGestureIfNeeded(deltaY);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
            }
        }
        return this.mSwipeGestureType != 0;
    }

    private void beginGestureIfNeeded(float deltaY) {
        if ((int)Math.abs(deltaY) > this.mTouchSlop && this.mSwipeGestureType == 0) {
            int stackMode;
            boolean beginningOfStack;
            int swipeGestureType = deltaY < 0.0f ? 1 : 2;
            this.cancelLongPress();
            this.requestDisallowInterceptTouchEvent(true);
            if (this.mAdapter == null) {
                return;
            }
            int adapterCount = this.getCount();
            int activeIndex = this.mStackMode == 0 ? (swipeGestureType == 2 ? 0 : 1) : (swipeGestureType == 2 ? 1 : 0);
            boolean endOfStack = this.mLoopViews && adapterCount == 1 && (this.mStackMode == 0 && swipeGestureType == 1 || this.mStackMode == 1 && swipeGestureType == 2);
            boolean bl = beginningOfStack = this.mLoopViews && adapterCount == 1 && (this.mStackMode == 1 && swipeGestureType == 1 || this.mStackMode == 0 && swipeGestureType == 2);
            if (this.mLoopViews && !beginningOfStack && !endOfStack) {
                stackMode = 0;
            } else if (this.mCurrentWindowStartUnbounded + activeIndex == -1 || beginningOfStack) {
                ++activeIndex;
                stackMode = 1;
            } else {
                stackMode = this.mCurrentWindowStartUnbounded + activeIndex == adapterCount - 1 || endOfStack ? 2 : 0;
            }
            this.mTransitionIsSetup = stackMode == 0;
            View v = this.getViewAtRelativeIndex(activeIndex);
            if (v == null) {
                return;
            }
            this.setupStackSlider(v, stackMode);
            this.mSwipeGestureType = swipeGestureType;
            this.cancelHandleClick();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        int action = ev.getAction();
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex == -1) {
            Log.d("StackView", "Error: No data for our primary pointer.");
            return false;
        }
        float newY = ev.getY(pointerIndex);
        float newX = ev.getX(pointerIndex);
        float deltaY = newY - this.mInitialY;
        float deltaX = newX - this.mInitialX;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action & 0xFF) {
            case 2: {
                this.beginGestureIfNeeded(deltaY);
                float rx = deltaX / ((float)this.mSlideAmount * 1.0f);
                if (this.mSwipeGestureType == 2) {
                    float r = (deltaY - (float)this.mTouchSlop * 1.0f) / (float)this.mSlideAmount * 1.0f;
                    if (this.mStackMode == 1) {
                        r = 1.0f - r;
                    }
                    this.mStackSlider.setYProgress(1.0f - r);
                    this.mStackSlider.setXProgress(rx);
                    return true;
                }
                if (this.mSwipeGestureType != 1) break;
                float r = -(deltaY + (float)this.mTouchSlop * 1.0f) / (float)this.mSlideAmount * 1.0f;
                if (this.mStackMode == 1) {
                    r = 1.0f - r;
                }
                this.mStackSlider.setYProgress(r);
                this.mStackSlider.setXProgress(rx);
                return true;
            }
            case 1: {
                this.handlePointerUp(ev);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
            }
        }
        return true;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int activePointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(activePointerIndex);
        if (pointerId == this.mActivePointerId) {
            int activeViewIndex = this.mSwipeGestureType == 2 ? 0 : 1;
            View v = this.getViewAtRelativeIndex(activeViewIndex);
            if (v == null) {
                return;
            }
            for (int index = 0; index < ev.getPointerCount(); ++index) {
                if (index == activePointerIndex) continue;
                float x = ev.getX(index);
                float y = ev.getY(index);
                this.mTouchRect.set(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
                if (!this.mTouchRect.contains(Math.round(x), Math.round(y))) continue;
                float oldX = ev.getX(activePointerIndex);
                float oldY = ev.getY(activePointerIndex);
                this.mInitialY += y - oldY;
                this.mInitialX += x - oldX;
                this.mActivePointerId = ev.getPointerId(index);
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.clear();
                }
                return;
            }
            this.handlePointerUp(ev);
        }
    }

    private void handlePointerUp(MotionEvent ev) {
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        float newY = ev.getY(pointerIndex);
        int deltaY = (int)(newY - this.mInitialY);
        this.mLastInteractionTime = System_Delegate.currentTimeMillis();
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
            this.mYVelocity = (int)this.mVelocityTracker.getYVelocity(this.mActivePointerId);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (deltaY > this.mSwipeThreshold && this.mSwipeGestureType == 2 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mHighlight.bringToFront();
        } else if (deltaY < -this.mSwipeThreshold && this.mSwipeGestureType == 1 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showNext();
            } else {
                this.showPrevious();
            }
            this.mHighlight.bringToFront();
        } else if (this.mSwipeGestureType == 1) {
            float finalYProgress = this.mStackMode == 1 ? 1.0f : 0.0f;
            int duration = this.mStackMode == 0 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            PropertyValuesHolder snapBackY = PropertyValuesHolder.ofFloat("YProgress", finalYProgress);
            PropertyValuesHolder snapBackX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
            ObjectAnimator pa = ObjectAnimator.ofPropertyValuesHolder(animationSlider, snapBackX, snapBackY);
            pa.setDuration(duration);
            pa.setInterpolator(new LinearInterpolator());
            pa.start();
        } else if (this.mSwipeGestureType == 2) {
            float finalYProgress = this.mStackMode == 1 ? 0.0f : 1.0f;
            int duration = this.mStackMode == 1 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            PropertyValuesHolder snapBackY = PropertyValuesHolder.ofFloat("YProgress", finalYProgress);
            PropertyValuesHolder snapBackX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
            ObjectAnimator pa = ObjectAnimator.ofPropertyValuesHolder(animationSlider, snapBackX, snapBackY);
            pa.setDuration(duration);
            pa.start();
        }
        this.mActivePointerId = -1;
        this.mSwipeGestureType = 0;
    }

    @Override
    LayoutParams createOrReuseLayoutParams(View v) {
        ViewGroup.LayoutParams currentLp = v.getLayoutParams();
        if (currentLp instanceof LayoutParams) {
            LayoutParams lp = (LayoutParams)currentLp;
            lp.setHorizontalOffset(0);
            lp.setVerticalOffset(0);
            lp.width = 0;
            lp.width = 0;
            return lp;
        }
        return new LayoutParams(v);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.checkForAndHandleDataChanged();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.mPaddingLeft + child.getMeasuredWidth();
            int childBottom = this.mPaddingTop + child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(this.mPaddingLeft + lp.horizontalOffset, this.mPaddingTop + lp.verticalOffset, childRight + lp.horizontalOffset, childBottom + lp.verticalOffset);
        }
        this.onLayout();
    }

    @Override
    public void advance() {
        long timeSinceLastInteraction = System_Delegate.currentTimeMillis() - this.mLastInteractionTime;
        if (this.mAdapter == null) {
            return;
        }
        int adapterCount = this.getCount();
        if (adapterCount == 1 && this.mLoopViews) {
            return;
        }
        if (this.mSwipeGestureType == 0 && timeSinceLastInteraction > 5000L) {
            this.showNext();
        }
    }

    private void measureChildren() {
        int count = this.getChildCount();
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        int childWidth = Math.round((float)measuredWidth * 0.9f) - this.mPaddingLeft - this.mPaddingRight;
        int childHeight = Math.round((float)measuredHeight * 0.9f) - this.mPaddingTop - this.mPaddingBottom;
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(View.MeasureSpec.makeMeasureSpec(childWidth, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(childHeight, Integer.MIN_VALUE));
            if (child == this.mHighlight || child == this.mClickFeedback) continue;
            int childMeasuredWidth = child.getMeasuredWidth();
            int childMeasuredHeight = child.getMeasuredHeight();
            if (childMeasuredWidth > maxWidth) {
                maxWidth = childMeasuredWidth;
            }
            if (childMeasuredHeight <= maxHeight) continue;
            maxHeight = childMeasuredHeight;
        }
        this.mNewPerspectiveShiftX = 0.1f * (float)measuredWidth;
        this.mNewPerspectiveShiftY = 0.1f * (float)measuredHeight;
        if (maxWidth > 0 && count > 0 && maxWidth < childWidth) {
            this.mNewPerspectiveShiftX = measuredWidth - maxWidth;
        }
        if (maxHeight > 0 && count > 0 && maxHeight < childHeight) {
            this.mNewPerspectiveShiftY = measuredHeight - maxHeight;
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean haveChildRefSize = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        float factorY = 1.1111112f;
        if (heightSpecMode == 0) {
            heightSpecSize = haveChildRefSize ? Math.round((float)this.mReferenceChildHeight * (1.0f + factorY)) + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            int height;
            heightSpecSize = haveChildRefSize ? ((height = Math.round((float)this.mReferenceChildHeight * (1.0f + factorY)) + this.mPaddingTop + this.mPaddingBottom) <= heightSpecSize ? height : (heightSpecSize |= 0x1000000)) : 0;
        }
        float factorX = 1.1111112f;
        if (widthSpecMode == 0) {
            widthSpecSize = haveChildRefSize ? Math.round((float)this.mReferenceChildWidth * (1.0f + factorX)) + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            int width;
            widthSpecSize = haveChildRefSize ? ((width = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight) <= widthSpecSize ? width : (widthSpecSize |= 0x1000000)) : 0;
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        this.measureChildren();
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return StackView.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setScrollable(this.getChildCount() > 1);
        if (this.isEnabled()) {
            if (this.getDisplayedChild() < this.getChildCount() - 1) {
                info.addAction(4096);
            }
            if (this.getDisplayedChild() > 0) {
                info.addAction(8192);
            }
        }
    }

    @Override
    public boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action) {
            case 4096: {
                if (this.getDisplayedChild() < this.getChildCount() - 1) {
                    this.showNext();
                    return true;
                }
                return false;
            }
            case 8192: {
                if (this.getDisplayedChild() > 0) {
                    this.showPrevious();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static class HolographicHelper {
        private final Paint mHolographicPaint = new Paint();
        private final Paint mErasePaint = new Paint();
        private final Paint mBlurPaint = new Paint();
        private static final int RES_OUT = 0;
        private static final int CLICK_FEEDBACK = 1;
        private float mDensity;
        private BlurMaskFilter mSmallBlurMaskFilter;
        private BlurMaskFilter mLargeBlurMaskFilter;
        private final Canvas mCanvas = new Canvas();
        private final Canvas mMaskCanvas = new Canvas();
        private final int[] mTmpXY = new int[2];
        private final Matrix mIdentityMatrix = new Matrix();

        HolographicHelper(Context context) {
            this.mDensity = context.getResources().getDisplayMetrics().density;
            this.mHolographicPaint.setFilterBitmap(true);
            this.mHolographicPaint.setMaskFilter(TableMaskFilter.CreateClipTable(0, 30));
            this.mErasePaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.mErasePaint.setFilterBitmap(true);
            this.mSmallBlurMaskFilter = new BlurMaskFilter(2.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
            this.mLargeBlurMaskFilter = new BlurMaskFilter(4.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
        }

        Bitmap createClickOutline(View v, int color2) {
            return this.createOutline(v, 1, color2);
        }

        Bitmap createResOutline(View v, int color2) {
            return this.createOutline(v, 0, color2);
        }

        Bitmap createOutline(View v, int type, int color2) {
            this.mHolographicPaint.setColor(color2);
            if (type == 0) {
                this.mBlurPaint.setMaskFilter(this.mSmallBlurMaskFilter);
            } else if (type == 1) {
                this.mBlurPaint.setMaskFilter(this.mLargeBlurMaskFilter);
            }
            if (v.getMeasuredWidth() == 0 || v.getMeasuredHeight() == 0) {
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap(v.getResources().getDisplayMetrics(), v.getMeasuredWidth(), v.getMeasuredHeight(), Bitmap.Config.ARGB_8888);
            this.mCanvas.setBitmap(bitmap);
            float rotationX = v.getRotationX();
            float rotation = v.getRotation();
            float translationY = v.getTranslationY();
            float translationX = v.getTranslationX();
            v.setRotationX(0.0f);
            v.setRotation(0.0f);
            v.setTranslationY(0.0f);
            v.setTranslationX(0.0f);
            v.draw(this.mCanvas);
            v.setRotationX(rotationX);
            v.setRotation(rotation);
            v.setTranslationY(translationY);
            v.setTranslationX(translationX);
            this.drawOutline(this.mCanvas, bitmap);
            this.mCanvas.setBitmap(null);
            return bitmap;
        }

        void drawOutline(Canvas dest, Bitmap src) {
            int[] xy = this.mTmpXY;
            Bitmap mask = src.extractAlpha(this.mBlurPaint, xy);
            this.mMaskCanvas.setBitmap(mask);
            this.mMaskCanvas.drawBitmap(src, -xy[0], -xy[1], this.mErasePaint);
            dest.drawColor(0, PorterDuff.Mode.CLEAR);
            dest.setMatrix(this.mIdentityMatrix);
            dest.drawBitmap(mask, xy[0], xy[1], this.mHolographicPaint);
            this.mMaskCanvas.setBitmap(null);
            mask.recycle();
        }
    }

    class LayoutParams
    extends ViewGroup.LayoutParams {
        int horizontalOffset;
        int verticalOffset;
        View mView;
        private final Rect parentRect;
        private final Rect invalidateRect;
        private final RectF invalidateRectf;
        private final Rect globalInvalidateRect;

        LayoutParams(View view) {
            super(0, 0);
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.width = 0;
            this.height = 0;
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.mView = view;
        }

        LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.width = 0;
            this.height = 0;
        }

        void invalidateGlobalRegion(View v, Rect r) {
            this.globalInvalidateRect.set(r);
            this.globalInvalidateRect.union(0, 0, StackView.this.getWidth(), StackView.this.getHeight());
            View p = v;
            if (v.getParent() == null || !(v.getParent() instanceof View)) {
                return;
            }
            boolean firstPass = true;
            this.parentRect.set(0, 0, 0, 0);
            while (p.getParent() != null && p.getParent() instanceof View && !this.parentRect.contains(this.globalInvalidateRect)) {
                if (!firstPass) {
                    this.globalInvalidateRect.offset(p.getLeft() - p.getScrollX(), p.getTop() - p.getScrollY());
                }
                firstPass = false;
                p = (View)((Object)p.getParent());
                this.parentRect.set(p.getScrollX(), p.getScrollY(), p.getWidth() + p.getScrollX(), p.getHeight() + p.getScrollY());
                p.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
            }
            p.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
        }

        Rect getInvalidateRect() {
            return this.invalidateRect;
        }

        void resetInvalidateRect() {
            this.invalidateRect.set(0, 0, 0, 0);
        }

        public void setVerticalOffset(int newVerticalOffset) {
            this.setOffsets(this.horizontalOffset, newVerticalOffset);
        }

        public void setHorizontalOffset(int newHorizontalOffset) {
            this.setOffsets(newHorizontalOffset, this.verticalOffset);
        }

        public void setOffsets(int newHorizontalOffset, int newVerticalOffset) {
            int horizontalOffsetDelta = newHorizontalOffset - this.horizontalOffset;
            this.horizontalOffset = newHorizontalOffset;
            int verticalOffsetDelta = newVerticalOffset - this.verticalOffset;
            this.verticalOffset = newVerticalOffset;
            if (this.mView != null) {
                this.mView.requestLayout();
                int left = Math.min(this.mView.getLeft() + horizontalOffsetDelta, this.mView.getLeft());
                int right = Math.max(this.mView.getRight() + horizontalOffsetDelta, this.mView.getRight());
                int top = Math.min(this.mView.getTop() + verticalOffsetDelta, this.mView.getTop());
                int bottom = Math.max(this.mView.getBottom() + verticalOffsetDelta, this.mView.getBottom());
                this.invalidateRectf.set(left, top, right, bottom);
                float xoffset = -this.invalidateRectf.left;
                float yoffset = -this.invalidateRectf.top;
                this.invalidateRectf.offset(xoffset, yoffset);
                this.mView.getMatrix().mapRect(this.invalidateRectf);
                this.invalidateRectf.offset(-xoffset, -yoffset);
                this.invalidateRect.set((int)Math.floor(this.invalidateRectf.left), (int)Math.floor(this.invalidateRectf.top), (int)Math.ceil(this.invalidateRectf.right), (int)Math.ceil(this.invalidateRectf.bottom));
                this.invalidateGlobalRegion(this.mView, this.invalidateRect);
            }
        }
    }

    private class StackSlider {
        View mView;
        float mYProgress;
        float mXProgress;
        static final int NORMAL_MODE = 0;
        static final int BEGINNING_OF_STACK_MODE = 1;
        static final int END_OF_STACK_MODE = 2;
        int mMode = 0;

        public StackSlider() {
        }

        public StackSlider(StackSlider copy) {
            this.mView = copy.mView;
            this.mYProgress = copy.mYProgress;
            this.mXProgress = copy.mXProgress;
            this.mMode = copy.mMode;
        }

        private float cubic(float r) {
            return (float)(Math.pow(2.0f * r - 1.0f, 3.0) + 1.0) / 2.0f;
        }

        private float highlightAlphaInterpolator(float r) {
            float pivot = 0.4f;
            if (r < pivot) {
                return 0.85f * this.cubic(r / pivot);
            }
            return 0.85f * this.cubic(1.0f - (r - pivot) / (1.0f - pivot));
        }

        private float viewAlphaInterpolator(float r) {
            float pivot = 0.3f;
            if (r > pivot) {
                return (r - pivot) / (1.0f - pivot);
            }
            return 0.0f;
        }

        private float rotationInterpolator(float r) {
            float pivot = 0.2f;
            if (r < pivot) {
                return 0.0f;
            }
            return (r - pivot) / (1.0f - pivot);
        }

        void setView(View v) {
            this.mView = v;
        }

        public void setYProgress(float r) {
            int stackDirection;
            r = Math.min(1.0f, r);
            this.mYProgress = r = Math.max(0.0f, r);
            if (this.mView == null) {
                return;
            }
            LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams highlightLp = (LayoutParams)StackView.this.mHighlight.getLayoutParams();
            int n = stackDirection = StackView.this.mStackMode == 0 ? 1 : -1;
            if (Float.compare(0.0f, this.mYProgress) != 0 && Float.compare(1.0f, this.mYProgress) != 0) {
                if (this.mView.getLayerType() == 0) {
                    this.mView.setLayerType(2, null);
                }
            } else if (this.mView.getLayerType() != 0) {
                this.mView.setLayerType(0, null);
            }
            switch (this.mMode) {
                case 0: {
                    viewLp.setVerticalOffset(Math.round(-r * (float)stackDirection * (float)StackView.this.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round(-r * (float)stackDirection * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                    float alpha = this.viewAlphaInterpolator(1.0f - r);
                    if (this.mView.getAlpha() == 0.0f && alpha != 0.0f && this.mView.getVisibility() != 0) {
                        this.mView.setVisibility(0);
                    } else if (alpha == 0.0f && this.mView.getAlpha() != 0.0f && this.mView.getVisibility() == 0) {
                        this.mView.setVisibility(4);
                    }
                    this.mView.setAlpha(alpha);
                    this.mView.setRotationX((float)stackDirection * 90.0f * this.rotationInterpolator(r));
                    StackView.this.mHighlight.setRotationX((float)stackDirection * 90.0f * this.rotationInterpolator(r));
                    break;
                }
                case 2: {
                    viewLp.setVerticalOffset(Math.round((float)(-stackDirection) * (r *= 0.2f) * (float)StackView.this.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round((float)(-stackDirection) * r * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                    break;
                }
                case 1: {
                    r = (1.0f - r) * 0.2f;
                    viewLp.setVerticalOffset(Math.round((float)stackDirection * r * (float)StackView.this.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round((float)stackDirection * r * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                }
            }
        }

        public void setXProgress(float r) {
            r = Math.min(2.0f, r);
            this.mXProgress = r = Math.max(-2.0f, r);
            if (this.mView == null) {
                return;
            }
            LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams highlightLp = (LayoutParams)StackView.this.mHighlight.getLayoutParams();
            viewLp.setHorizontalOffset(Math.round((r *= 0.2f) * (float)StackView.this.mSlideAmount));
            highlightLp.setHorizontalOffset(Math.round(r * (float)StackView.this.mSlideAmount));
        }

        void setMode(int mode) {
            this.mMode = mode;
        }

        float getDurationForNeutralPosition() {
            return this.getDuration(false, 0.0f);
        }

        float getDurationForOffscreenPosition() {
            return this.getDuration(true, 0.0f);
        }

        float getDurationForNeutralPosition(float velocity) {
            return this.getDuration(false, velocity);
        }

        float getDurationForOffscreenPosition(float velocity) {
            return this.getDuration(true, velocity);
        }

        private float getDuration(boolean invert, float velocity) {
            if (this.mView != null) {
                float duration;
                float maxd;
                LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
                float d = (float)Math.hypot(viewLp.horizontalOffset, viewLp.verticalOffset);
                if (d > (maxd = (float)Math.hypot(StackView.this.mSlideAmount, 0.4f * (float)StackView.this.mSlideAmount))) {
                    d = maxd;
                }
                if (velocity == 0.0f) {
                    return (invert ? 1.0f - d / maxd : d / maxd) * 400.0f;
                }
                float f = duration = invert ? d / Math.abs(velocity) : (maxd - d) / Math.abs(velocity);
                if (duration < 50.0f || duration > 400.0f) {
                    return this.getDuration(invert, 0.0f);
                }
                return duration;
            }
            return 0.0f;
        }

        public float getYProgress() {
            return this.mYProgress;
        }

        public float getXProgress() {
            return this.mXProgress;
        }
    }

    private static class StackFrame
    extends FrameLayout {
        WeakReference<ObjectAnimator> transformAnimator;
        WeakReference<ObjectAnimator> sliderAnimator;

        public StackFrame(Context context) {
            super(context);
        }

        void setTransformAnimator(ObjectAnimator oa) {
            this.transformAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        void setSliderAnimator(ObjectAnimator oa) {
            this.sliderAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        boolean cancelTransformAnimator() {
            ObjectAnimator oa;
            if (this.transformAnimator != null && (oa = (ObjectAnimator)this.transformAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }

        boolean cancelSliderAnimator() {
            ObjectAnimator oa;
            if (this.sliderAnimator != null && (oa = (ObjectAnimator)this.sliderAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }
    }
}

