/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.UnsupportedAppUsage;
import android.content.pm.PackageInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;

public interface IWebViewUpdateService
extends IInterface {
    public void notifyRelroCreationCompleted() throws RemoteException;

    public WebViewProviderResponse waitForAndGetProvider() throws RemoteException;

    public String changeProviderAndSetting(String var1) throws RemoteException;

    @UnsupportedAppUsage
    public WebViewProviderInfo[] getValidWebViewPackages() throws RemoteException;

    public WebViewProviderInfo[] getAllWebViewPackages() throws RemoteException;

    @UnsupportedAppUsage
    public String getCurrentWebViewPackageName() throws RemoteException;

    public PackageInfo getCurrentWebViewPackage() throws RemoteException;

    public boolean isMultiProcessEnabled() throws RemoteException;

    public void enableMultiProcess(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWebViewUpdateService {
        private static final String DESCRIPTOR = "android.webkit.IWebViewUpdateService";
        static final int TRANSACTION_notifyRelroCreationCompleted = 1;
        static final int TRANSACTION_waitForAndGetProvider = 2;
        static final int TRANSACTION_changeProviderAndSetting = 3;
        static final int TRANSACTION_getValidWebViewPackages = 4;
        static final int TRANSACTION_getAllWebViewPackages = 5;
        static final int TRANSACTION_getCurrentWebViewPackageName = 6;
        static final int TRANSACTION_getCurrentWebViewPackage = 7;
        static final int TRANSACTION_isMultiProcessEnabled = 8;
        static final int TRANSACTION_enableMultiProcess = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWebViewUpdateService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWebViewUpdateService) {
                return (IWebViewUpdateService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyRelroCreationCompleted";
                }
                case 2: {
                    return "waitForAndGetProvider";
                }
                case 3: {
                    return "changeProviderAndSetting";
                }
                case 4: {
                    return "getValidWebViewPackages";
                }
                case 5: {
                    return "getAllWebViewPackages";
                }
                case 6: {
                    return "getCurrentWebViewPackageName";
                }
                case 7: {
                    return "getCurrentWebViewPackage";
                }
                case 8: {
                    return "isMultiProcessEnabled";
                }
                case 9: {
                    return "enableMultiProcess";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    this.notifyRelroCreationCompleted();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    WebViewProviderResponse _result = this.waitForAndGetProvider();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.changeProviderAndSetting(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getValidWebViewPackages();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getAllWebViewPackages();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCurrentWebViewPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    PackageInfo _result = this.getCurrentWebViewPackage();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMultiProcessEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.enableMultiProcess(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWebViewUpdateService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWebViewUpdateService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWebViewUpdateService {
            private IBinder mRemote;
            public static IWebViewUpdateService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRelroCreationCompleted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRelroCreationCompleted();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WebViewProviderResponse waitForAndGetProvider() throws RemoteException {
                WebViewProviderResponse _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WebViewProviderResponse webViewProviderResponse = Stub.getDefaultImpl().waitForAndGetProvider();
                        return webViewProviderResponse;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WebViewProviderResponse.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String changeProviderAndSetting(String newProvider) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(newProvider);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().changeProviderAndSetting(newProvider);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WebViewProviderInfo[] getValidWebViewPackages() throws RemoteException {
                WebViewProviderInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WebViewProviderInfo[] webViewProviderInfoArray = Stub.getDefaultImpl().getValidWebViewPackages();
                        return webViewProviderInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(WebViewProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WebViewProviderInfo[] getAllWebViewPackages() throws RemoteException {
                WebViewProviderInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WebViewProviderInfo[] webViewProviderInfoArray = Stub.getDefaultImpl().getAllWebViewPackages();
                        return webViewProviderInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(WebViewProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentWebViewPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCurrentWebViewPackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageInfo getCurrentWebViewPackage() throws RemoteException {
                PackageInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PackageInfo packageInfo = Stub.getDefaultImpl().getCurrentWebViewPackage();
                        return packageInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PackageInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultiProcessEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isMultiProcessEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableMultiProcess(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableMultiProcess(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWebViewUpdateService {
        @Override
        public void notifyRelroCreationCompleted() throws RemoteException {
        }

        @Override
        public WebViewProviderResponse waitForAndGetProvider() throws RemoteException {
            return null;
        }

        @Override
        public String changeProviderAndSetting(String newProvider) throws RemoteException {
            return null;
        }

        @Override
        public WebViewProviderInfo[] getValidWebViewPackages() throws RemoteException {
            return null;
        }

        @Override
        public WebViewProviderInfo[] getAllWebViewPackages() throws RemoteException {
            return null;
        }

        @Override
        public String getCurrentWebViewPackageName() throws RemoteException {
            return null;
        }

        @Override
        public PackageInfo getCurrentWebViewPackage() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMultiProcessEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void enableMultiProcess(boolean enable) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

