/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier.intent;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.textclassifier.Log;
import android.view.textclassifier.intent.LabeledIntent;
import com.android.internal.annotations.VisibleForTesting;
import com.google.android.textclassifier.NamedVariant;
import com.google.android.textclassifier.RemoteActionTemplate;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class TemplateIntentFactory {
    private static final String TAG = "androidtc";

    public List<LabeledIntent> create(RemoteActionTemplate[] remoteActionTemplates) {
        if (remoteActionTemplates.length == 0) {
            return new ArrayList<LabeledIntent>();
        }
        ArrayList<LabeledIntent> labeledIntents = new ArrayList<LabeledIntent>();
        for (RemoteActionTemplate remoteActionTemplate : remoteActionTemplates) {
            if (!TemplateIntentFactory.isValidTemplate(remoteActionTemplate)) {
                Log.w(TAG, "Invalid RemoteActionTemplate skipped.");
                continue;
            }
            labeledIntents.add(new LabeledIntent(remoteActionTemplate.titleWithoutEntity, remoteActionTemplate.titleWithEntity, remoteActionTemplate.description, remoteActionTemplate.descriptionWithAppName, TemplateIntentFactory.createIntent(remoteActionTemplate), remoteActionTemplate.requestCode == null ? 0 : remoteActionTemplate.requestCode));
        }
        return labeledIntents;
    }

    private static boolean isValidTemplate(RemoteActionTemplate remoteActionTemplate) {
        if (remoteActionTemplate == null) {
            Log.w(TAG, "Invalid RemoteActionTemplate: is null");
            return false;
        }
        if (TextUtils.isEmpty(remoteActionTemplate.titleWithEntity) && TextUtils.isEmpty(remoteActionTemplate.titleWithoutEntity)) {
            Log.w(TAG, "Invalid RemoteActionTemplate: title is null");
            return false;
        }
        if (TextUtils.isEmpty(remoteActionTemplate.description)) {
            Log.w(TAG, "Invalid RemoteActionTemplate: description is null");
            return false;
        }
        if (!TextUtils.isEmpty(remoteActionTemplate.packageName)) {
            Log.w(TAG, "Invalid RemoteActionTemplate: package name is set");
            return false;
        }
        if (TextUtils.isEmpty(remoteActionTemplate.action)) {
            Log.w(TAG, "Invalid RemoteActionTemplate: intent action not set");
            return false;
        }
        return true;
    }

    private static Intent createIntent(RemoteActionTemplate remoteActionTemplate) {
        Intent intent = new Intent(remoteActionTemplate.action);
        Uri uri = TextUtils.isEmpty(remoteActionTemplate.data) ? null : Uri.parse(remoteActionTemplate.data).normalizeScheme();
        String type = TextUtils.isEmpty(remoteActionTemplate.type) ? null : Intent.normalizeMimeType(remoteActionTemplate.type);
        intent.setDataAndType(uri, type);
        intent.setFlags(remoteActionTemplate.flags == null ? 0 : remoteActionTemplate.flags);
        if (remoteActionTemplate.category != null) {
            for (String category : remoteActionTemplate.category) {
                if (category == null) continue;
                intent.addCategory(category);
            }
        }
        intent.putExtras(TemplateIntentFactory.nameVariantsToBundle(remoteActionTemplate.extras));
        return intent;
    }

    public static Bundle nameVariantsToBundle(NamedVariant[] namedVariants) {
        if (namedVariants == null) {
            return Bundle.EMPTY;
        }
        Bundle bundle = new Bundle();
        block8: for (NamedVariant namedVariant : namedVariants) {
            if (namedVariant == null) continue;
            switch (namedVariant.getType()) {
                case 1: {
                    bundle.putInt(namedVariant.getName(), namedVariant.getInt());
                    continue block8;
                }
                case 2: {
                    bundle.putLong(namedVariant.getName(), namedVariant.getLong());
                    continue block8;
                }
                case 3: {
                    bundle.putFloat(namedVariant.getName(), namedVariant.getFloat());
                    continue block8;
                }
                case 4: {
                    bundle.putDouble(namedVariant.getName(), namedVariant.getDouble());
                    continue block8;
                }
                case 5: {
                    bundle.putBoolean(namedVariant.getName(), namedVariant.getBool());
                    continue block8;
                }
                case 6: {
                    bundle.putString(namedVariant.getName(), namedVariant.getString());
                    continue block8;
                }
                default: {
                    Log.w(TAG, "Unsupported type found in nameVariantsToBundle : " + namedVariant.getType());
                }
            }
        }
        return bundle;
    }
}

