/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import android.util.KeyValueListParser;
import android.view.textclassifier.Log;
import android.view.textclassifier.ModelFileManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Supplier;

public class ActionsModelParamsSupplier
implements Supplier<ActionsModelParams> {
    private static final String TAG = "androidtc";
    @VisibleForTesting
    static final String KEY_REQUIRED_MODEL_VERSION = "required_model_version";
    @VisibleForTesting
    static final String KEY_REQUIRED_LOCALES = "required_locales";
    @VisibleForTesting
    static final String KEY_SERIALIZED_PRECONDITIONS = "serialized_preconditions";
    private final Context mAppContext;
    private final SettingsObserver mSettingsObserver;
    private final Object mLock = new Object();
    private final Runnable mOnChangedListener;
    @GuardedBy(value={"mLock"})
    private ActionsModelParams mActionsModelParams;
    @GuardedBy(value={"mLock"})
    private boolean mParsed = true;

    public ActionsModelParamsSupplier(Context context, Runnable onChangedListener) {
        this.mAppContext = Preconditions.checkNotNull(context).getApplicationContext();
        this.mOnChangedListener = onChangedListener == null ? () -> {} : onChangedListener;
        this.mSettingsObserver = new SettingsObserver(this.mAppContext, () -> {
            Object object = this.mLock;
            synchronized (object) {
                Log.v(TAG, "Settings.Global.TEXT_CLASSIFIER_ACTION_MODEL_PARAMS is updated");
                this.mParsed = true;
                this.mOnChangedListener.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionsModelParams get() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mParsed) {
                this.mActionsModelParams = this.parse(this.mAppContext.getContentResolver());
                this.mParsed = false;
            }
        }
        return this.mActionsModelParams;
    }

    private ActionsModelParams parse(ContentResolver contentResolver) {
        String settingStr = Settings.Global.getString(contentResolver, "text_classifier_action_model_params");
        if (TextUtils.isEmpty(settingStr)) {
            return ActionsModelParams.INVALID;
        }
        try {
            KeyValueListParser keyValueListParser = new KeyValueListParser(',');
            keyValueListParser.setString(settingStr);
            int version = keyValueListParser.getInt(KEY_REQUIRED_MODEL_VERSION, -1);
            if (version == -1) {
                Log.w(TAG, "ActionsModelParams.Parse, invalid model version");
                return ActionsModelParams.INVALID;
            }
            String locales = keyValueListParser.getString(KEY_REQUIRED_LOCALES, null);
            if (locales == null) {
                Log.w(TAG, "ActionsModelParams.Parse, invalid locales");
                return ActionsModelParams.INVALID;
            }
            String serializedPreconditionsStr = keyValueListParser.getString(KEY_SERIALIZED_PRECONDITIONS, null);
            if (serializedPreconditionsStr == null) {
                Log.w(TAG, "ActionsModelParams.Parse, invalid preconditions");
                return ActionsModelParams.INVALID;
            }
            byte[] serializedPreconditions = Base64.decode(serializedPreconditionsStr, 2);
            return new ActionsModelParams(version, locales, serializedPreconditions);
        }
        catch (Throwable t) {
            Log.e(TAG, "Invalid TEXT_CLASSIFIER_ACTION_MODEL_PARAMS, ignore", t);
            return ActionsModelParams.INVALID;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.mAppContext.getContentResolver().unregisterContentObserver(this.mSettingsObserver);
        }
        finally {
            super.finalize();
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final WeakReference<Runnable> mOnChangedListener;

        SettingsObserver(Context appContext, Runnable listener) {
            super(null);
            this.mOnChangedListener = new WeakReference<Runnable>(listener);
            appContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("text_classifier_action_model_params"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            if (this.mOnChangedListener.get() != null) {
                ((Runnable)this.mOnChangedListener.get()).run();
            }
        }
    }

    public static class ActionsModelParams {
        public static final ActionsModelParams INVALID = new ActionsModelParams(-1, "", new byte[0]);
        private final int mRequiredModelVersion;
        private final String mRequiredModelLocales;
        private final byte[] mSerializedPreconditions;

        public ActionsModelParams(int requiredModelVersion, String requiredModelLocales, byte[] serializedPreconditions) {
            this.mRequiredModelVersion = requiredModelVersion;
            this.mRequiredModelLocales = Preconditions.checkNotNull(requiredModelLocales);
            this.mSerializedPreconditions = Preconditions.checkNotNull(serializedPreconditions);
        }

        public byte[] getSerializedPreconditions(ModelFileManager.ModelFile modelInUse) {
            if (this == INVALID) {
                return null;
            }
            if (modelInUse.getVersion() != this.mRequiredModelVersion) {
                Log.w(ActionsModelParamsSupplier.TAG, String.format("Not applying mSerializedPreconditions, required version=%d, actual=%d", this.mRequiredModelVersion, modelInUse.getVersion()));
                return null;
            }
            if (!Objects.equals(modelInUse.getSupportedLocalesStr(), this.mRequiredModelLocales)) {
                Log.w(ActionsModelParamsSupplier.TAG, String.format("Not applying mSerializedPreconditions, required locales=%s, actual=%s", this.mRequiredModelLocales, modelInUse.getSupportedLocalesStr()));
                return null;
            }
            return this.mSerializedPreconditions;
        }
    }
}

