/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

class SpotShadowVertexCalculator {
    private SpotShadowVertexCalculator() {
    }

    public static float[] calculateLight(float radius, float x, float y, float height) {
        float[] ret = new float[]{x, y + radius, height, x - radius, y, height, x, y - radius, height, x + radius, y, height};
        return ret;
    }

    public static int[] getStripSizes(int polyLength) {
        return new int[]{(polyLength + 4) / 8 * 16 + 2, 4};
    }

    public static void calculateShadow(float[] lightPoly, float[] poly, int polyLength, float strength, float[][] retstrips) {
        float lz;
        float[] outerStrip = retstrips[0];
        int roundedEdgeSegments = polyLength == 4 ? 0 : 5;
        int sideLength = (roundedEdgeSegments / 2 + 1) * 2;
        float[] umbra = new float[8 * sideLength];
        int idx = (roundedEdgeSegments + 1) / 2;
        int uShift = 0;
        int rollBack = polyLength % 8 == 0 ? 0 : 1;
        for (int s = 0; s < 4; ++s) {
            float lx = lightPoly[s * 3 + 0];
            float ly = lightPoly[s * 3 + 1];
            lz = lightPoly[s * 3 + 2];
            int i = 0;
            while (i < sideLength) {
                int shift = idx % polyLength * 3;
                float t = lz / (lz - poly[shift + 2]);
                umbra[uShift + 0] = lx - t * (lx - poly[shift + 0]);
                umbra[uShift + 1] = ly - t * (ly - poly[shift + 1]);
                ++i;
                uShift += 2;
                ++idx;
            }
            idx -= rollBack;
        }
        idx = roundedEdgeSegments;
        float[] penumbraRect = new float[4];
        int s = 0;
        while (s < 4) {
            int sp = (s + 2) % 4;
            lz = lightPoly[sp * 3 + 2];
            int shift = idx % polyLength * 3;
            float t = lz / (lz - poly[shift + 2]);
            int c = (s + 1) % 2;
            penumbraRect[s] = lightPoly[sp * 3 + c] - t * (lightPoly[sp * 3 + c] - poly[shift + c]);
            ++s;
            idx += roundedEdgeSegments + 1;
        }
        if (penumbraRect[0] > penumbraRect[2]) {
            float tmp;
            penumbraRect[0] = penumbraRect[2] = (tmp = (penumbraRect[0] + penumbraRect[2]) / 2.0f);
        }
        if (penumbraRect[3] > penumbraRect[1]) {
            float tmp;
            penumbraRect[1] = penumbraRect[3] = (tmp = (penumbraRect[1] + penumbraRect[3]) / 2.0f);
        }
        idx = sideLength * 4 - sideLength / 2;
        int rsShift = 0;
        for (int s2 = 0; s2 < 4; ++s2) {
            int xidx = (s2 + 3) % 4 / 2 * 2 + 1;
            int yidx = s2 / 2 * 2;
            float penumbraX = penumbraRect[xidx];
            float penumbraY = penumbraRect[yidx];
            int i = 0;
            while (i < sideLength) {
                int shift = idx % (sideLength * 4) * 2;
                outerStrip[rsShift + 0] = umbra[shift + 0];
                outerStrip[rsShift + 1] = umbra[shift + 1];
                outerStrip[rsShift + 3] = penumbraX;
                outerStrip[rsShift + 4] = penumbraY;
                outerStrip[rsShift + 5] = strength;
                ++i;
                rsShift += 6;
                ++idx;
            }
        }
        outerStrip[rsShift + 0] = outerStrip[0];
        outerStrip[rsShift + 1] = outerStrip[1];
        outerStrip[rsShift + 3] = outerStrip[3];
        outerStrip[rsShift + 4] = outerStrip[4];
        outerStrip[rsShift + 5] = strength;
        float[] innerStrip = retstrips[1];
        innerStrip[0] = penumbraRect[3];
        innerStrip[1] = penumbraRect[0];
        innerStrip[2] = strength;
        innerStrip[3] = penumbraRect[1];
        innerStrip[4] = penumbraRect[0];
        innerStrip[5] = strength;
        innerStrip[6] = penumbraRect[3];
        innerStrip[7] = penumbraRect[2];
        innerStrip[8] = strength;
        innerStrip[9] = penumbraRect[1];
        innerStrip[10] = penumbraRect[2];
        innerStrip[11] = strength;
    }
}

