/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

class SpotShadowConfig {
    private final int mLightRadius;
    private final float[] mPoly;
    private final int mPolyLength;
    private float[] mLightCoord;
    private final float mShadowStrength;

    private SpotShadowConfig(Builder builder) {
        this.mLightRadius = builder.mLightRadius;
        this.mPoly = builder.mPoly;
        this.mPolyLength = builder.mPolyLength;
        this.mLightCoord = new float[3];
        this.mLightCoord[0] = builder.mLightX;
        this.mLightCoord[1] = builder.mLightY;
        this.mLightCoord[2] = builder.mLightHeight;
        this.mShadowStrength = builder.mShadowStrength;
    }

    public int getLightRadius() {
        return this.mLightRadius;
    }

    public float[] getPoly() {
        return this.mPoly;
    }

    public int getPolyLength() {
        return this.mPolyLength;
    }

    public void setLightCoord(float x, float y) {
        this.mLightCoord[0] = x;
        this.mLightCoord[1] = y;
    }

    public float getShadowStrength() {
        return this.mShadowStrength;
    }

    public float[] getLightCoord() {
        return this.mLightCoord;
    }

    public static class Builder {
        private int mLightRadius;
        private float[] mPoly;
        private int mPolyLength;
        private float mLightX;
        private float mLightY;
        private float mLightHeight;
        private float mShadowStrength;

        public Builder setShadowStrength(float shadowStrength) {
            this.mShadowStrength = shadowStrength;
            return this;
        }

        public Builder setLightRadius(int mLightRadius) {
            this.mLightRadius = mLightRadius;
            return this;
        }

        public Builder setPolygon(float[] poly, int polyLength) {
            this.mPoly = poly;
            this.mPolyLength = polyLength;
            return this;
        }

        public Builder setLightCoord(float lightX, float lightY, float lightHeight) {
            this.mLightX = lightX;
            this.mLightY = lightY;
            this.mLightHeight = lightHeight;
            return this;
        }

        public SpotShadowConfig build() {
            return new SpotShadowConfig(this);
        }
    }
}

