/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ViewNode;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class ContentCaptureEvent
implements Parcelable {
    private static final String TAG = ContentCaptureEvent.class.getSimpleName();
    public static final int TYPE_SESSION_FINISHED = -2;
    public static final int TYPE_SESSION_STARTED = -1;
    public static final int TYPE_VIEW_APPEARED = 1;
    public static final int TYPE_VIEW_DISAPPEARED = 2;
    public static final int TYPE_VIEW_TEXT_CHANGED = 3;
    public static final int TYPE_VIEW_TREE_APPEARING = 4;
    public static final int TYPE_VIEW_TREE_APPEARED = 5;
    public static final int TYPE_CONTEXT_UPDATED = 6;
    public static final int TYPE_SESSION_RESUMED = 7;
    public static final int TYPE_SESSION_PAUSED = 8;
    private final int mSessionId;
    private final int mType;
    private final long mEventTime;
    private AutofillId mId;
    private ArrayList<AutofillId> mIds;
    private ViewNode mNode;
    private CharSequence mText;
    private int mParentSessionId = 0;
    private ContentCaptureContext mClientContext;
    public static final Parcelable.Creator<ContentCaptureEvent> CREATOR = new Parcelable.Creator<ContentCaptureEvent>(){

        @Override
        public ContentCaptureEvent createFromParcel(Parcel parcel) {
            ViewNode node;
            ArrayList<AutofillId> ids;
            int sessionId = parcel.readInt();
            int type = parcel.readInt();
            long eventTime = parcel.readLong();
            ContentCaptureEvent event = new ContentCaptureEvent(sessionId, type, eventTime);
            AutofillId id2 = (AutofillId)parcel.readParcelable(null);
            if (id2 != null) {
                event.setAutofillId(id2);
            }
            if ((ids = parcel.createTypedArrayList(AutofillId.CREATOR)) != null) {
                event.setAutofillIds(ids);
            }
            if ((node = ViewNode.readFromParcel(parcel)) != null) {
                event.setViewNode(node);
            }
            event.setText(parcel.readCharSequence());
            if (type == -1 || type == -2) {
                event.setParentSessionId(parcel.readInt());
            }
            if (type == -1 || type == 6) {
                event.setClientContext((ContentCaptureContext)parcel.readParcelable(null));
            }
            return event;
        }

        public ContentCaptureEvent[] newArray(int size) {
            return new ContentCaptureEvent[size];
        }
    };

    public ContentCaptureEvent(int sessionId, int type, long eventTime) {
        this.mSessionId = sessionId;
        this.mType = type;
        this.mEventTime = eventTime;
    }

    public ContentCaptureEvent(int sessionId, int type) {
        this(sessionId, type, System_Delegate.currentTimeMillis());
    }

    public ContentCaptureEvent setAutofillId(AutofillId id2) {
        this.mId = Preconditions.checkNotNull(id2);
        return this;
    }

    public ContentCaptureEvent setAutofillIds(ArrayList<AutofillId> ids) {
        this.mIds = Preconditions.checkNotNull(ids);
        return this;
    }

    public ContentCaptureEvent addAutofillId(AutofillId id2) {
        Preconditions.checkNotNull(id2);
        if (this.mIds == null) {
            this.mIds = new ArrayList();
            if (this.mId == null) {
                Log.w(TAG, "addAutofillId(" + id2 + ") called without an initial id");
            } else {
                this.mIds.add(this.mId);
                this.mId = null;
            }
        }
        this.mIds.add(id2);
        return this;
    }

    public ContentCaptureEvent setParentSessionId(int parentSessionId) {
        this.mParentSessionId = parentSessionId;
        return this;
    }

    public ContentCaptureEvent setClientContext(ContentCaptureContext clientContext) {
        this.mClientContext = clientContext;
        return this;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public int getParentSessionId() {
        return this.mParentSessionId;
    }

    public ContentCaptureContext getContentCaptureContext() {
        return this.mClientContext;
    }

    public ContentCaptureEvent setViewNode(ViewNode node) {
        this.mNode = Preconditions.checkNotNull(node);
        return this;
    }

    public ContentCaptureEvent setText(CharSequence text) {
        this.mText = text;
        return this;
    }

    public int getType() {
        return this.mType;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public ViewNode getViewNode() {
        return this.mNode;
    }

    public AutofillId getId() {
        return this.mId;
    }

    public List<AutofillId> getIds() {
        return this.mIds;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void mergeEvent(ContentCaptureEvent event) {
        Preconditions.checkNotNull(event);
        int eventType = event.getType();
        if (this.mType != eventType) {
            Log.e(TAG, "mergeEvent(" + ContentCaptureEvent.getTypeAsString(eventType) + ") cannot be merged with different eventType=" + ContentCaptureEvent.getTypeAsString(this.mType));
            return;
        }
        if (eventType == 2) {
            List<AutofillId> ids = event.getIds();
            AutofillId id2 = event.getId();
            if (ids != null) {
                if (id2 != null) {
                    Log.w(TAG, "got TYPE_VIEW_DISAPPEARED event with both id and ids: " + event);
                }
                for (int i = 0; i < ids.size(); ++i) {
                    this.addAutofillId(ids.get(i));
                }
                return;
            }
            if (id2 != null) {
                this.addAutofillId(id2);
                return;
            }
            throw new IllegalArgumentException("mergeEvent(): got TYPE_VIEW_DISAPPEARED event with neither id or ids: " + event);
        }
        if (eventType == 3) {
            this.setText(event.getText());
        } else {
            Log.e(TAG, "mergeEvent(" + ContentCaptureEvent.getTypeAsString(eventType) + ") does not support this event type.");
        }
    }

    public void dump(PrintWriter pw) {
        pw.print("type=");
        pw.print(ContentCaptureEvent.getTypeAsString(this.mType));
        pw.print(", time=");
        pw.print(this.mEventTime);
        if (this.mId != null) {
            pw.print(", id=");
            pw.print(this.mId);
        }
        if (this.mIds != null) {
            pw.print(", ids=");
            pw.print(this.mIds);
        }
        if (this.mNode != null) {
            pw.print(", mNode.id=");
            pw.print(this.mNode.getAutofillId());
        }
        if (this.mSessionId != 0) {
            pw.print(", sessionId=");
            pw.print(this.mSessionId);
        }
        if (this.mParentSessionId != 0) {
            pw.print(", parentSessionId=");
            pw.print(this.mParentSessionId);
        }
        if (this.mText != null) {
            pw.print(", text=");
            pw.println(ContentCaptureHelper.getSanitizedString(this.mText));
        }
        if (this.mClientContext != null) {
            pw.print(", context=");
            this.mClientContext.dump(pw);
            pw.println();
        }
    }

    public String toString() {
        StringBuilder string2 = new StringBuilder("ContentCaptureEvent[type=").append(ContentCaptureEvent.getTypeAsString(this.mType));
        string2.append(", session=").append(this.mSessionId);
        if (this.mType == -1 && this.mParentSessionId != 0) {
            string2.append(", parent=").append(this.mParentSessionId);
        }
        if (this.mId != null) {
            string2.append(", id=").append(this.mId);
        }
        if (this.mIds != null) {
            string2.append(", ids=").append(this.mIds);
        }
        if (this.mNode != null) {
            String className = this.mNode.getClassName();
            if (this.mNode != null) {
                string2.append(", class=").append(className);
            }
            string2.append(", id=").append(this.mNode.getAutofillId());
        }
        if (this.mText != null) {
            string2.append(", text=").append(ContentCaptureHelper.getSanitizedString(this.mText));
        }
        if (this.mClientContext != null) {
            string2.append(", context=").append(this.mClientContext);
        }
        return string2.append(']').toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mSessionId);
        parcel.writeInt(this.mType);
        parcel.writeLong(this.mEventTime);
        parcel.writeParcelable(this.mId, flags);
        parcel.writeTypedList(this.mIds);
        ViewNode.writeToParcel(parcel, this.mNode, flags);
        parcel.writeCharSequence(this.mText);
        if (this.mType == -1 || this.mType == -2) {
            parcel.writeInt(this.mParentSessionId);
        }
        if (this.mType == -1 || this.mType == 6) {
            parcel.writeParcelable(this.mClientContext, flags);
        }
    }

    public static String getTypeAsString(int type) {
        switch (type) {
            case -1: {
                return "SESSION_STARTED";
            }
            case -2: {
                return "SESSION_FINISHED";
            }
            case 7: {
                return "SESSION_RESUMED";
            }
            case 8: {
                return "SESSION_PAUSED";
            }
            case 1: {
                return "VIEW_APPEARED";
            }
            case 2: {
                return "VIEW_DISAPPEARED";
            }
            case 3: {
                return "VIEW_TEXT_CHANGED";
            }
            case 4: {
                return "VIEW_TREE_APPEARING";
            }
            case 5: {
                return "VIEW_TREE_APPEARED";
            }
            case 6: {
                return "CONTEXT_UPDATED";
            }
        }
        return "UKNOWN_TYPE: " + type;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }
}

