/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityRequestPreparer;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IntPair;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class _Original_AccessibilityManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManager";
    public static final int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static final int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    public static final int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static final int DALTONIZER_DISABLED = -1;
    @UnsupportedAppUsage
    public static final int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    public static final int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    public static final int AUTOCLICK_DELAY_DEFAULT = 600;
    public static final String ACTION_CHOOSE_ACCESSIBILITY_BUTTON = "com.android.internal.intent.action.CHOOSE_ACCESSIBILITY_BUTTON";
    public static final int FLAG_CONTENT_ICONS = 1;
    public static final int FLAG_CONTENT_TEXT = 2;
    public static final int FLAG_CONTENT_CONTROLS = 4;
    @UnsupportedAppUsage
    static final Object sInstanceSync = new Object();
    @UnsupportedAppUsage
    private static _Original_AccessibilityManager sInstance;
    @UnsupportedAppUsage
    private final Object mLock = new Object();
    @UnsupportedAppUsage
    private IAccessibilityManager mService;
    @UnsupportedAppUsage
    final int mUserId;
    @UnsupportedAppUsage
    final Handler mHandler;
    final Handler.Callback mCallback;
    @UnsupportedAppUsage(maxTargetSdk=28)
    boolean mIsEnabled;
    int mRelevantEventTypes = -1;
    int mInteractiveUiTimeout;
    int mNonInteractiveUiTimeout;
    boolean mIsTouchExplorationEnabled;
    @UnsupportedAppUsage(trackingBug=123768939L)
    boolean mIsHighTextContrastEnabled;
    AccessibilityPolicy mAccessibilityPolicy;
    @UnsupportedAppUsage
    private final ArrayMap<AccessibilityManager.AccessibilityStateChangeListener, Handler> mAccessibilityStateChangeListeners = new ArrayMap();
    private final ArrayMap<AccessibilityManager.TouchExplorationStateChangeListener, Handler> mTouchExplorationStateChangeListeners = new ArrayMap();
    private final ArrayMap<AccessibilityManager.HighTextContrastChangeListener, Handler> mHighTextContrastStateChangeListeners = new ArrayMap();
    private final ArrayMap<AccessibilityManager.AccessibilityServicesStateChangeListener, Handler> mServicesStateChangeListeners = new ArrayMap();
    private SparseArray<List<AccessibilityRequestPreparer>> mRequestPreparerLists;
    private final IAccessibilityManagerClient.Stub mClient = new IAccessibilityManagerClient.Stub(){

        @Override
        public void setState(int state) {
            _Original_AccessibilityManager.this.mHandler.obtainMessage(1, state, 0).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyServicesStateChanged(long updatedUiTimeout) {
            ArrayMap listeners;
            _Original_AccessibilityManager.this.updateUiTimeout(updatedUiTimeout);
            Object object = _Original_AccessibilityManager.this.mLock;
            synchronized (object) {
                if (_Original_AccessibilityManager.this.mServicesStateChangeListeners.isEmpty()) {
                    return;
                }
                listeners = new ArrayMap(_Original_AccessibilityManager.this.mServicesStateChangeListeners);
            }
            int numListeners = listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                AccessibilityServicesStateChangeListener listener = (AccessibilityServicesStateChangeListener)_Original_AccessibilityManager.this.mServicesStateChangeListeners.keyAt(i);
                ((Handler)_Original_AccessibilityManager.this.mServicesStateChangeListeners.valueAt(i)).post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$notifyServicesStateChanged$0(android.view.accessibility.AccessibilityManager$AccessibilityServicesStateChangeListener ), ()V)((Object)this, (AccessibilityManager.AccessibilityServicesStateChangeListener)listener));
            }
        }

        @Override
        public void setRelevantEventTypes(int eventTypes) {
            _Original_AccessibilityManager.this.mRelevantEventTypes = eventTypes;
        }

        private /* synthetic */ void lambda$notifyServicesStateChanged$0(AccessibilityServicesStateChangeListener listener) {
            listener.onAccessibilityServicesStateChanged(_Original_AccessibilityManager.this);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static _Original_AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : context.getUserId();
                sInstance = new _Original_AccessibilityManager(context, null, userId);
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _Original_AccessibilityManager(Context context, IAccessibilityManager service, int userId) {
        this.mCallback = new MyCallback();
        this.mHandler = new Handler(context.getMainLooper(), this.mCallback);
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _Original_AccessibilityManager(Handler handler, IAccessibilityManager service, int userId) {
        this.mCallback = new MyCallback();
        this.mHandler = handler;
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    public IAccessibilityManagerClient getClient() {
        return this.mClient;
    }

    @VisibleForTesting
    public Handler.Callback getCallback() {
        return this.mCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsEnabled || this.mAccessibilityPolicy != null && this.mAccessibilityPolicy.isEnabled(this.mIsEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsTouchExplorationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean isHighTextContrastEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsHighTextContrastEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccessibilityEvent(AccessibilityEvent event) {
        int userId;
        AccessibilityEvent dispatchedEvent;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            event.setEventTime(SystemClock.uptimeMillis());
            if (this.mAccessibilityPolicy != null) {
                dispatchedEvent = this.mAccessibilityPolicy.onAccessibilityEvent(event, this.mIsEnabled, this.mRelevantEventTypes);
                if (dispatchedEvent == null) {
                    return;
                }
            } else {
                dispatchedEvent = event;
            }
            if (!this.isEnabled()) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "AccessibilityEvent sent with accessibility disabled");
                return;
            }
            if ((dispatchedEvent.getEventType() & this.mRelevantEventTypes) == 0) {
                return;
            }
            userId = this.mUserId;
        }
        try {
            long identityToken = Binder.clearCallingIdentity();
            try {
                service.sendAccessibilityEvent(dispatchedEvent, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error during sending " + dispatchedEvent + " ", re);
        }
        finally {
            if (event != dispatchedEvent) {
                event.recycle();
            }
            dispatchedEvent.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.isEnabled()) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "Interrupt called with accessibility disabled");
                return;
            }
            userId = this.mUserId;
        }
        try {
            service.interrupt(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getInstalledAccessibilityServiceList(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (this.mAccessibilityPolicy != null) {
            services = this.mAccessibilityPolicy.getInstalledAccessibilityServiceList(services);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (this.mAccessibilityPolicy != null) {
            services = this.mAccessibilityPolicy.getEnabledAccessibilityServiceList(feedbackTypeFlags, services);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        this.addAccessibilityStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityStateChangeListeners.put((AccessibilityManager.AccessibilityStateChangeListener)((Object)listener), handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mAccessibilityStateChangeListeners.indexOfKey(listener);
            this.mAccessibilityStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        this.addTouchExplorationStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTouchExplorationStateChangeListeners.put((AccessibilityManager.TouchExplorationStateChangeListener)((Object)listener), handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mTouchExplorationStateChangeListeners.indexOfKey(listener);
            this.mTouchExplorationStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mServicesStateChangeListeners.put((AccessibilityManager.AccessibilityServicesStateChangeListener)listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mServicesStateChangeListeners.remove(listener);
        }
    }

    public void addAccessibilityRequestPreparer(AccessibilityRequestPreparer preparer) {
        int id2;
        List<AccessibilityRequestPreparer> requestPreparerList;
        if (this.mRequestPreparerLists == null) {
            this.mRequestPreparerLists = new SparseArray(1);
        }
        if ((requestPreparerList = this.mRequestPreparerLists.get(id2 = preparer.getAccessibilityViewId())) == null) {
            requestPreparerList = new ArrayList<AccessibilityRequestPreparer>(1);
            this.mRequestPreparerLists.put(id2, requestPreparerList);
        }
        requestPreparerList.add(preparer);
    }

    public void removeAccessibilityRequestPreparer(AccessibilityRequestPreparer preparer) {
        if (this.mRequestPreparerLists == null) {
            return;
        }
        int viewId = preparer.getAccessibilityViewId();
        List<AccessibilityRequestPreparer> requestPreparerList = this.mRequestPreparerLists.get(viewId);
        if (requestPreparerList != null) {
            requestPreparerList.remove(preparer);
            if (requestPreparerList.isEmpty()) {
                this.mRequestPreparerLists.remove(viewId);
            }
        }
    }

    public int getRecommendedTimeoutMillis(int originalTimeout, int uiContentFlags) {
        boolean hasControls = (uiContentFlags & 4) != 0;
        boolean hasIconsOrText = (uiContentFlags & 1) != 0 || (uiContentFlags & 2) != 0;
        int recommendedTimeout = originalTimeout;
        if (hasControls) {
            recommendedTimeout = Math.max(recommendedTimeout, this.mInteractiveUiTimeout);
        }
        if (hasIconsOrText) {
            recommendedTimeout = Math.max(recommendedTimeout, this.mNonInteractiveUiTimeout);
        }
        return recommendedTimeout;
    }

    public List<AccessibilityRequestPreparer> getRequestPreparersForAccessibilityId(int id2) {
        if (this.mRequestPreparerLists == null) {
            return null;
        }
        return this.mRequestPreparerLists.get(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighTextContrastStateChangeListener(HighTextContrastChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighTextContrastStateChangeListeners.put((AccessibilityManager.HighTextContrastChangeListener)((Object)listener), handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighTextContrastStateChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessibilityPolicy(AccessibilityPolicy policy) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityPolicy = policy;
        }
    }

    public boolean isAccessibilityVolumeStreamActive() {
        List<AccessibilityServiceInfo> serviceInfos = this.getEnabledAccessibilityServiceList(-1);
        for (int i = 0; i < serviceInfos.size(); ++i) {
            if ((serviceInfos.get((int)i).flags & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFingerprintGesture(int keyCode) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.sendFingerprintGesture(keyCode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getAccessibilityWindowId(IBinder windowToken) {
        IAccessibilityManager service;
        if (windowToken == null) {
            return -1;
        }
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
        }
        try {
            return service.getAccessibilityWindowId(windowToken);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    @UnsupportedAppUsage
    private void setStateLocked(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        boolean highTextContrastEnabled = (stateFlags & 4) != 0;
        boolean wasEnabled = this.isEnabled();
        boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        boolean wasHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        this.mIsEnabled = enabled;
        this.mIsTouchExplorationEnabled = touchExplorationEnabled;
        this.mIsHighTextContrastEnabled = highTextContrastEnabled;
        if (wasEnabled != this.isEnabled()) {
            this.notifyAccessibilityStateChanged();
        }
        if (wasTouchExplorationEnabled != touchExplorationEnabled) {
            this.notifyTouchExplorationStateChanged();
        }
        if (wasHighTextContrastEnabled != highTextContrastEnabled) {
            this.notifyHighTextContrastStateChanged();
        }
    }

    public AccessibilityServiceInfo getInstalledServiceInfoWithComponentName(ComponentName componentName) {
        List<AccessibilityServiceInfo> installedServiceInfos = this.getInstalledAccessibilityServiceList();
        if (installedServiceInfos == null || componentName == null) {
            return null;
        }
        for (int i = 0; i < installedServiceInfos.size(); ++i) {
            if (!componentName.equals(installedServiceInfos.get(i).getComponentName())) continue;
            return installedServiceInfos.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAccessibilityInteractionConnection(IWindow windowToken, String packageName, IAccessibilityInteractionConnection connection) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
            userId = this.mUserId;
        }
        try {
            return service.addAccessibilityInteractionConnection(windowToken, connection, packageName, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibilityInteractionConnection(IWindow windowToken) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while removing an accessibility interaction connection. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void performAccessibilityShortcut() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.performAccessibilityShortcut();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error performing accessibility shortcut. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonClicked(int displayId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonClicked(displayId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button click", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonVisibilityChanged(boolean shown) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonVisibilityChanged(shown);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button visibility change", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setPictureInPictureActionReplacingConnection(connection);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error setting picture in picture action replacement", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessibilityShortcutService() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
        }
        if (service != null) {
            try {
                return service.getAccessibilityShortcutService();
            }
            catch (RemoteException re) {
                re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private IAccessibilityManager getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked(null);
        }
        return this.mService;
    }

    private void tryConnectToServiceLocked(IAccessibilityManager service) {
        if (service == null) {
            IBinder iBinder = ServiceManager.getService("accessibility");
            if (iBinder == null) {
                return;
            }
            service = IAccessibilityManager.Stub.asInterface(iBinder);
        }
        try {
            long userStateAndRelevantEvents = service.addClient(this.mClient, this.mUserId);
            this.setStateLocked(IntPair.first(userStateAndRelevantEvents));
            this.mRelevantEventTypes = IntPair.second(userStateAndRelevantEvents);
            this.updateUiTimeout(service.getRecommendedTimeoutMillis());
            this.mService = service;
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAccessibilityStateChanged() {
        ArrayMap<AccessibilityManager.AccessibilityStateChangeListener, Handler> listeners;
        boolean isEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAccessibilityStateChangeListeners.isEmpty()) {
                return;
            }
            isEnabled = this.isEnabled();
            listeners = new ArrayMap<AccessibilityManager.AccessibilityStateChangeListener, Handler>(this.mAccessibilityStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            AccessibilityStateChangeListener listener = (AccessibilityStateChangeListener)((Object)listeners.keyAt(i));
            listeners.valueAt(i).post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$notifyAccessibilityStateChanged$0(android.view.accessibility.AccessibilityManager$AccessibilityStateChangeListener boolean ), ()V)((AccessibilityManager.AccessibilityStateChangeListener)((Object)listener), (boolean)isEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTouchExplorationStateChanged() {
        ArrayMap<AccessibilityManager.TouchExplorationStateChangeListener, Handler> listeners;
        boolean isTouchExplorationEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTouchExplorationStateChangeListeners.isEmpty()) {
                return;
            }
            isTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
            listeners = new ArrayMap<AccessibilityManager.TouchExplorationStateChangeListener, Handler>(this.mTouchExplorationStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            TouchExplorationStateChangeListener listener = (TouchExplorationStateChangeListener)((Object)listeners.keyAt(i));
            listeners.valueAt(i).post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$notifyTouchExplorationStateChanged$1(android.view.accessibility.AccessibilityManager$TouchExplorationStateChangeListener boolean ), ()V)((AccessibilityManager.TouchExplorationStateChangeListener)((Object)listener), (boolean)isTouchExplorationEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHighTextContrastStateChanged() {
        ArrayMap<AccessibilityManager.HighTextContrastChangeListener, Handler> listeners;
        boolean isHighTextContrastEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHighTextContrastStateChangeListeners.isEmpty()) {
                return;
            }
            isHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
            listeners = new ArrayMap<AccessibilityManager.HighTextContrastChangeListener, Handler>(this.mHighTextContrastStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            HighTextContrastChangeListener listener = (HighTextContrastChangeListener)((Object)listeners.keyAt(i));
            listeners.valueAt(i).post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$notifyHighTextContrastStateChanged$2(android.view.accessibility.AccessibilityManager$HighTextContrastChangeListener boolean ), ()V)((AccessibilityManager.HighTextContrastChangeListener)((Object)listener), (boolean)isHighTextContrastEnabled));
        }
    }

    private void updateUiTimeout(long uiTimeout) {
        this.mInteractiveUiTimeout = IntPair.first(uiTimeout);
        this.mNonInteractiveUiTimeout = IntPair.second(uiTimeout);
    }

    public static boolean isAccessibilityButtonSupported() {
        Resources res = Resources.getSystem();
        return res.getBoolean(17891513);
    }

    private static /* synthetic */ void lambda$notifyHighTextContrastStateChanged$2(HighTextContrastChangeListener listener, boolean isHighTextContrastEnabled) {
        listener.onHighTextContrastStateChanged(isHighTextContrastEnabled);
    }

    private static /* synthetic */ void lambda$notifyTouchExplorationStateChanged$1(TouchExplorationStateChangeListener listener, boolean isTouchExplorationEnabled) {
        listener.onTouchExplorationStateChanged(isTouchExplorationEnabled);
    }

    private static /* synthetic */ void lambda$notifyAccessibilityStateChanged$0(AccessibilityStateChangeListener listener, boolean isEnabled) {
        listener.onAccessibilityStateChanged(isEnabled);
    }

    private class MyCallback
    implements Handler.Callback {
        public static final int MSG_SET_STATE = 1;

        private MyCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int state = message.arg1;
                    Object object = _Original_AccessibilityManager.this.mLock;
                    synchronized (object) {
                        _Original_AccessibilityManager.this.setStateLocked(state);
                        break;
                    }
                }
            }
            return true;
        }
    }

    public static interface AccessibilityPolicy {
        public boolean isEnabled(boolean var1);

        public AccessibilityEvent onAccessibilityEvent(AccessibilityEvent var1, boolean var2, int var3);

        public int getRelevantEventTypes(int var1);

        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> var1);

        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int var1, List<AccessibilityServiceInfo> var2);
    }

    public static interface HighTextContrastChangeListener {
        public void onHighTextContrastStateChanged(boolean var1);
    }

    public static interface AccessibilityServicesStateChangeListener {
        public void onAccessibilityServicesStateChanged(_Original_AccessibilityManager var1);
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentFlag {
    }
}

