/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Insets;
import android.graphics.Rect;
import android.view.DisplayCutout;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class WindowInsets {
    private final Insets[] mTypeInsetsMap;
    private final Insets[] mTypeMaxInsetsMap;
    private final boolean[] mTypeVisibilityMap;
    private Rect mTempRect;
    private final boolean mIsRound;
    private final DisplayCutout mDisplayCutout;
    private final boolean mAlwaysConsumeSystemBars;
    private final boolean mSystemWindowInsetsConsumed;
    private final boolean mStableInsetsConsumed;
    private final boolean mDisplayCutoutConsumed;
    @UnsupportedAppUsage
    public static final WindowInsets CONSUMED = new WindowInsets(null, null, false, false, null);

    public WindowInsets(Rect systemWindowInsetsRect, Rect stableInsetsRect, boolean isRound, boolean alwaysConsumeSystemBars, DisplayCutout displayCutout) {
        this(WindowInsets.createCompatTypeMap(systemWindowInsetsRect), WindowInsets.createCompatTypeMap(stableInsetsRect), WindowInsets.createCompatVisibilityMap(WindowInsets.createCompatTypeMap(systemWindowInsetsRect)), isRound, alwaysConsumeSystemBars, displayCutout);
    }

    public WindowInsets(Insets[] typeInsetsMap, Insets[] typeMaxInsetsMap, boolean[] typeVisibilityMap, boolean isRound, boolean alwaysConsumeSystemBars, DisplayCutout displayCutout) {
        this.mSystemWindowInsetsConsumed = typeInsetsMap == null;
        this.mTypeInsetsMap = this.mSystemWindowInsetsConsumed ? new Insets[7] : (Insets[])typeInsetsMap.clone();
        this.mStableInsetsConsumed = typeMaxInsetsMap == null;
        this.mTypeMaxInsetsMap = this.mStableInsetsConsumed ? new Insets[7] : (Insets[])typeMaxInsetsMap.clone();
        this.mTypeVisibilityMap = typeVisibilityMap;
        this.mIsRound = isRound;
        this.mAlwaysConsumeSystemBars = alwaysConsumeSystemBars;
        this.mDisplayCutoutConsumed = displayCutout == null;
        this.mDisplayCutout = this.mDisplayCutoutConsumed || displayCutout.isEmpty() ? null : displayCutout;
    }

    public WindowInsets(WindowInsets src) {
        this(src.mSystemWindowInsetsConsumed ? null : src.mTypeInsetsMap, src.mStableInsetsConsumed ? null : src.mTypeMaxInsetsMap, src.mTypeVisibilityMap, src.mIsRound, src.mAlwaysConsumeSystemBars, WindowInsets.displayCutoutCopyConstructorArgument(src));
    }

    private static DisplayCutout displayCutoutCopyConstructorArgument(WindowInsets w) {
        if (w.mDisplayCutoutConsumed) {
            return null;
        }
        if (w.mDisplayCutout == null) {
            return DisplayCutout.NO_CUTOUT;
        }
        return w.mDisplayCutout;
    }

    private static Insets getInsets(Insets[] typeInsetsMap, int typeMask) {
        Insets result = null;
        for (int i = 1; i <= 64; i <<= 1) {
            Insets insets;
            if ((typeMask & i) == 0 || (insets = typeInsetsMap[Type.indexOf(i)]) == null) continue;
            result = result == null ? insets : Insets.max(result, insets);
        }
        return result == null ? Insets.NONE : result;
    }

    private static void setInsets(Insets[] typeInsetsMap, int typeMask, Insets insets) {
        for (int i = 1; i <= 64; i <<= 1) {
            if ((typeMask & i) == 0) continue;
            typeInsetsMap[Type.indexOf((int)i)] = insets;
        }
    }

    @UnsupportedAppUsage
    public WindowInsets(Rect systemWindowInsets) {
        this(WindowInsets.createCompatTypeMap(systemWindowInsets), null, new boolean[7], false, false, null);
    }

    private static Insets[] createCompatTypeMap(Rect insets) {
        if (insets == null) {
            return null;
        }
        Insets[] typeInsetMap = new Insets[7];
        WindowInsets.assignCompatInsets(typeInsetMap, insets);
        return typeInsetMap;
    }

    static void assignCompatInsets(Insets[] typeInsetMap, Rect insets) {
        typeInsetMap[Type.indexOf((int)1)] = Insets.of(0, insets.top, 0, 0);
        typeInsetMap[Type.indexOf((int)4)] = Insets.of(insets.left, 0, insets.right, insets.bottom);
    }

    private static boolean[] createCompatVisibilityMap(Insets[] typeInsetMap) {
        boolean[] typeVisibilityMap = new boolean[7];
        if (typeInsetMap == null) {
            return typeVisibilityMap;
        }
        for (int i = 1; i <= 64; i <<= 1) {
            int index = Type.indexOf(i);
            if (Insets.NONE.equals(typeInsetMap[index])) continue;
            typeVisibilityMap[index] = true;
        }
        return typeVisibilityMap;
    }

    @Deprecated
    public Rect getSystemWindowInsetsAsRect() {
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        Insets insets = this.getSystemWindowInsets();
        this.mTempRect.set(insets.left, insets.top, insets.right, insets.bottom);
        return this.mTempRect;
    }

    public Insets getSystemWindowInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, Type.compatSystemInsets());
    }

    public Insets getInsets(int typeMask) {
        return WindowInsets.getInsets(this.mTypeInsetsMap, typeMask);
    }

    public Insets getMaxInsets(int typeMask) throws IllegalArgumentException {
        if ((typeMask & 2) != 0) {
            throw new IllegalArgumentException("Unable to query the maximum insets for IME");
        }
        return WindowInsets.getInsets(this.mTypeMaxInsetsMap, typeMask);
    }

    public boolean isVisible(int typeMask) {
        for (int i = 1; i <= 64; i <<= 1) {
            if ((typeMask & i) == 0 || this.mTypeVisibilityMap[Type.indexOf(i)]) continue;
            return false;
        }
        return true;
    }

    public int getSystemWindowInsetLeft() {
        return this.getSystemWindowInsets().left;
    }

    public int getSystemWindowInsetTop() {
        return this.getSystemWindowInsets().top;
    }

    public int getSystemWindowInsetRight() {
        return this.getSystemWindowInsets().right;
    }

    public int getSystemWindowInsetBottom() {
        return this.getSystemWindowInsets().bottom;
    }

    public boolean hasSystemWindowInsets() {
        return !this.getSystemWindowInsets().equals(Insets.NONE);
    }

    public boolean hasInsets() {
        return !WindowInsets.getInsets(this.mTypeInsetsMap, Type.all()).equals(Insets.NONE) || !WindowInsets.getInsets(this.mTypeMaxInsetsMap, Type.all()).equals(Insets.NONE) || this.mDisplayCutout != null;
    }

    public DisplayCutout getDisplayCutout() {
        return this.mDisplayCutout;
    }

    public WindowInsets consumeDisplayCutout() {
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : this.mTypeInsetsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, null);
    }

    public boolean isConsumed() {
        return this.mSystemWindowInsetsConsumed && this.mStableInsetsConsumed && this.mDisplayCutoutConsumed;
    }

    public boolean isRound() {
        return this.mIsRound;
    }

    public WindowInsets consumeSystemWindowInsets() {
        return new WindowInsets(null, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, WindowInsets.displayCutoutCopyConstructorArgument(this));
    }

    @Deprecated
    public WindowInsets replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        if (this.mSystemWindowInsetsConsumed) {
            return this;
        }
        return new Builder(this).setSystemWindowInsets(Insets.of(left, top, right, bottom)).build();
    }

    @Deprecated
    public WindowInsets replaceSystemWindowInsets(Rect systemWindowInsets) {
        return this.replaceSystemWindowInsets(systemWindowInsets.left, systemWindowInsets.top, systemWindowInsets.right, systemWindowInsets.bottom);
    }

    public Insets getStableInsets() {
        return WindowInsets.getInsets(this.mTypeMaxInsetsMap, Type.compatSystemInsets());
    }

    public int getStableInsetTop() {
        return this.getStableInsets().top;
    }

    public int getStableInsetLeft() {
        return this.getStableInsets().left;
    }

    public int getStableInsetRight() {
        return this.getStableInsets().right;
    }

    public int getStableInsetBottom() {
        return this.getStableInsets().bottom;
    }

    public boolean hasStableInsets() {
        return !this.getStableInsets().equals(Insets.NONE);
    }

    public Insets getSystemGestureInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 8);
    }

    public Insets getMandatorySystemGestureInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 16);
    }

    public Insets getTappableElementInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 32);
    }

    public WindowInsets consumeStableInsets() {
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : this.mTypeInsetsMap, null, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, WindowInsets.displayCutoutCopyConstructorArgument(this));
    }

    public boolean shouldAlwaysConsumeSystemBars() {
        return this.mAlwaysConsumeSystemBars;
    }

    public String toString() {
        return "WindowInsets{systemWindowInsets=" + this.getSystemWindowInsets() + " stableInsets=" + this.getStableInsets() + " sysGestureInsets=" + this.getSystemGestureInsets() + (this.mDisplayCutout != null ? " cutout=" + this.mDisplayCutout : "") + (this.isRound() ? " round" : "") + "}";
    }

    @Deprecated
    public WindowInsets inset(Rect r) {
        return this.inset(r.left, r.top, r.right, r.bottom);
    }

    public WindowInsets inset(Insets insets) {
        return this.inset(insets.left, insets.top, insets.right, insets.bottom);
    }

    public WindowInsets inset(int left, int top, int right, int bottom) {
        Preconditions.checkArgumentNonnegative(left);
        Preconditions.checkArgumentNonnegative(top);
        Preconditions.checkArgumentNonnegative(right);
        Preconditions.checkArgumentNonnegative(bottom);
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : WindowInsets.insetInsets(this.mTypeInsetsMap, left, top, right, bottom), this.mStableInsetsConsumed ? null : WindowInsets.insetInsets(this.mTypeMaxInsetsMap, left, top, right, bottom), this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, this.mDisplayCutoutConsumed ? null : (this.mDisplayCutout == null ? DisplayCutout.NO_CUTOUT : this.mDisplayCutout.inset(left, top, right, bottom)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof WindowInsets)) {
            return false;
        }
        WindowInsets that = (WindowInsets)o;
        return this.mIsRound == that.mIsRound && this.mAlwaysConsumeSystemBars == that.mAlwaysConsumeSystemBars && this.mSystemWindowInsetsConsumed == that.mSystemWindowInsetsConsumed && this.mStableInsetsConsumed == that.mStableInsetsConsumed && this.mDisplayCutoutConsumed == that.mDisplayCutoutConsumed && Arrays.equals(this.mTypeInsetsMap, that.mTypeInsetsMap) && Arrays.equals(this.mTypeMaxInsetsMap, that.mTypeMaxInsetsMap) && Arrays.equals(this.mTypeVisibilityMap, that.mTypeVisibilityMap) && Objects.equals(this.mDisplayCutout, that.mDisplayCutout);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mTypeInsetsMap), Arrays.hashCode(this.mTypeMaxInsetsMap), Arrays.hashCode(this.mTypeVisibilityMap), this.mIsRound, this.mDisplayCutout, this.mAlwaysConsumeSystemBars, this.mSystemWindowInsetsConsumed, this.mStableInsetsConsumed, this.mDisplayCutoutConsumed);
    }

    private static Insets[] insetInsets(Insets[] typeInsetsMap, int left, int top, int right, int bottom) {
        boolean cloned = false;
        for (int i = 0; i < 7; ++i) {
            Insets insetInsets;
            Insets insets = typeInsetsMap[i];
            if (insets == null || (insetInsets = WindowInsets.insetInsets(insets, left, top, right, bottom)) == insets) continue;
            if (!cloned) {
                typeInsetsMap = (Insets[])typeInsetsMap.clone();
                cloned = true;
            }
            typeInsetsMap[i] = insetInsets;
        }
        return typeInsetsMap;
    }

    private static Insets insetInsets(Insets insets, int left, int top, int right, int bottom) {
        int newLeft = Math.max(0, insets.left - left);
        int newTop = Math.max(0, insets.top - top);
        int newRight = Math.max(0, insets.right - right);
        int newBottom = Math.max(0, insets.bottom - bottom);
        if (newLeft == left && newTop == top && newRight == right && newBottom == bottom) {
            return insets;
        }
        return Insets.of(newLeft, newTop, newRight, newBottom);
    }

    boolean isSystemWindowInsetsConsumed() {
        return this.mSystemWindowInsetsConsumed;
    }

    public static class Type {
        static final int FIRST = 1;
        static final int TOP_BAR = 1;
        static final int IME = 2;
        static final int SIDE_BARS = 4;
        static final int SYSTEM_GESTURES = 8;
        static final int MANDATORY_SYSTEM_GESTURES = 16;
        static final int TAPPABLE_ELEMENT = 32;
        static final int LAST = 64;
        static final int SIZE = 7;
        static final int WINDOW_DECOR = 64;

        static int indexOf(int type) {
            switch (type) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 8: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 32: {
                    return 5;
                }
                case 64: {
                    return 6;
                }
            }
            throw new IllegalArgumentException("type needs to be >= FIRST and <= LAST, type=" + type);
        }

        private Type() {
        }

        public static int topBar() {
            return 1;
        }

        public static int ime() {
            return 2;
        }

        public static int sideBars() {
            return 4;
        }

        public static int windowDecor() {
            return 64;
        }

        public static int systemGestures() {
            return 8;
        }

        public static int mandatorySystemGestures() {
            return 16;
        }

        public static int tappableElement() {
            return 32;
        }

        public static int systemBars() {
            return 5;
        }

        static int compatSystemInsets() {
            return 7;
        }

        public static int all() {
            return -1;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InsetType {
        }
    }

    public static class Builder {
        private final Insets[] mTypeInsetsMap;
        private final Insets[] mTypeMaxInsetsMap;
        private final boolean[] mTypeVisibilityMap;
        private boolean mSystemInsetsConsumed = true;
        private boolean mStableInsetsConsumed = true;
        private DisplayCutout mDisplayCutout;
        private boolean mIsRound;
        private boolean mAlwaysConsumeSystemBars;

        public Builder() {
            this.mTypeInsetsMap = new Insets[7];
            this.mTypeMaxInsetsMap = new Insets[7];
            this.mTypeVisibilityMap = new boolean[7];
        }

        public Builder(WindowInsets insets) {
            this.mTypeInsetsMap = (Insets[])insets.mTypeInsetsMap.clone();
            this.mTypeMaxInsetsMap = (Insets[])insets.mTypeMaxInsetsMap.clone();
            this.mTypeVisibilityMap = (boolean[])insets.mTypeVisibilityMap.clone();
            this.mSystemInsetsConsumed = insets.mSystemWindowInsetsConsumed;
            this.mStableInsetsConsumed = insets.mStableInsetsConsumed;
            this.mDisplayCutout = WindowInsets.displayCutoutCopyConstructorArgument(insets);
            this.mIsRound = insets.mIsRound;
            this.mAlwaysConsumeSystemBars = insets.mAlwaysConsumeSystemBars;
        }

        public Builder setSystemWindowInsets(Insets systemWindowInsets) {
            Preconditions.checkNotNull(systemWindowInsets);
            WindowInsets.assignCompatInsets(this.mTypeInsetsMap, systemWindowInsets.toRect());
            this.mSystemInsetsConsumed = false;
            return this;
        }

        public Builder setSystemGestureInsets(Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 8, insets);
            return this;
        }

        public Builder setMandatorySystemGestureInsets(Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 16, insets);
            return this;
        }

        public Builder setTappableElementInsets(Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 32, insets);
            return this;
        }

        public Builder setInsets(int typeMask, Insets insets) {
            Preconditions.checkNotNull(insets);
            WindowInsets.setInsets(this.mTypeInsetsMap, typeMask, insets);
            this.mSystemInsetsConsumed = false;
            return this;
        }

        public Builder setMaxInsets(int typeMask, Insets insets) throws IllegalArgumentException {
            if (typeMask == 2) {
                throw new IllegalArgumentException("Maximum inset not available for IME");
            }
            Preconditions.checkNotNull(insets);
            WindowInsets.setInsets(this.mTypeMaxInsetsMap, typeMask, insets);
            this.mStableInsetsConsumed = false;
            return this;
        }

        public Builder setVisible(int typeMask, boolean visible) {
            for (int i = 1; i <= 64; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.mTypeVisibilityMap[Type.indexOf((int)i)] = visible;
            }
            return this;
        }

        public Builder setStableInsets(Insets stableInsets) {
            Preconditions.checkNotNull(stableInsets);
            WindowInsets.assignCompatInsets(this.mTypeMaxInsetsMap, stableInsets.toRect());
            this.mStableInsetsConsumed = false;
            return this;
        }

        public Builder setDisplayCutout(DisplayCutout displayCutout) {
            this.mDisplayCutout = displayCutout != null ? displayCutout : DisplayCutout.NO_CUTOUT;
            return this;
        }

        public Builder setRound(boolean round) {
            this.mIsRound = round;
            return this;
        }

        public Builder setAlwaysConsumeSystemBars(boolean alwaysConsumeSystemBars) {
            this.mAlwaysConsumeSystemBars = alwaysConsumeSystemBars;
            return this;
        }

        public WindowInsets build() {
            return new WindowInsets(this.mSystemInsetsConsumed ? null : this.mTypeInsetsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, this.mDisplayCutout);
        }
    }
}

