/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ViewHierarchyEncoder {
    private static final byte SIG_BOOLEAN = 90;
    private static final byte SIG_BYTE = 66;
    private static final byte SIG_SHORT = 83;
    private static final byte SIG_INT = 73;
    private static final byte SIG_LONG = 74;
    private static final byte SIG_FLOAT = 70;
    private static final byte SIG_DOUBLE = 68;
    private static final byte SIG_STRING = 82;
    private static final byte SIG_MAP = 77;
    private static final short SIG_END_MAP = 0;
    private final DataOutputStream mStream;
    private final Map<String, Short> mPropertyNames = new HashMap<String, Short>(200);
    private short mPropertyId = 1;
    private Charset mCharset = Charset.forName("utf-8");

    public ViewHierarchyEncoder(ByteArrayOutputStream stream) {
        this.mStream = new DataOutputStream(stream);
    }

    public void beginObject(Object o) {
        this.startPropertyMap();
        this.addProperty("meta:__name__", o.getClass().getName());
        this.addProperty("meta:__hash__", o.hashCode());
    }

    public void endObject() {
        this.endPropertyMap();
    }

    public void endStream() {
        this.startPropertyMap();
        this.addProperty("__name__", "propertyIndex");
        for (Map.Entry<String, Short> entry : this.mPropertyNames.entrySet()) {
            this.writeShort(entry.getValue());
            this.writeString(entry.getKey());
        }
        this.endPropertyMap();
    }

    @UnsupportedAppUsage
    public void addProperty(String name, boolean v) {
        this.writeShort(this.createPropertyIndex(name));
        this.writeBoolean(v);
    }

    public void addProperty(String name, short s) {
        this.writeShort(this.createPropertyIndex(name));
        this.writeShort(s);
    }

    @UnsupportedAppUsage
    public void addProperty(String name, int v) {
        this.writeShort(this.createPropertyIndex(name));
        this.writeInt(v);
    }

    @UnsupportedAppUsage
    public void addProperty(String name, float v) {
        this.writeShort(this.createPropertyIndex(name));
        this.writeFloat(v);
    }

    @UnsupportedAppUsage
    public void addProperty(String name, String s) {
        this.writeShort(this.createPropertyIndex(name));
        this.writeString(s);
    }

    public void addPropertyKey(String name) {
        this.writeShort(this.createPropertyIndex(name));
    }

    private short createPropertyIndex(String name) {
        Short index = this.mPropertyNames.get(name);
        if (index == null) {
            short s = this.mPropertyId;
            this.mPropertyId = (short)(s + 1);
            index = s;
            this.mPropertyNames.put(name, index);
        }
        return index;
    }

    private void startPropertyMap() {
        try {
            this.mStream.write(77);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void endPropertyMap() {
        this.writeShort((short)0);
    }

    private void writeBoolean(boolean v) {
        try {
            this.mStream.write(90);
            this.mStream.write(v ? 1 : 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeShort(short s) {
        try {
            this.mStream.write(83);
            this.mStream.writeShort(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeInt(int i) {
        try {
            this.mStream.write(73);
            this.mStream.writeInt(i);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeFloat(float v) {
        try {
            this.mStream.write(70);
            this.mStream.writeFloat(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeString(String s) {
        if (s == null) {
            s = "";
        }
        try {
            this.mStream.write(82);
            byte[] bytes = s.getBytes(this.mCharset);
            short len = (short)Math.min(bytes.length, Short.MAX_VALUE);
            this.mStream.writeShort(len);
            this.mStream.write(bytes, 0, len);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

