/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.view.RectShadowPainter;
import android.view.ShadowPainter;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Transformation;
import android.view.shadow.HighQualityShadowPainter;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ViewGroup_Delegate {
    @LayoutlibDelegate
    static boolean drawChild(ViewGroup thisVG, Canvas canvas, View child, long drawingTime) {
        if (child.getZ() > thisVG.getZ()) {
            child.setBackgroundBounds();
            ViewOutlineProvider outlineProvider = child.getOutlineProvider();
            if (outlineProvider != null) {
                Outline outline = child.mAttachInfo.mTmpOutline;
                outlineProvider.getOutline(child, outline);
                if (outline.mPath != null || outline.mRect != null && !outline.mRect.isEmpty()) {
                    int restoreTo = ViewGroup_Delegate.transformCanvas(thisVG, canvas, child);
                    ViewGroup_Delegate.drawShadow(thisVG, canvas, child, outline);
                    canvas.restoreToCount(restoreTo);
                }
            }
        }
        return thisVG.drawChild_Original(canvas, child, drawingTime);
    }

    private static void drawShadow(ViewGroup parent, Canvas canvas, View child, Outline outline) {
        boolean highQualityShadow = false;
        boolean enableShadow = true;
        float elevation = ViewGroup_Delegate.getElevation(child, parent);
        Context bridgeContext = parent.getContext();
        if (bridgeContext instanceof BridgeContext) {
            highQualityShadow = ((BridgeContext)bridgeContext).isHighQualityShadows();
            enableShadow = ((BridgeContext)bridgeContext).isShadowsEnabled();
        }
        if (!enableShadow) {
            return;
        }
        if (outline.mMode == 1 && outline.mRect != null) {
            if (highQualityShadow) {
                float densityDpi = bridgeContext.getResources().getDisplayMetrics().densityDpi;
                HighQualityShadowPainter.paintRectShadow(parent, outline, elevation, canvas, child.getAlpha(), densityDpi);
            } else {
                RectShadowPainter.paintShadow(outline, elevation, canvas, child.getAlpha());
            }
            return;
        }
        BufferedImage shadow = null;
        if (outline.mPath != null) {
            shadow = ViewGroup_Delegate.getPathShadow(outline, canvas, elevation, child.getAlpha());
        }
        if (shadow == null) {
            return;
        }
        Bitmap bitmap = Bitmap_Delegate.createBitmap(shadow, false, Density.getEnum((int)canvas.getDensity()));
        canvas.save();
        Rect clipBounds = canvas.getClipBounds();
        Rect newBounds = new Rect(clipBounds);
        newBounds.inset((int)(-elevation), (int)(-elevation));
        canvas.clipRectUnion(newBounds);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.restore();
    }

    private static float getElevation(View child, ViewGroup parent) {
        return child.getZ() - parent.getZ();
    }

    private static BufferedImage getPathShadow(Outline outline, Canvas canvas, float elevation, float alpha) {
        Rect clipBounds = canvas.getClipBounds();
        if (clipBounds.isEmpty()) {
            return null;
        }
        BufferedImage image = new BufferedImage(clipBounds.width(), clipBounds.height(), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.draw(Path_Delegate.getDelegate(outline.mPath.mNativePath).getJavaShape());
        graphics.dispose();
        return ShadowPainter.createDropShadow(image, (int)elevation, alpha);
    }

    private static int transformCanvas(ViewGroup thisVG, Canvas canvas, View child) {
        Transformation t;
        boolean hasTransform;
        int restoreTo = canvas.save();
        boolean childHasIdentityMatrix = child.hasIdentityMatrix();
        int flags = thisVG.mGroupFlags;
        Transformation transformToApply = null;
        boolean concatMatrix = false;
        if ((flags & 0x800) != 0 && (hasTransform = thisVG.getChildStaticTransformation(child, t = thisVG.getChildTransformation()))) {
            int transformType = t.getTransformationType();
            transformToApply = transformType != 0 ? t : null;
            concatMatrix = (transformType & 2) != 0;
        }
        concatMatrix |= childHasIdentityMatrix;
        canvas.translate(child.mLeft, child.mTop);
        float alpha = child.getAlpha() * child.getTransitionAlpha();
        if (!(transformToApply == null && !(alpha < 1.0f) && childHasIdentityMatrix || transformToApply == null && childHasIdentityMatrix)) {
            if (transformToApply != null && concatMatrix) {
                canvas.concat(transformToApply.getMatrix());
            }
            if (!childHasIdentityMatrix) {
                canvas.concat(child.getMatrix());
            }
        }
        return restoreTo;
    }
}

