/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.InsetsController;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.function.Supplier;

public class InsetsSourceConsumer {
    protected final InsetsController mController;
    protected boolean mVisible;
    private final Supplier<SurfaceControl.Transaction> mTransactionSupplier;
    private final int mType;
    private final InsetsState mState;
    private InsetsSourceControl mSourceControl;

    public InsetsSourceConsumer(int type, InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        this.mType = type;
        this.mState = state;
        this.mTransactionSupplier = transactionSupplier;
        this.mController = controller;
        this.mVisible = InsetsState.getDefaultVisibility(type);
    }

    public void setControl(InsetsSourceControl control) {
        if (this.mSourceControl == control) {
            return;
        }
        this.mSourceControl = control;
        this.applyHiddenToControl();
        if (this.applyLocalVisibilityOverride()) {
            this.mController.notifyVisibilityChanged();
        }
        if (this.mSourceControl == null) {
            this.mController.notifyControlRevoked(this);
        }
    }

    @VisibleForTesting
    public InsetsSourceControl getControl() {
        return this.mSourceControl;
    }

    int getType() {
        return this.mType;
    }

    @VisibleForTesting
    public void show() {
        this.setVisible(true);
    }

    @VisibleForTesting
    public void hide() {
        this.setVisible(false);
    }

    public void onWindowFocusGained() {
    }

    public void onWindowFocusLost() {
    }

    boolean applyLocalVisibilityOverride() {
        if (this.mSourceControl == null) {
            return false;
        }
        if (this.mState.getSource(this.mType).isVisible() == this.mVisible) {
            return false;
        }
        this.mState.getSource(this.mType).setVisible(this.mVisible);
        return true;
    }

    @VisibleForTesting
    public boolean isVisible() {
        return this.mVisible;
    }

    int requestShow(boolean fromController) {
        return 0;
    }

    void notifyHidden() {
    }

    private void setVisible(boolean visible) {
        if (this.mVisible == visible) {
            return;
        }
        this.mVisible = visible;
        this.applyHiddenToControl();
        this.applyLocalVisibilityOverride();
        this.mController.notifyVisibilityChanged();
    }

    private void applyHiddenToControl() {
        if (this.mSourceControl == null) {
            return;
        }
        SurfaceControl.Transaction t = this.mTransactionSupplier.get();
        if (this.mVisible) {
            t.show(this.mSourceControl.getLeash());
        } else {
            t.hide(this.mSourceControl.getLeash());
        }
        t.apply();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ShowResult {
        public static final int SHOW_IMMEDIATELY = 0;
        public static final int SHOW_DELAYED = 1;
        public static final int SHOW_FAILED = 2;
    }
}

