/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseSetArray;
import android.view.InsetsController;
import android.view.InsetsSource;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsAnimationListener;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.Supplier;

@VisibleForTesting
public class InsetsAnimationControlImpl
implements WindowInsetsAnimationController {
    private final Rect mTmpFrame = new Rect();
    private final WindowInsetsAnimationControlListener mListener;
    private final SparseArray<InsetsSourceConsumer> mConsumers;
    private final SparseIntArray mTypeSideMap = new SparseIntArray();
    private final SparseSetArray<InsetsSourceConsumer> mSideSourceMap = new SparseSetArray();
    private final Insets mHiddenInsets;
    private final Insets mShownInsets;
    private final Matrix mTmpMatrix = new Matrix();
    private final InsetsState mInitialInsetsState;
    private final int mTypes;
    private final Supplier<SyncRtSurfaceTransactionApplier> mTransactionApplierSupplier;
    private final InsetsController mController;
    private final WindowInsetsAnimationListener.InsetsAnimation mAnimation;
    private final Rect mFrame;
    private Insets mCurrentInsets;
    private Insets mPendingInsets;
    private boolean mFinished;
    private boolean mCancelled;
    private int mFinishedShownTypes;

    @VisibleForTesting
    public InsetsAnimationControlImpl(SparseArray<InsetsSourceConsumer> consumers, Rect frame, InsetsState state, WindowInsetsAnimationControlListener listener, int types, Supplier<SyncRtSurfaceTransactionApplier> transactionApplierSupplier, InsetsController controller) {
        this.mConsumers = consumers;
        this.mListener = listener;
        this.mTypes = types;
        this.mTransactionApplierSupplier = transactionApplierSupplier;
        this.mController = controller;
        this.mInitialInsetsState = new InsetsState(state, true);
        this.mCurrentInsets = this.getInsetsFromState(this.mInitialInsetsState, frame, null);
        this.mHiddenInsets = this.calculateInsets(this.mInitialInsetsState, frame, consumers, false, null);
        this.mShownInsets = this.calculateInsets(this.mInitialInsetsState, frame, consumers, true, this.mTypeSideMap);
        this.mFrame = new Rect(frame);
        InsetsAnimationControlImpl.buildTypeSourcesMap(this.mTypeSideMap, this.mSideSourceMap, this.mConsumers);
        listener.onReady(this, types);
        this.mAnimation = new WindowInsetsAnimationListener.InsetsAnimation(this.mTypes, this.mHiddenInsets, this.mShownInsets);
        this.mController.dispatchAnimationStarted(this.mAnimation);
    }

    @Override
    public Insets getHiddenStateInsets() {
        return this.mHiddenInsets;
    }

    @Override
    public Insets getShownStateInsets() {
        return this.mShownInsets;
    }

    @Override
    public Insets getCurrentInsets() {
        return this.mCurrentInsets;
    }

    @Override
    public int getTypes() {
        return this.mTypes;
    }

    @Override
    public void changeInsets(Insets insets) {
        if (this.mFinished) {
            throw new IllegalStateException("Can't change insets on an animation that is finished.");
        }
        if (this.mCancelled) {
            throw new IllegalStateException("Can't change insets on an animation that is cancelled.");
        }
        this.mPendingInsets = this.sanitize(insets);
        this.mController.scheduleApplyChangeInsets();
    }

    @VisibleForTesting
    public boolean applyChangeInsets(InsetsState state) {
        if (this.mCancelled) {
            return false;
        }
        Insets offset = Insets.subtract(this.mShownInsets, this.mPendingInsets);
        ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams> params = new ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams>();
        if (offset.left != 0) {
            this.updateLeashesForSide(0, offset.left, this.mPendingInsets.left, params, state);
        }
        if (offset.top != 0) {
            this.updateLeashesForSide(1, offset.top, this.mPendingInsets.top, params, state);
        }
        if (offset.right != 0) {
            this.updateLeashesForSide(2, offset.right, this.mPendingInsets.right, params, state);
        }
        if (offset.bottom != 0) {
            this.updateLeashesForSide(3, offset.bottom, this.mPendingInsets.bottom, params, state);
        }
        SyncRtSurfaceTransactionApplier applier = this.mTransactionApplierSupplier.get();
        applier.scheduleApply(params.toArray(new SyncRtSurfaceTransactionApplier.SurfaceParams[params.size()]));
        this.mCurrentInsets = this.mPendingInsets;
        if (this.mFinished) {
            this.mController.notifyFinished(this, this.mFinishedShownTypes);
        }
        return this.mFinished;
    }

    @Override
    public void finish(int shownTypes) {
        if (this.mCancelled) {
            return;
        }
        InsetsState state = new InsetsState(this.mController.getState());
        for (int i = this.mConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mConsumers.valueAt(i);
            boolean visible = (shownTypes & InsetsState.toPublicType(consumer.getType())) != 0;
            state.getSource(consumer.getType()).setVisible(visible);
        }
        Insets insets = this.getInsetsFromState(state, this.mFrame, null);
        this.changeInsets(insets);
        this.mFinished = true;
        this.mFinishedShownTypes = shownTypes;
    }

    @VisibleForTesting
    public void onCancelled() {
        if (this.mFinished) {
            return;
        }
        this.mCancelled = true;
        this.mListener.onCancelled();
    }

    WindowInsetsAnimationListener.InsetsAnimation getAnimation() {
        return this.mAnimation;
    }

    private Insets calculateInsets(InsetsState state, Rect frame, SparseArray<InsetsSourceConsumer> consumers, boolean shown, SparseIntArray typeSideMap) {
        for (int i = consumers.size() - 1; i >= 0; --i) {
            state.getSource(consumers.valueAt(i).getType()).setVisible(shown);
        }
        return this.getInsetsFromState(state, frame, typeSideMap);
    }

    private Insets getInsetsFromState(InsetsState state, Rect frame, SparseIntArray typeSideMap) {
        return state.calculateInsets(frame, false, false, null, null, null, 16, typeSideMap).getInsets(this.mTypes);
    }

    private Insets sanitize(Insets insets) {
        return Insets.max(Insets.min(insets, this.mShownInsets), this.mHiddenInsets);
    }

    private void updateLeashesForSide(int side, int offset, int inset, ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams> surfaceParams, InsetsState state) {
        ArraySet<InsetsSourceConsumer> items = this.mSideSourceMap.get(side);
        for (int i = items.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = items.valueAt(i);
            InsetsSource source = this.mInitialInsetsState.getSource(consumer.getType());
            InsetsSourceControl control = consumer.getControl();
            SurfaceControl leash = consumer.getControl().getLeash();
            this.mTmpMatrix.setTranslate(control.getSurfacePosition().x, control.getSurfacePosition().y);
            this.mTmpFrame.set(source.getFrame());
            this.addTranslationToMatrix(side, offset, this.mTmpMatrix, this.mTmpFrame);
            state.getSource(source.getType()).setFrame(this.mTmpFrame);
            surfaceParams.add(new SyncRtSurfaceTransactionApplier.SurfaceParams(leash, 1.0f, this.mTmpMatrix, null, 0, 0.0f, inset != 0));
        }
    }

    private void addTranslationToMatrix(int side, int inset, Matrix m, Rect frame) {
        switch (side) {
            case 0: {
                m.postTranslate(-inset, 0.0f);
                frame.offset(-inset, 0);
                break;
            }
            case 1: {
                m.postTranslate(0.0f, -inset);
                frame.offset(0, -inset);
                break;
            }
            case 2: {
                m.postTranslate(inset, 0.0f);
                frame.offset(inset, 0);
                break;
            }
            case 3: {
                m.postTranslate(0.0f, inset);
                frame.offset(0, inset);
            }
        }
    }

    private static void buildTypeSourcesMap(SparseIntArray typeSideMap, SparseSetArray<InsetsSourceConsumer> sideSourcesMap, SparseArray<InsetsSourceConsumer> consumers) {
        for (int i = typeSideMap.size() - 1; i >= 0; --i) {
            int type = typeSideMap.keyAt(i);
            int side = typeSideMap.valueAt(i);
            sideSourcesMap.add(side, consumers.get(type));
        }
    }
}

