/*
 * Decompiled with CFR 0.152.
 */
package android.util.imagepool;

import android.util.imagepool.Bucket;
import android.util.imagepool.ImageImpl;
import android.util.imagepool.ImagePool;
import android.util.imagepool.ImagePoolHelper;
import android.util.imagepool.ImagePoolStats;
import android.util.imagepool.ImagePoolStatsProdImpl;
import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

class ImagePoolImpl
implements ImagePool {
    private final ReentrantReadWriteLock mReentrantLock = new ReentrantReadWriteLock();
    private final ImagePool.ImagePoolPolicy mPolicy;
    final Map<String, Bucket> mPool = new HashMap<String, Bucket>();
    final ImagePoolStats mImagePoolStats = new ImagePoolStatsProdImpl();
    private final FinalizableReferenceQueue mFinalizableReferenceQueue = new FinalizableReferenceQueue();
    private final Set<Reference<?>> mReferences = new HashSet();

    public ImagePoolImpl(ImagePool.ImagePoolPolicy policy) {
        this.mPolicy = policy;
        this.mImagePoolStats.start();
    }

    @Override
    public ImagePool.Image acquire(int w, int h, int type) {
        return this.acquire(w, h, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImagePool.Image acquire(int w, int h, int type, Consumer<BufferedImage> freedCallback) {
        this.mReentrantLock.writeLock().lock();
        try {
            Bucket.BucketCreationMetaData metaData = ImagePoolHelper.getBucketCreationMetaData(w, h, type, this.mPolicy, this.mImagePoolStats);
            if (metaData == null) {
                ImagePool.Image image = this.defaultImageImpl(w, h, type, freedCallback);
                return image;
            }
            Bucket existingBucket = ImagePoolHelper.getBucket(this.mPool, metaData, this.mPolicy);
            BufferedImage img = ImagePoolHelper.getBufferedImage(existingBucket, metaData, this.mImagePoolStats);
            if (img == null) {
                ImagePool.Image image = this.defaultImageImpl(w, h, type, freedCallback);
                return image;
            }
            if (img.getRaster().getDataBuffer().getDataType() == 3) {
                Arrays.fill(((DataBufferInt)img.getRaster().getDataBuffer()).getData(), 0);
            }
            ImagePool.Image image = this.prepareImage(new ImageImpl(w, h, img, metaData.mOrientation), true, img, existingBucket, freedCallback);
            return image;
        }
        finally {
            this.mReentrantLock.writeLock().unlock();
        }
    }

    private ImagePool.Image prepareImage(ImagePool.Image image, final boolean offerBackToBucket, final BufferedImage img, final Bucket existingBucket, final Consumer<BufferedImage> freedCallback) {
        final Integer imageHash = image.hashCode();
        this.mImagePoolStats.acquiredImage(imageHash);
        FinalizablePhantomReference<ImagePool.Image> reference = new FinalizablePhantomReference<ImagePool.Image>(image, this.mFinalizableReferenceQueue){

            public void finalizeReferent() {
                if (ImagePoolImpl.this.mReferences.remove((Object)this)) {
                    ImagePoolImpl.this.mImagePoolStats.disposeImage(imageHash);
                    if (offerBackToBucket) {
                        if (!ImagePoolImpl.this.mImagePoolStats.fitsMaxCacheSize(img.getWidth(), img.getHeight(), ((ImagePoolImpl)ImagePoolImpl.this).mPolicy.mBucketMaxCacheSize)) {
                            ImagePoolImpl.this.mImagePoolStats.tooBigForCache();
                            return;
                        }
                        existingBucket.offer(img);
                    }
                    if (freedCallback != null) {
                        freedCallback.accept(img);
                    }
                }
            }
        };
        this.mReferences.add((Reference<?>)reference);
        return image;
    }

    private ImagePool.Image defaultImageImpl(int w, int h, int type, Consumer<BufferedImage> freedCallback) {
        BufferedImage bufferedImage = new BufferedImage(w, h, type);
        this.mImagePoolStats.tooBigForCache();
        this.mImagePoolStats.recordAllocOutsidePool(w, h);
        return this.prepareImage(new ImageImpl(w, h, bufferedImage, ImagePool.Image.Orientation.NONE), false, null, null, freedCallback);
    }

    @Override
    public void dispose() {
        this.mReentrantLock.writeLock().lock();
        try {
            for (Bucket bucket : this.mPool.values()) {
                bucket.clear();
            }
            this.mImagePoolStats.clear();
        }
        finally {
            this.mReentrantLock.writeLock().unlock();
        }
    }

    void printStat() {
        System.out.println(this.mImagePoolStats.getStatistic());
    }
}

