/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.IStatsManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.StatsLogInternal;
import com.android.tools.layoutlib.create.OverrideMethod;

public class StatsLog
extends StatsLogInternal {
    private static final String TAG = "StatsLog";
    private static final boolean DEBUG = false;
    private static IStatsManager sService;
    private static Object sLogLock;

    private StatsLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logStart(int label) {
        Object object = sLogLock;
        synchronized (object) {
            try {
                IStatsManager service = StatsLog.getIStatsManagerLocked();
                if (service == null) {
                    return false;
                }
                service.sendAppBreadcrumbAtom(label, 3);
                return true;
            }
            catch (RemoteException e) {
                sService = null;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logStop(int label) {
        Object object = sLogLock;
        synchronized (object) {
            try {
                IStatsManager service = StatsLog.getIStatsManagerLocked();
                if (service == null) {
                    return false;
                }
                service.sendAppBreadcrumbAtom(label, 2);
                return true;
            }
            catch (RemoteException e) {
                sService = null;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logEvent(int label) {
        Object object = sLogLock;
        synchronized (object) {
            try {
                IStatsManager service = StatsLog.getIStatsManagerLocked();
                if (service == null) {
                    return false;
                }
                service.sendAppBreadcrumbAtom(label, 1);
                return true;
            }
            catch (RemoteException e) {
                sService = null;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logBinaryPushStateChanged(String trainName, long trainVersionCode, int options, int state, long[] experimentIds) {
        Object object = sLogLock;
        synchronized (object) {
            try {
                IStatsManager service = StatsLog.getIStatsManagerLocked();
                if (service == null) {
                    return false;
                }
                service.sendBinaryPushStateChangedAtom(trainName, trainVersionCode, options, state, experimentIds);
                return true;
            }
            catch (RemoteException e) {
                sService = null;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logWatchdogRollbackOccurred(int rollbackType, String packageName, long packageVersionCode) {
        Object object = sLogLock;
        synchronized (object) {
            try {
                IStatsManager service = StatsLog.getIStatsManagerLocked();
                if (service == null) {
                    return false;
                }
                service.sendWatchdogRollbackOccurredAtom(rollbackType, packageName, packageVersionCode);
                return true;
            }
            catch (RemoteException e) {
                sService = null;
                return false;
            }
        }
    }

    private static IStatsManager getIStatsManagerLocked() throws RemoteException {
        if (sService != null) {
            return sService;
        }
        sService = IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
        return sService;
    }

    @SystemApi
    public static void writeRaw(byte[] byArray, int n) {
        OverrideMethod.invokeV("android.util.StatsLog#writeRaw([BI)V", true, null);
    }

    private static void enforceDumpCallingPermission(Context context) {
        context.enforceCallingPermission("android.permission.DUMP", "Need DUMP permission.");
    }

    private static void enforcesageStatsCallingPermission(Context context) {
        context.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "Need PACKAGE_USAGE_STATS permission.");
    }

    static {
        sLogLock = new Object();
    }
}

