/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsMessageStoreException;
import android.telephony.ims.RcsOutgoingMessage;
import android.telephony.ims.RcsParticipant;

public class RcsOutgoingMessageDelivery {
    private final RcsControllerCall mRcsControllerCall;
    private final int mRecipientId;
    private final int mRcsOutgoingMessageId;

    RcsOutgoingMessageDelivery(RcsControllerCall rcsControllerCall, int recipientId, int messageId) {
        this.mRcsControllerCall = rcsControllerCall;
        this.mRecipientId = recipientId;
        this.mRcsOutgoingMessageId = messageId;
    }

    public void setDeliveredTimestamp(long deliveredTimestamp) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setOutgoingDeliveryDeliveredTimestamp(this.mRcsOutgoingMessageId, this.mRecipientId, deliveredTimestamp, callingPackage));
    }

    public long getDeliveredTimestamp() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getOutgoingDeliveryDeliveredTimestamp(this.mRcsOutgoingMessageId, this.mRecipientId, callingPackage));
    }

    public void setSeenTimestamp(long seenTimestamp) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setOutgoingDeliverySeenTimestamp(this.mRcsOutgoingMessageId, this.mRecipientId, seenTimestamp, callingPackage));
    }

    public long getSeenTimestamp() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getOutgoingDeliverySeenTimestamp(this.mRcsOutgoingMessageId, this.mRecipientId, callingPackage));
    }

    public void setStatus(int status) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setOutgoingDeliveryStatus(this.mRcsOutgoingMessageId, this.mRecipientId, status, callingPackage));
    }

    public int getStatus() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getOutgoingDeliveryStatus(this.mRcsOutgoingMessageId, this.mRecipientId, callingPackage));
    }

    public RcsParticipant getRecipient() {
        return new RcsParticipant(this.mRcsControllerCall, this.mRecipientId);
    }

    public RcsOutgoingMessage getMessage() {
        return new RcsOutgoingMessage(this.mRcsControllerCall, this.mRcsOutgoingMessageId);
    }
}

