/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.app.BroadcastOptions;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.INetworkPolicyManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionPlan;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.EuiccManager;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SubscriptionManager {
    private static final String LOG_TAG = "SubscriptionManager";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final int INVALID_SUBSCRIPTION_ID = -1;
    public static final int DUMMY_SUBSCRIPTION_ID_BASE = -2;
    public static final int INVALID_PHONE_INDEX = -1;
    public static final int INVALID_SIM_SLOT_INDEX = -1;
    public static final int DEFAULT_SUBSCRIPTION_ID = Integer.MAX_VALUE;
    public static final int DEFAULT_PHONE_INDEX = Integer.MAX_VALUE;
    public static final int DEFAULT_SIM_SLOT_INDEX = Integer.MAX_VALUE;
    public static final int MIN_SUBSCRIPTION_ID_VALUE = 0;
    public static final int MAX_SUBSCRIPTION_ID_VALUE = 0x7FFFFFFE;
    @UnsupportedAppUsage
    public static final Uri CONTENT_URI = Uri.parse("content://telephony/siminfo");
    @SystemApi
    public static final Uri WFC_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc");
    @SystemApi
    public static final Uri ADVANCED_CALLING_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "advanced_calling");
    @SystemApi
    public static final Uri WFC_MODE_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc_mode");
    @SystemApi
    public static final Uri WFC_ROAMING_MODE_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc_roaming_mode");
    @SystemApi
    public static final Uri VT_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "vt_enabled");
    @SystemApi
    public static final Uri WFC_ROAMING_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc_roaming_enabled");
    public static final String UNIQUE_KEY_SUBSCRIPTION_ID = "_id";
    public static final String ICC_ID = "icc_id";
    public static final String SIM_SLOT_INDEX = "sim_id";
    public static final int SIM_NOT_INSERTED = -1;
    public static final int SLOT_INDEX_FOR_REMOTE_SIM_SUB = -1;
    public static final String SUBSCRIPTION_TYPE = "subscription_type";
    @Deprecated
    public static final String WHITE_LISTED_APN_DATA = "white_listed_apn_data";
    public static final String DATA_ENABLED_OVERRIDE_RULES = "data_enabled_override_rules";
    public static final int SUBSCRIPTION_TYPE_LOCAL_SIM = 0;
    public static final int SUBSCRIPTION_TYPE_REMOTE_SIM = 1;
    public static final String DISPLAY_NAME = "display_name";
    public static final String CARRIER_NAME = "carrier_name";
    public static final int DEFAULT_NAME_RES = 17039374;
    public static final String NAME_SOURCE = "name_source";
    public static final int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static final int NAME_SOURCE_SIM_SOURCE = 1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static final int NAME_SOURCE_USER_INPUT = 2;
    public static final int NAME_SOURCE_CARRIER = 3;
    public static final String COLOR = "color";
    public static final int COLOR_1 = 0;
    public static final int COLOR_2 = 1;
    public static final int COLOR_3 = 2;
    public static final int COLOR_4 = 3;
    public static final int COLOR_DEFAULT = 0;
    public static final String NUMBER = "number";
    public static final String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static final int DISPLAY_NUMBER_NONE = 0;
    public static final int DISPLAY_NUMBER_FIRST = 1;
    public static final int DISPLAY_NUMBER_LAST = 2;
    public static final int DISPLAY_NUMBER_DEFAULT = 1;
    public static final String DATA_ROAMING = "data_roaming";
    public static final int DATA_ROAMING_ENABLE = 1;
    public static final int DATA_ROAMING_DISABLE = 0;
    public static final int DATA_ROAMING_DEFAULT = 0;
    public static final int SIM_PROVISIONED = 0;
    public static final String CARRIER_ID = "carrier_id";
    public static final String EHPLMNS = "ehplmns";
    public static final String HPLMNS = "hplmns";
    public static final String MCC_STRING = "mcc_string";
    public static final String MNC_STRING = "mnc_string";
    public static final String MCC = "mcc";
    public static final String MNC = "mnc";
    public static final String ISO_COUNTRY_CODE = "iso_country_code";
    public static final String SIM_PROVISIONING_STATUS = "sim_provisioning_status";
    public static final String IS_EMBEDDED = "is_embedded";
    public static final String CARD_ID = "card_id";
    public static final String ACCESS_RULES = "access_rules";
    public static final String IS_REMOVABLE = "is_removable";
    public static final String CB_EXTREME_THREAT_ALERT = "enable_cmas_extreme_threat_alerts";
    public static final String CB_SEVERE_THREAT_ALERT = "enable_cmas_severe_threat_alerts";
    public static final String CB_AMBER_ALERT = "enable_cmas_amber_alerts";
    public static final String CB_EMERGENCY_ALERT = "enable_emergency_alerts";
    public static final String CB_ALERT_SOUND_DURATION = "alert_sound_duration";
    public static final String CB_ALERT_REMINDER_INTERVAL = "alert_reminder_interval";
    public static final String CB_ALERT_VIBRATE = "enable_alert_vibrate";
    public static final String CB_ALERT_SPEECH = "enable_alert_speech";
    public static final String CB_ETWS_TEST_ALERT = "enable_etws_test_alerts";
    public static final String CB_CHANNEL_50_ALERT = "enable_channel_50_alerts";
    public static final String CB_CMAS_TEST_ALERT = "enable_cmas_test_alerts";
    public static final String CB_OPT_OUT_DIALOG = "show_cmas_opt_out_dialog";
    public static final String ENHANCED_4G_MODE_ENABLED = "volte_vt_enabled";
    public static final String VT_IMS_ENABLED = "vt_ims_enabled";
    public static final String WFC_IMS_ENABLED = "wfc_ims_enabled";
    public static final String WFC_IMS_MODE = "wfc_ims_mode";
    public static final String WFC_IMS_ROAMING_MODE = "wfc_ims_roaming_mode";
    public static final String WFC_IMS_ROAMING_ENABLED = "wfc_ims_roaming_enabled";
    public static final String IS_OPPORTUNISTIC = "is_opportunistic";
    public static final String GROUP_UUID = "group_uuid";
    public static final String GROUP_OWNER = "group_owner";
    public static final String IS_METERED = "is_metered";
    public static final String PROFILE_CLASS = "profile_class";
    @SystemApi
    public static final int PROFILE_CLASS_TESTING = 0;
    @SystemApi
    public static final int PROFILE_CLASS_PROVISIONING = 1;
    @SystemApi
    public static final int PROFILE_CLASS_OPERATIONAL = 2;
    @SystemApi
    public static final int PROFILE_CLASS_UNSET = -1;
    @SystemApi
    public static final int PROFILE_CLASS_DEFAULT = -1;
    public static final String IMSI = "imsi";
    public static final String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    public static final String ACTION_DEFAULT_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED";
    public static final String ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED";
    public static final String ACTION_MANAGE_SUBSCRIPTION_PLANS = "android.telephony.action.MANAGE_SUBSCRIPTION_PLANS";
    public static final String ACTION_REFRESH_SUBSCRIPTION_PLANS = "android.telephony.action.REFRESH_SUBSCRIPTION_PLANS";
    public static final String ACTION_SUBSCRIPTION_PLANS_CHANGED = "android.telephony.action.SUBSCRIPTION_PLANS_CHANGED";
    public static final String EXTRA_SUBSCRIPTION_INDEX = "android.telephony.extra.SUBSCRIPTION_INDEX";
    private final Context mContext;
    private volatile INetworkPolicyManager mNetworkPolicy;

    public static Uri getUriForSubscriptionId(int subscriptionId) {
        return Uri.withAppendedPath(CONTENT_URI, String.valueOf(subscriptionId));
    }

    @UnsupportedAppUsage
    public SubscriptionManager(Context context) {
        this.mContext = context;
    }

    @Deprecated
    public static SubscriptionManager from(Context context) {
        return (SubscriptionManager)context.getSystemService("telephony_subscription_service");
    }

    private INetworkPolicyManager getNetworkPolicy() {
        if (this.mNetworkPolicy == null) {
            this.mNetworkPolicy = INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy"));
        }
        return this.mNetworkPolicy;
    }

    public void addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgName = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.addOnSubscriptionsChangedListener(pkgName, listener.callback);
            }
        }
        catch (RemoteException ex) {
            Log.e(LOG_TAG, "Remote exception ITelephonyRegistry " + ex);
        }
    }

    public void removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.removeOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException ex) {
            Log.e(LOG_TAG, "Remote exception ITelephonyRegistry " + ex);
        }
    }

    public void addOnOpportunisticSubscriptionsChangedListener(Executor executor, OnOpportunisticSubscriptionsChangedListener listener) {
        if (executor == null || listener == null) {
            return;
        }
        String pkgName = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        listener.setExecutor(executor);
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.addOnOpportunisticSubscriptionsChangedListener(pkgName, listener.callback);
            }
        }
        catch (RemoteException ex) {
            Log.e(LOG_TAG, "Remote exception ITelephonyRegistry " + ex);
        }
    }

    public void removeOnOpportunisticSubscriptionsChangedListener(OnOpportunisticSubscriptionsChangedListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.removeOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException ex) {
            Log.e(LOG_TAG, "Remote exception ITelephonyRegistry " + ex);
        }
    }

    public SubscriptionInfo getActiveSubscriptionInfo(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        SubscriptionInfo subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    public SubscriptionInfo getActiveSubscriptionInfoForIccIndex(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForIccIndex]- null iccid");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForIccId(iccId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForSimSlotIndex]- invalid slotIndex");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForSimSlotIndex(slotIndex, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @UnsupportedAppUsage
    public List<SubscriptionInfo> getAllSubscriptionInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        return this.getActiveSubscriptionInfoList(true);
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList(boolean userVisibleOnly) {
        List<SubscriptionInfo> activeList = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                activeList = iSub.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (!userVisibleOnly || activeList == null) {
            return activeList;
        }
        return activeList.stream().filter(subInfo -> this.isSubscriptionVisible((SubscriptionInfo)subInfo)).collect(Collectors.toList());
    }

    @SystemApi
    public List<SubscriptionInfo> getAvailableSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAvailableSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public List<SubscriptionInfo> getAccessibleSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAccessibleSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @SystemApi
    public void requestEmbeddedSubscriptionInfoListRefresh() {
        int cardId = TelephonyManager.from(this.mContext).getCardIdForDefaultEuicc();
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.requestEmbeddedSubscriptionInfoListRefresh(cardId);
            }
        }
        catch (RemoteException ex) {
            SubscriptionManager.logd("requestEmbeddedSubscriptionInfoListFresh for card = " + cardId + " failed.");
        }
    }

    @SystemApi
    public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.requestEmbeddedSubscriptionInfoListRefresh(cardId);
            }
        }
        catch (RemoteException ex) {
            SubscriptionManager.logd("requestEmbeddedSubscriptionInfoListFresh for card = " + cardId + " failed.");
        }
    }

    @UnsupportedAppUsage
    public int getAllSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCountMax() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCountMax();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public Uri addSubscriptionInfoRecord(String iccId, int slotIndex) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- invalid slotIndex");
        }
        this.addSubscriptionInfoRecord(iccId, null, slotIndex, 0);
        return null;
    }

    public void addSubscriptionInfoRecord(String uniqueId, String displayName, int slotIndex, int subscriptionType) {
        if (uniqueId == null) {
            Log.e(LOG_TAG, "[addSubscriptionInfoRecord]- uniqueId is null");
            return;
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) {
                Log.e(LOG_TAG, "[addSubscriptionInfoRecord]- ISub service is null");
                return;
            }
            int result = iSub.addSubInfo(uniqueId, displayName, slotIndex, subscriptionType);
            if (result < 0) {
                Log.e(LOG_TAG, "Adding of subscription didn't succeed: error = " + result);
            } else {
                SubscriptionManager.logd("successfully added new subscription");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeSubscriptionInfoRecord(String uniqueId, int subscriptionType) {
        if (uniqueId == null) {
            Log.e(LOG_TAG, "[addSubscriptionInfoRecord]- uniqueId is null");
            return;
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) {
                Log.e(LOG_TAG, "[removeSubscriptionInfoRecord]- ISub service is null");
                return;
            }
            int result = iSub.removeSubInfo(uniqueId, subscriptionType);
            if (result < 0) {
                Log.e(LOG_TAG, "Removal of subscription didn't succeed: error = " + result);
            } else {
                SubscriptionManager.logd("successfully removed subscription");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public int setIconTint(int tint, int subId) {
        return this.setSubscriptionPropertyHelper(subId, "setIconTint", iSub -> iSub.setIconTint(tint, subId));
    }

    @UnsupportedAppUsage
    public int setDisplayName(String displayName, int subId, int nameSource) {
        return this.setSubscriptionPropertyHelper(subId, "setDisplayName", iSub -> iSub.setDisplayNameUsingSrc(displayName, subId, nameSource));
    }

    @UnsupportedAppUsage
    public int setDisplayNumber(String number, int subId) {
        if (number == null) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        return this.setSubscriptionPropertyHelper(subId, "setDisplayNumber", iSub -> iSub.setDisplayNumber(number, subId));
    }

    @UnsupportedAppUsage
    public int setDataRoaming(int roaming, int subId) {
        return this.setSubscriptionPropertyHelper(subId, "setDataRoaming", iSub -> iSub.setDataRoaming(roaming, subId));
    }

    public static int getSlotIndex(int subscriptionId) {
        if (!SubscriptionManager.isValidSubscriptionId(subscriptionId)) {
            // empty if block
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotIndex(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int[] getSubscriptionIds(int slotIndex) {
        return SubscriptionManager.getSubId(slotIndex);
    }

    @UnsupportedAppUsage
    public static int[] getSubId(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static int getPhoneId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return -1;
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private static void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public static int getDefaultSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static int getDefaultVoiceSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public void setDefaultVoiceSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public SubscriptionInfo getDefaultVoiceSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    @UnsupportedAppUsage
    public static int getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public static int getDefaultSmsSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    @SystemApi
    public void setDefaultSmsSubId(int subscriptionId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subscriptionId);
            }
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
    }

    public SubscriptionInfo getDefaultSmsSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    @UnsupportedAppUsage
    public int getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    public static int getDefaultDataSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    @SystemApi
    public void setDefaultDataSubId(int subscriptionId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public SubscriptionInfo getDefaultDataSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    @UnsupportedAppUsage
    public int getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    public void clearSubscriptionInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean allDefaultsSelected() {
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId())) {
            return false;
        }
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultSmsSubscriptionId())) {
            return false;
        }
        return SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public static boolean isValidSubscriptionId(int subscriptionId) {
        return subscriptionId > -1;
    }

    public static boolean isUsableSubscriptionId(int subscriptionId) {
        return SubscriptionManager.isUsableSubIdValue(subscriptionId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static boolean isUsableSubIdValue(int subId) {
        return subId >= 0 && subId <= 0x7FFFFFFE;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static boolean isValidSlotIndex(int slotIndex) {
        return slotIndex >= 0 && slotIndex < TelephonyManager.getDefault().getSimCount();
    }

    @UnsupportedAppUsage
    public static boolean isValidPhoneId(int phoneId) {
        return phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        int[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
            intent.putExtra("phone", phoneId);
        }
    }

    @UnsupportedAppUsage
    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId, int subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra(EXTRA_SUBSCRIPTION_INDEX, subId);
        intent.putExtra("phone", phoneId);
    }

    @UnsupportedAppUsage
    public int[] getActiveSubscriptionIdList() {
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList(true);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new int[]{};
        }
        return subId;
    }

    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0) {
            return false;
        }
        return TelephonyManager.getDefault().isNetworkRoaming(subId);
    }

    public static int getSimStateForSlotIndex(int slotIndex) {
        int simState = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                simState = iSub.getSimStateForSlotIndex(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return simState;
    }

    public static void setSubscriptionProperty(int subId, String propKey, String propValue) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setSubscriptionProperty(subId, propKey, propValue);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static String getSubscriptionProperty(int subId, String propKey, Context context) {
        String resultValue = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                resultValue = iSub.getSubscriptionProperty(subId, propKey, context.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return resultValue;
    }

    public static boolean getBooleanSubscriptionProperty(int subId, String propKey, boolean defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result) == 1;
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    public static int getIntegerSubscriptionProperty(int subId, String propKey, int defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    @UnsupportedAppUsage
    public static Resources getResourcesForSubId(Context context, int subId) {
        return SubscriptionManager.getResourcesForSubId(context, subId, false);
    }

    public static Resources getResourcesForSubId(Context context, int subId, boolean useRootLocale) {
        SubscriptionInfo subInfo = SubscriptionManager.from(context).getActiveSubscriptionInfo(subId);
        Configuration config = context.getResources().getConfiguration();
        Configuration newConfig = new Configuration();
        newConfig.setTo(config);
        if (subInfo != null) {
            newConfig.mcc = subInfo.getMcc();
            newConfig.mnc = subInfo.getMnc();
            if (newConfig.mnc == 0) {
                newConfig.mnc = 65535;
            }
        }
        if (useRootLocale) {
            newConfig.setLocale(Locale.ROOT);
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        DisplayMetrics newMetrics = new DisplayMetrics();
        newMetrics.setTo(metrics);
        return new Resources(context.getResources().getAssets(), newMetrics, newConfig);
    }

    public boolean isActiveSubscriptionId(int subscriptionId) {
        return this.isActiveSubId(subscriptionId);
    }

    @UnsupportedAppUsage
    public boolean isActiveSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                return iSub.isActiveSubId(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public List<SubscriptionPlan> getSubscriptionPlans(int subId) {
        try {
            SubscriptionPlan[] subscriptionPlans = this.getNetworkPolicy().getSubscriptionPlans(subId, this.mContext.getOpPackageName());
            return subscriptionPlans == null ? Collections.emptyList() : Arrays.asList(subscriptionPlans);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSubscriptionPlans(int subId, List<SubscriptionPlan> plans) {
        try {
            this.getNetworkPolicy().setSubscriptionPlans(subId, plans.toArray(new SubscriptionPlan[plans.size()]), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private String getSubscriptionPlansOwner(int subId) {
        try {
            return this.getNetworkPolicy().getSubscriptionPlansOwner(subId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSubscriptionOverrideUnmetered(int subId, boolean overrideUnmetered, long timeoutMillis) {
        try {
            int overrideValue = overrideUnmetered ? 1 : 0;
            this.getNetworkPolicy().setSubscriptionOverride(subId, 1, overrideValue, timeoutMillis, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSubscriptionOverrideCongested(int subId, boolean overrideCongested, long timeoutMillis) {
        try {
            int overrideValue = overrideCongested ? 2 : 0;
            this.getNetworkPolicy().setSubscriptionOverride(subId, 2, overrideValue, timeoutMillis, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Intent createManageSubscriptionIntent(int subId) {
        String owner = this.getSubscriptionPlansOwner(subId);
        if (owner == null) {
            return null;
        }
        List<SubscriptionPlan> plans = this.getSubscriptionPlans(subId);
        if (plans.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(ACTION_MANAGE_SUBSCRIPTION_PLANS);
        intent.setPackage(owner);
        intent.putExtra(EXTRA_SUBSCRIPTION_INDEX, subId);
        if (this.mContext.getPackageManager().queryIntentActivities(intent, 65536).isEmpty()) {
            return null;
        }
        return intent;
    }

    private Intent createRefreshSubscriptionIntent(int subId) {
        String owner = this.getSubscriptionPlansOwner(subId);
        if (owner == null) {
            return null;
        }
        List<SubscriptionPlan> plans = this.getSubscriptionPlans(subId);
        if (plans.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(ACTION_REFRESH_SUBSCRIPTION_PLANS);
        intent.addFlags(0x10000000);
        intent.setPackage(owner);
        intent.putExtra(EXTRA_SUBSCRIPTION_INDEX, subId);
        if (this.mContext.getPackageManager().queryBroadcastReceivers(intent, 0).isEmpty()) {
            return null;
        }
        return intent;
    }

    public boolean isSubscriptionPlansRefreshSupported(int subId) {
        return this.createRefreshSubscriptionIntent(subId) != null;
    }

    public void requestSubscriptionPlansRefresh(int subId) {
        Intent intent = this.createRefreshSubscriptionIntent(subId);
        BroadcastOptions options = BroadcastOptions.makeBasic();
        options.setTemporaryAppWhitelistDuration(TimeUnit.MINUTES.toMillis(1L));
        this.mContext.sendBroadcast(intent, null, options.toBundle());
    }

    public boolean canManageSubscription(SubscriptionInfo info) {
        return this.canManageSubscription(info, this.mContext.getPackageName());
    }

    public boolean canManageSubscription(SubscriptionInfo info, String packageName) {
        PackageInfo packageInfo;
        if (!info.isEmbedded()) {
            throw new IllegalArgumentException("Not an embedded subscription");
        }
        if (info.getAccessRules() == null) {
            return false;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Unknown package: " + packageName, e);
        }
        for (UiccAccessRule rule : info.getAccessRules()) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    public void setPreferredDataSubscriptionId(int subId, boolean needValidation, final Executor executor, final Consumer<Integer> callback) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) {
                return;
            }
            ISetOpportunisticDataCallback.Stub callbackStub = new ISetOpportunisticDataCallback.Stub(){

                @Override
                public void onComplete(int result) {
                    if (executor == null || callback == null) {
                        return;
                    }
                    Binder.withCleanCallingIdentity(() -> executor.execute(() -> callback.accept(result)));
                }
            };
            iSub.setPreferredDataSubscriptionId(subId, needValidation, callbackStub);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getPreferredDataSubscriptionId() {
        int preferredSubId = Integer.MAX_VALUE;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                preferredSubId = iSub.getPreferredDataSubscriptionId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return preferredSubId;
    }

    public List<SubscriptionInfo> getOpportunisticSubscriptions() {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        List<Object> subInfoList = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfoList = iSub.getOpportunisticSubscriptions(pkgForDebug);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subInfoList == null) {
            subInfoList = new ArrayList();
        }
        return subInfoList;
    }

    public void switchToSubscription(int subId, PendingIntent callbackIntent) {
        Preconditions.checkNotNull(callbackIntent, "callbackIntent cannot be null");
        EuiccManager euiccManager = new EuiccManager(this.mContext);
        euiccManager.switchToSubscription(subId, callbackIntent);
    }

    public boolean setOpportunistic(boolean opportunistic, int subId) {
        return this.setSubscriptionPropertyHelper(subId, "setOpportunistic", iSub -> iSub.setOpportunistic(opportunistic, subId, this.mContext.getOpPackageName())) == 1;
    }

    public ParcelUuid createSubscriptionGroup(List<Integer> subIdList) {
        ParcelUuid groupUuid;
        block5: {
            Preconditions.checkNotNull(subIdList, "can't create group for null subId list");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            groupUuid = null;
            int[] subIdArray = subIdList.stream().mapToInt(i -> i).toArray();
            try {
                ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub != null) {
                    groupUuid = iSub.createSubscriptionGroup(subIdArray, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("createSubscriptionGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
        return groupUuid;
    }

    public void addSubscriptionsIntoGroup(List<Integer> subIdList, ParcelUuid groupUuid) {
        block5: {
            Preconditions.checkNotNull(subIdList, "subIdList can't be null.");
            Preconditions.checkNotNull(groupUuid, "groupUuid can't be null.");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            int[] subIdArray = subIdList.stream().mapToInt(i -> i).toArray();
            try {
                ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub != null) {
                    iSub.addSubscriptionsIntoGroup(subIdArray, groupUuid, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("addSubscriptionsIntoGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
    }

    private boolean isSystemProcess() {
        return Process.myUid() == 1000;
    }

    public void removeSubscriptionsFromGroup(List<Integer> subIdList, ParcelUuid groupUuid) {
        block5: {
            Preconditions.checkNotNull(subIdList, "subIdList can't be null.");
            Preconditions.checkNotNull(groupUuid, "groupUuid can't be null.");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            int[] subIdArray = subIdList.stream().mapToInt(i -> i).toArray();
            try {
                ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub != null) {
                    iSub.removeSubscriptionsFromGroup(subIdArray, groupUuid, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("removeSubscriptionsFromGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
    }

    public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid) {
        List<SubscriptionInfo> result;
        block5: {
            Preconditions.checkNotNull(groupUuid, "groupUuid can't be null");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            result = null;
            try {
                ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub != null) {
                    result = iSub.getSubscriptionsInGroup(groupUuid, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("removeSubscriptionsFromGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
        return result;
    }

    private boolean isSubscriptionVisible(SubscriptionInfo info) {
        if (info == null) {
            return false;
        }
        if (info.getGroupUuid() == null || !info.isOpportunistic()) {
            return true;
        }
        boolean hasCarrierPrivilegePermission = TelephonyManager.from(this.mContext).hasCarrierPrivileges(info.getSubscriptionId()) || info.isEmbedded() && this.canManageSubscription(info);
        return hasCarrierPrivilegePermission;
    }

    public List<SubscriptionInfo> getSelectableSubscriptionInfoList() {
        List<SubscriptionInfo> availableList = this.getAvailableSubscriptionInfoList();
        if (availableList == null) {
            return null;
        }
        ArrayList<SubscriptionInfo> selectableList = new ArrayList<SubscriptionInfo>();
        HashMap<ParcelUuid, SubscriptionInfo> groupMap = new HashMap<ParcelUuid, SubscriptionInfo>();
        for (SubscriptionInfo info : availableList) {
            if (!this.isSubscriptionVisible(info)) continue;
            ParcelUuid groupUuid = info.getGroupUuid();
            if (groupUuid == null) {
                selectableList.add(info);
                continue;
            }
            if (groupMap.containsKey(groupUuid) && (((SubscriptionInfo)groupMap.get(groupUuid)).getSimSlotIndex() != -1 || info.getSimSlotIndex() == -1)) continue;
            selectableList.remove(groupMap.get(groupUuid));
            selectableList.add(info);
            groupMap.put(groupUuid, info);
        }
        return selectableList;
    }

    @SystemApi
    public boolean setSubscriptionEnabled(int subscriptionId, boolean enable) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                return iSub.setSubscriptionEnabled(enable, subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @SystemApi
    public boolean isSubscriptionEnabled(int subscriptionId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                return iSub.isSubscriptionEnabled(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @SystemApi
    public int getEnabledSubscriptionId(int slotIndex) {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getEnabledSubscriptionId(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public boolean setAlwaysAllowMmsData(int subId, boolean alwaysAllow) {
        block3: {
            try {
                ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub != null) {
                    return iSub.setAlwaysAllowMmsData(subId, alwaysAllow);
                }
            }
            catch (RemoteException ex) {
                if (this.isSystemProcess()) break block3;
                ex.rethrowAsRuntimeException();
            }
        }
        return false;
    }

    private int setSubscriptionPropertyHelper(int subId, String methodName, CallISubMethodHelper helper) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[" + methodName + "]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = helper.callMethod(iSub);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static interface CallISubMethodHelper {
        public int callMethod(ISub var1) throws RemoteException;
    }

    public static class OnOpportunisticSubscriptionsChangedListener {
        private Executor mExecutor;
        IOnSubscriptionsChangedListener callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                long identity = Binder.clearCallingIdentity();
                try {
                    mExecutor.execute(() -> this.onOpportunisticSubscriptionsChanged());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };

        public void onOpportunisticSubscriptionsChanged() {
        }

        private void setExecutor(Executor executor) {
            this.mExecutor = executor;
        }

        private void log(String s) {
            Rlog.d(SubscriptionManager.LOG_TAG, s);
        }
    }

    public static class OnSubscriptionsChangedListener {
        private final Handler mHandler;
        IOnSubscriptionsChangedListener callback = new IOnSubscriptionsChangedListener.Stub(this){
            final /* synthetic */ OnSubscriptionsChangedListener this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onSubscriptionsChanged() {
                this.this$0.mHandler.sendEmptyMessage(0);
            }
        };

        public OnSubscriptionsChangedListener() {
            this.mHandler = new OnSubscriptionsChangedListenerHandler();
        }

        public OnSubscriptionsChangedListener(Looper looper) {
            this.mHandler = new OnSubscriptionsChangedListenerHandler(looper);
        }

        public void onSubscriptionsChanged() {
        }

        private void log(String s) {
            Rlog.d(SubscriptionManager.LOG_TAG, s);
        }

        private class OnSubscriptionsChangedListenerHandler
        extends Handler {
            OnSubscriptionsChangedListenerHandler() {
            }

            OnSubscriptionsChangedListenerHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message msg) {
                OnSubscriptionsChangedListener.this.onSubscriptionsChanged();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscriptionType {
    }
}

