/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.AccessNetworkUtils;
import android.telephony.DataSpecificRegistrationInfo;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.Rlog;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ServiceState
implements Parcelable {
    static final String LOG_TAG = "PHONE";
    static final boolean DBG = false;
    static final boolean VDBG = false;
    public static final int STATE_IN_SERVICE = 0;
    public static final int STATE_OUT_OF_SERVICE = 1;
    public static final int STATE_EMERGENCY_ONLY = 2;
    public static final int STATE_POWER_OFF = 3;
    public static final int FREQUENCY_RANGE_UNKNOWN = -1;
    public static final int FREQUENCY_RANGE_LOW = 1;
    public static final int FREQUENCY_RANGE_MID = 2;
    public static final int FREQUENCY_RANGE_HIGH = 3;
    public static final int FREQUENCY_RANGE_MMWAVE = 4;
    private static final List<Integer> FREQUENCY_RANGE_ORDER = Arrays.asList(-1, 1, 2, 3, 4);
    public static final int DUPLEX_MODE_UNKNOWN = 0;
    public static final int DUPLEX_MODE_FDD = 1;
    public static final int DUPLEX_MODE_TDD = 2;
    public static final int RIL_RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static final int RIL_RADIO_TECHNOLOGY_GPRS = 1;
    public static final int RIL_RADIO_TECHNOLOGY_EDGE = 2;
    public static final int RIL_RADIO_TECHNOLOGY_UMTS = 3;
    public static final int RIL_RADIO_TECHNOLOGY_IS95A = 4;
    public static final int RIL_RADIO_TECHNOLOGY_IS95B = 5;
    public static final int RIL_RADIO_TECHNOLOGY_1xRTT = 6;
    public static final int RIL_RADIO_TECHNOLOGY_EVDO_0 = 7;
    public static final int RIL_RADIO_TECHNOLOGY_EVDO_A = 8;
    public static final int RIL_RADIO_TECHNOLOGY_HSDPA = 9;
    public static final int RIL_RADIO_TECHNOLOGY_HSUPA = 10;
    public static final int RIL_RADIO_TECHNOLOGY_HSPA = 11;
    public static final int RIL_RADIO_TECHNOLOGY_EVDO_B = 12;
    public static final int RIL_RADIO_TECHNOLOGY_EHRPD = 13;
    public static final int RIL_RADIO_TECHNOLOGY_LTE = 14;
    public static final int RIL_RADIO_TECHNOLOGY_HSPAP = 15;
    public static final int RIL_RADIO_TECHNOLOGY_GSM = 16;
    public static final int RIL_RADIO_TECHNOLOGY_TD_SCDMA = 17;
    @UnsupportedAppUsage(maxTargetSdk=28)
    public static final int RIL_RADIO_TECHNOLOGY_IWLAN = 18;
    public static final int RIL_RADIO_TECHNOLOGY_LTE_CA = 19;
    public static final int RIL_RADIO_TECHNOLOGY_NR = 20;
    private static final int NEXT_RIL_RADIO_TECHNOLOGY = 21;
    public static final int RIL_RADIO_CDMA_TECHNOLOGY_BITMASK = 6392;
    private int mVoiceRegState = 1;
    private int mDataRegState = 1;
    @SystemApi
    public static final int ROAMING_TYPE_NOT_ROAMING = 0;
    @SystemApi
    public static final int ROAMING_TYPE_UNKNOWN = 1;
    @SystemApi
    public static final int ROAMING_TYPE_DOMESTIC = 2;
    @SystemApi
    public static final int ROAMING_TYPE_INTERNATIONAL = 3;
    public static final int UNKNOWN_ID = -1;
    private String mVoiceOperatorAlphaLong;
    private String mVoiceOperatorAlphaShort;
    private String mVoiceOperatorNumeric;
    private String mDataOperatorAlphaLong;
    private String mDataOperatorAlphaShort;
    private String mDataOperatorNumeric;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private boolean mIsManualNetworkSelection;
    private boolean mIsEmergencyOnly;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private boolean mCssIndicator;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mNetworkId;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mSystemId;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mCdmaRoamingIndicator;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mCdmaDefaultRoamingIndicator;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mCdmaEriIconIndex;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mCdmaEriIconMode;
    private int mNrFrequencyRange;
    private int mChannelNumber;
    private int[] mCellBandwidths = new int[0];
    private int mLteEarfcnRsrpBoost = 0;
    private final List<NetworkRegistrationInfo> mNetworkRegistrationInfos = new ArrayList<NetworkRegistrationInfo>();
    private String mOperatorAlphaLongRaw;
    private String mOperatorAlphaShortRaw;
    private boolean mIsIwlanPreferred;
    public static final Parcelable.Creator<ServiceState> CREATOR = new Parcelable.Creator<ServiceState>(){

        @Override
        public ServiceState createFromParcel(Parcel in) {
            return new ServiceState(in);
        }

        public ServiceState[] newArray(int size) {
            return new ServiceState[size];
        }
    };

    public static String getRoamingLogString(int roamingType) {
        switch (roamingType) {
            case 0: {
                return "home";
            }
            case 1: {
                return "roaming";
            }
            case 2: {
                return "Domestic Roaming";
            }
            case 3: {
                return "International Roaming";
            }
        }
        return "UNKNOWN";
    }

    @UnsupportedAppUsage
    public static ServiceState newFromBundle(Bundle m) {
        ServiceState ret = new ServiceState();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    public ServiceState() {
    }

    public ServiceState(ServiceState s) {
        this.copyFrom(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFrom(ServiceState s) {
        this.mVoiceRegState = s.mVoiceRegState;
        this.mDataRegState = s.mDataRegState;
        this.mVoiceOperatorAlphaLong = s.mVoiceOperatorAlphaLong;
        this.mVoiceOperatorAlphaShort = s.mVoiceOperatorAlphaShort;
        this.mVoiceOperatorNumeric = s.mVoiceOperatorNumeric;
        this.mDataOperatorAlphaLong = s.mDataOperatorAlphaLong;
        this.mDataOperatorAlphaShort = s.mDataOperatorAlphaShort;
        this.mDataOperatorNumeric = s.mDataOperatorNumeric;
        this.mIsManualNetworkSelection = s.mIsManualNetworkSelection;
        this.mCssIndicator = s.mCssIndicator;
        this.mNetworkId = s.mNetworkId;
        this.mSystemId = s.mSystemId;
        this.mCdmaRoamingIndicator = s.mCdmaRoamingIndicator;
        this.mCdmaDefaultRoamingIndicator = s.mCdmaDefaultRoamingIndicator;
        this.mCdmaEriIconIndex = s.mCdmaEriIconIndex;
        this.mCdmaEriIconMode = s.mCdmaEriIconMode;
        this.mIsEmergencyOnly = s.mIsEmergencyOnly;
        this.mChannelNumber = s.mChannelNumber;
        this.mCellBandwidths = s.mCellBandwidths == null ? null : Arrays.copyOf(s.mCellBandwidths, s.mCellBandwidths.length);
        this.mLteEarfcnRsrpBoost = s.mLteEarfcnRsrpBoost;
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            this.mNetworkRegistrationInfos.clear();
            this.mNetworkRegistrationInfos.addAll(s.getNetworkRegistrationInfoList());
        }
        this.mNrFrequencyRange = s.mNrFrequencyRange;
        this.mOperatorAlphaLongRaw = s.mOperatorAlphaLongRaw;
        this.mOperatorAlphaShortRaw = s.mOperatorAlphaShortRaw;
        this.mIsIwlanPreferred = s.mIsIwlanPreferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ServiceState(Parcel in) {
        this.mVoiceRegState = in.readInt();
        this.mDataRegState = in.readInt();
        this.mVoiceOperatorAlphaLong = in.readString();
        this.mVoiceOperatorAlphaShort = in.readString();
        this.mVoiceOperatorNumeric = in.readString();
        this.mDataOperatorAlphaLong = in.readString();
        this.mDataOperatorAlphaShort = in.readString();
        this.mDataOperatorNumeric = in.readString();
        this.mIsManualNetworkSelection = in.readInt() != 0;
        this.mCssIndicator = in.readInt() != 0;
        this.mNetworkId = in.readInt();
        this.mSystemId = in.readInt();
        this.mCdmaRoamingIndicator = in.readInt();
        this.mCdmaDefaultRoamingIndicator = in.readInt();
        this.mCdmaEriIconIndex = in.readInt();
        this.mCdmaEriIconMode = in.readInt();
        this.mIsEmergencyOnly = in.readInt() != 0;
        this.mLteEarfcnRsrpBoost = in.readInt();
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            in.readList(this.mNetworkRegistrationInfos, NetworkRegistrationInfo.class.getClassLoader());
        }
        this.mChannelNumber = in.readInt();
        this.mCellBandwidths = in.createIntArray();
        this.mNrFrequencyRange = in.readInt();
        this.mOperatorAlphaLongRaw = in.readString();
        this.mOperatorAlphaShortRaw = in.readString();
        this.mIsIwlanPreferred = in.readBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mVoiceRegState);
        out.writeInt(this.mDataRegState);
        out.writeString(this.mVoiceOperatorAlphaLong);
        out.writeString(this.mVoiceOperatorAlphaShort);
        out.writeString(this.mVoiceOperatorNumeric);
        out.writeString(this.mDataOperatorAlphaLong);
        out.writeString(this.mDataOperatorAlphaShort);
        out.writeString(this.mDataOperatorNumeric);
        out.writeInt(this.mIsManualNetworkSelection ? 1 : 0);
        out.writeInt(this.mCssIndicator ? 1 : 0);
        out.writeInt(this.mNetworkId);
        out.writeInt(this.mSystemId);
        out.writeInt(this.mCdmaRoamingIndicator);
        out.writeInt(this.mCdmaDefaultRoamingIndicator);
        out.writeInt(this.mCdmaEriIconIndex);
        out.writeInt(this.mCdmaEriIconMode);
        out.writeInt(this.mIsEmergencyOnly ? 1 : 0);
        out.writeInt(this.mLteEarfcnRsrpBoost);
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            out.writeList(this.mNetworkRegistrationInfos);
        }
        out.writeInt(this.mChannelNumber);
        out.writeIntArray(this.mCellBandwidths);
        out.writeInt(this.mNrFrequencyRange);
        out.writeString(this.mOperatorAlphaLongRaw);
        out.writeString(this.mOperatorAlphaShortRaw);
        out.writeBoolean(this.mIsIwlanPreferred);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getState() {
        return this.getVoiceRegState();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getVoiceRegState() {
        return this.mVoiceRegState;
    }

    @UnsupportedAppUsage
    public int getDataRegState() {
        return this.mDataRegState;
    }

    public int getDuplexMode() {
        if (!ServiceState.isLte(this.getRilDataRadioTechnology())) {
            return 0;
        }
        int band = AccessNetworkUtils.getOperatingBandForEarfcn(this.mChannelNumber);
        return AccessNetworkUtils.getDuplexModeForEutranBand(band);
    }

    public int getChannelNumber() {
        return this.mChannelNumber;
    }

    public int[] getCellBandwidths() {
        return this.mCellBandwidths == null ? new int[]{} : this.mCellBandwidths;
    }

    public boolean getRoaming() {
        return this.getVoiceRoaming() || this.getDataRoaming();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean getVoiceRoaming() {
        return this.getVoiceRoamingType() != 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getVoiceRoamingType() {
        NetworkRegistrationInfo regState = this.getNetworkRegistrationInfo(1, 1);
        if (regState != null) {
            return regState.getRoamingType();
        }
        return 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean getDataRoaming() {
        return this.getDataRoamingType() != 0;
    }

    public boolean getDataRoamingFromRegistration() {
        NetworkRegistrationInfo regState = this.getNetworkRegistrationInfo(2, 1);
        if (regState != null) {
            return regState.getRegistrationState() == 5;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getDataRoamingType() {
        NetworkRegistrationInfo regState = this.getNetworkRegistrationInfo(2, 1);
        if (regState != null) {
            return regState.getRoamingType();
        }
        return 0;
    }

    @UnsupportedAppUsage
    public boolean isEmergencyOnly() {
        return this.mIsEmergencyOnly;
    }

    @UnsupportedAppUsage
    public int getCdmaRoamingIndicator() {
        return this.mCdmaRoamingIndicator;
    }

    @UnsupportedAppUsage
    public int getCdmaDefaultRoamingIndicator() {
        return this.mCdmaDefaultRoamingIndicator;
    }

    @UnsupportedAppUsage
    public int getCdmaEriIconIndex() {
        return this.mCdmaEriIconIndex;
    }

    @UnsupportedAppUsage
    public int getCdmaEriIconMode() {
        return this.mCdmaEriIconMode;
    }

    public String getOperatorAlphaLong() {
        return this.mVoiceOperatorAlphaLong;
    }

    @UnsupportedAppUsage
    public String getVoiceOperatorAlphaLong() {
        return this.mVoiceOperatorAlphaLong;
    }

    public String getDataOperatorAlphaLong() {
        return this.mDataOperatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.mVoiceOperatorAlphaShort;
    }

    @UnsupportedAppUsage
    public String getVoiceOperatorAlphaShort() {
        return this.mVoiceOperatorAlphaShort;
    }

    @UnsupportedAppUsage
    public String getDataOperatorAlphaShort() {
        return this.mDataOperatorAlphaShort;
    }

    public String getOperatorAlpha() {
        if (TextUtils.isEmpty(this.mVoiceOperatorAlphaLong)) {
            return this.mVoiceOperatorAlphaShort;
        }
        return this.mVoiceOperatorAlphaLong;
    }

    public String getOperatorNumeric() {
        return this.mVoiceOperatorNumeric;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getVoiceOperatorNumeric() {
        return this.mVoiceOperatorNumeric;
    }

    @UnsupportedAppUsage
    public String getDataOperatorNumeric() {
        return this.mDataOperatorNumeric;
    }

    public boolean getIsManualSelection() {
        return this.mIsManualNetworkSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            return Objects.hash(this.mVoiceRegState, this.mDataRegState, this.mChannelNumber, Arrays.hashCode(this.mCellBandwidths), this.mVoiceOperatorAlphaLong, this.mVoiceOperatorAlphaShort, this.mVoiceOperatorNumeric, this.mDataOperatorAlphaLong, this.mDataOperatorAlphaShort, this.mDataOperatorNumeric, this.mIsManualNetworkSelection, this.mCssIndicator, this.mNetworkId, this.mSystemId, this.mCdmaRoamingIndicator, this.mCdmaDefaultRoamingIndicator, this.mCdmaEriIconIndex, this.mCdmaEriIconMode, this.mIsEmergencyOnly, this.mLteEarfcnRsrpBoost, this.mNetworkRegistrationInfos, this.mNrFrequencyRange, this.mOperatorAlphaLongRaw, this.mOperatorAlphaShortRaw, this.mIsIwlanPreferred);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (!(o instanceof ServiceState)) {
            return false;
        }
        ServiceState s = (ServiceState)o;
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            return this.mVoiceRegState == s.mVoiceRegState && this.mDataRegState == s.mDataRegState && this.mIsManualNetworkSelection == s.mIsManualNetworkSelection && this.mChannelNumber == s.mChannelNumber && Arrays.equals(this.mCellBandwidths, s.mCellBandwidths) && ServiceState.equalsHandlesNulls(this.mVoiceOperatorAlphaLong, s.mVoiceOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mVoiceOperatorAlphaShort, s.mVoiceOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mVoiceOperatorNumeric, s.mVoiceOperatorNumeric) && ServiceState.equalsHandlesNulls(this.mDataOperatorAlphaLong, s.mDataOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mDataOperatorAlphaShort, s.mDataOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mDataOperatorNumeric, s.mDataOperatorNumeric) && ServiceState.equalsHandlesNulls(this.mCssIndicator, s.mCssIndicator) && ServiceState.equalsHandlesNulls(this.mNetworkId, s.mNetworkId) && ServiceState.equalsHandlesNulls(this.mSystemId, s.mSystemId) && ServiceState.equalsHandlesNulls(this.mCdmaRoamingIndicator, s.mCdmaRoamingIndicator) && ServiceState.equalsHandlesNulls(this.mCdmaDefaultRoamingIndicator, s.mCdmaDefaultRoamingIndicator) && this.mIsEmergencyOnly == s.mIsEmergencyOnly && ServiceState.equalsHandlesNulls(this.mOperatorAlphaLongRaw, s.mOperatorAlphaLongRaw) && ServiceState.equalsHandlesNulls(this.mOperatorAlphaShortRaw, s.mOperatorAlphaShortRaw) && this.mNetworkRegistrationInfos.size() == s.mNetworkRegistrationInfos.size() && this.mNetworkRegistrationInfos.containsAll(s.mNetworkRegistrationInfos) && this.mNrFrequencyRange == s.mNrFrequencyRange && this.mIsIwlanPreferred == s.mIsIwlanPreferred;
        }
    }

    public static String roamingTypeToString(int roamingType) {
        switch (roamingType) {
            case 0: {
                return "NOT_ROAMING";
            }
            case 1: {
                return "UNKNOWN";
            }
            case 2: {
                return "DOMESTIC";
            }
            case 3: {
                return "INTERNATIONAL";
            }
        }
        return "Unknown roaming type " + roamingType;
    }

    @UnsupportedAppUsage
    public static String rilRadioTechnologyToString(int rt) {
        String rtString;
        switch (rt) {
            case 0: {
                rtString = "Unknown";
                break;
            }
            case 1: {
                rtString = "GPRS";
                break;
            }
            case 2: {
                rtString = "EDGE";
                break;
            }
            case 3: {
                rtString = "UMTS";
                break;
            }
            case 4: {
                rtString = "CDMA-IS95A";
                break;
            }
            case 5: {
                rtString = "CDMA-IS95B";
                break;
            }
            case 6: {
                rtString = "1xRTT";
                break;
            }
            case 7: {
                rtString = "EvDo-rev.0";
                break;
            }
            case 8: {
                rtString = "EvDo-rev.A";
                break;
            }
            case 9: {
                rtString = "HSDPA";
                break;
            }
            case 10: {
                rtString = "HSUPA";
                break;
            }
            case 11: {
                rtString = "HSPA";
                break;
            }
            case 12: {
                rtString = "EvDo-rev.B";
                break;
            }
            case 13: {
                rtString = "eHRPD";
                break;
            }
            case 14: {
                rtString = "LTE";
                break;
            }
            case 15: {
                rtString = "HSPAP";
                break;
            }
            case 16: {
                rtString = "GSM";
                break;
            }
            case 18: {
                rtString = "IWLAN";
                break;
            }
            case 17: {
                rtString = "TD-SCDMA";
                break;
            }
            case 19: {
                rtString = "LTE_CA";
                break;
            }
            default: {
                rtString = "Unexpected";
                Rlog.w(LOG_TAG, "Unexpected radioTechnology=" + rt);
            }
        }
        return rtString;
    }

    public static String rilServiceStateToString(int serviceState) {
        switch (serviceState) {
            case 0: {
                return "IN_SERVICE";
            }
            case 1: {
                return "OUT_OF_SERVICE";
            }
            case 2: {
                return "EMERGENCY_ONLY";
            }
            case 3: {
                return "POWER_OFF";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            return "{mVoiceRegState=" + this.mVoiceRegState + ("(" + ServiceState.rilServiceStateToString(this.mVoiceRegState) + ")") + ", mDataRegState=" + this.mDataRegState + ("(" + ServiceState.rilServiceStateToString(this.mDataRegState) + ")") + ", mChannelNumber=" + this.mChannelNumber + ", duplexMode()=" + this.getDuplexMode() + ", mCellBandwidths=" + Arrays.toString(this.mCellBandwidths) + ", mVoiceOperatorAlphaLong=" + this.mVoiceOperatorAlphaLong + ", mVoiceOperatorAlphaShort=" + this.mVoiceOperatorAlphaShort + ", mDataOperatorAlphaLong=" + this.mDataOperatorAlphaLong + ", mDataOperatorAlphaShort=" + this.mDataOperatorAlphaShort + ", isManualNetworkSelection=" + this.mIsManualNetworkSelection + (this.mIsManualNetworkSelection ? "(manual)" : "(automatic)") + ", getRilVoiceRadioTechnology=" + this.getRilVoiceRadioTechnology() + ("(" + ServiceState.rilRadioTechnologyToString(this.getRilVoiceRadioTechnology()) + ")") + ", getRilDataRadioTechnology=" + this.getRilDataRadioTechnology() + ("(" + ServiceState.rilRadioTechnologyToString(this.getRilDataRadioTechnology()) + ")") + ", mCssIndicator=" + (this.mCssIndicator ? "supported" : "unsupported") + ", mNetworkId=" + this.mNetworkId + ", mSystemId=" + this.mSystemId + ", mCdmaRoamingIndicator=" + this.mCdmaRoamingIndicator + ", mCdmaDefaultRoamingIndicator=" + this.mCdmaDefaultRoamingIndicator + ", mIsEmergencyOnly=" + this.mIsEmergencyOnly + ", isUsingCarrierAggregation=" + this.isUsingCarrierAggregation() + ", mLteEarfcnRsrpBoost=" + this.mLteEarfcnRsrpBoost + ", mNetworkRegistrationInfos=" + this.mNetworkRegistrationInfos + ", mNrFrequencyRange=" + this.mNrFrequencyRange + ", mOperatorAlphaLongRaw=" + this.mOperatorAlphaLongRaw + ", mOperatorAlphaShortRaw=" + this.mOperatorAlphaShortRaw + ", mIsIwlanPreferred=" + this.mIsIwlanPreferred + "}";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.mVoiceRegState = 1;
        this.mDataRegState = 1;
        this.mChannelNumber = -1;
        this.mCellBandwidths = new int[0];
        this.mVoiceOperatorAlphaLong = null;
        this.mVoiceOperatorAlphaShort = null;
        this.mVoiceOperatorNumeric = null;
        this.mDataOperatorAlphaLong = null;
        this.mDataOperatorAlphaShort = null;
        this.mDataOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
        this.mLteEarfcnRsrpBoost = 0;
        this.mNrFrequencyRange = -1;
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            this.mNetworkRegistrationInfos.clear();
            this.addNetworkRegistrationInfo(new NetworkRegistrationInfo.Builder().setDomain(1).setTransportType(1).setRegistrationState(4).build());
            this.addNetworkRegistrationInfo(new NetworkRegistrationInfo.Builder().setDomain(2).setTransportType(1).setRegistrationState(4).build());
        }
        this.mOperatorAlphaLongRaw = null;
        this.mOperatorAlphaShortRaw = null;
        this.mIsIwlanPreferred = false;
    }

    public void setStateOutOfService() {
        this.init();
    }

    public void setStateOff() {
        this.init();
        this.mVoiceRegState = 3;
        this.mDataRegState = 3;
    }

    public void setState(int state) {
        this.setVoiceRegState(state);
    }

    @UnsupportedAppUsage
    public void setVoiceRegState(int state) {
        this.mVoiceRegState = state;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setDataRegState(int state) {
        this.mDataRegState = state;
    }

    public void setCellBandwidths(int[] bandwidths) {
        this.mCellBandwidths = bandwidths;
    }

    public void setChannelNumber(int channelNumber) {
        this.mChannelNumber = channelNumber;
    }

    public void setRoaming(boolean roaming) {
        this.setVoiceRoaming(roaming);
        this.setDataRoaming(roaming);
    }

    @UnsupportedAppUsage
    public void setVoiceRoaming(boolean roaming) {
        this.setVoiceRoamingType(roaming ? 1 : 0);
    }

    public void setVoiceRoamingType(int type) {
        NetworkRegistrationInfo regInfo = this.getNetworkRegistrationInfo(1, 1);
        if (regInfo == null) {
            regInfo = new NetworkRegistrationInfo.Builder().setDomain(1).setTransportType(1).build();
        }
        regInfo.setRoamingType(type);
        this.addNetworkRegistrationInfo(regInfo);
    }

    @UnsupportedAppUsage
    public void setDataRoaming(boolean dataRoaming) {
        this.setDataRoamingType(dataRoaming ? 1 : 0);
    }

    public void setDataRoamingType(int type) {
        NetworkRegistrationInfo regInfo = this.getNetworkRegistrationInfo(2, 1);
        if (regInfo == null) {
            regInfo = new NetworkRegistrationInfo.Builder().setDomain(2).setTransportType(1).build();
        }
        regInfo.setRoamingType(type);
        this.addNetworkRegistrationInfo(regInfo);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setEmergencyOnly(boolean emergencyOnly) {
        this.mIsEmergencyOnly = emergencyOnly;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCdmaRoamingIndicator(int roaming) {
        this.mCdmaRoamingIndicator = roaming;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCdmaDefaultRoamingIndicator(int roaming) {
        this.mCdmaDefaultRoamingIndicator = roaming;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCdmaEriIconIndex(int index) {
        this.mCdmaEriIconIndex = index;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCdmaEriIconMode(int mode) {
        this.mCdmaEriIconMode = mode;
    }

    public void setOperatorName(String longName, String shortName, String numeric) {
        this.mVoiceOperatorAlphaLong = longName;
        this.mVoiceOperatorAlphaShort = shortName;
        this.mVoiceOperatorNumeric = numeric;
        this.mDataOperatorAlphaLong = longName;
        this.mDataOperatorAlphaShort = shortName;
        this.mDataOperatorNumeric = numeric;
    }

    public void setVoiceOperatorName(String longName, String shortName, String numeric) {
        this.mVoiceOperatorAlphaLong = longName;
        this.mVoiceOperatorAlphaShort = shortName;
        this.mVoiceOperatorNumeric = numeric;
    }

    public void setDataOperatorName(String longName, String shortName, String numeric) {
        this.mDataOperatorAlphaLong = longName;
        this.mDataOperatorAlphaShort = shortName;
        this.mDataOperatorNumeric = numeric;
    }

    @UnsupportedAppUsage
    public void setOperatorAlphaLong(String longName) {
        this.mVoiceOperatorAlphaLong = longName;
        this.mDataOperatorAlphaLong = longName;
    }

    public void setVoiceOperatorAlphaLong(String longName) {
        this.mVoiceOperatorAlphaLong = longName;
    }

    public void setDataOperatorAlphaLong(String longName) {
        this.mDataOperatorAlphaLong = longName;
    }

    public void setIsManualSelection(boolean isManual) {
        this.mIsManualNetworkSelection = isManual;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @UnsupportedAppUsage
    private void setFromNotifierBundle(Bundle m) {
        ServiceState ssFromBundle = (ServiceState)m.getParcelable("android.intent.extra.SERVICE_STATE");
        if (ssFromBundle != null) {
            this.copyFrom(ssFromBundle);
        }
    }

    @UnsupportedAppUsage
    public void fillInNotifierBundle(Bundle m) {
        m.putParcelable("android.intent.extra.SERVICE_STATE", this);
        m.putInt("voiceRegState", this.mVoiceRegState);
        m.putInt("dataRegState", this.mDataRegState);
        m.putInt("dataRoamingType", this.getDataRoamingType());
        m.putInt("voiceRoamingType", this.getVoiceRoamingType());
        m.putString("operator-alpha-long", this.mVoiceOperatorAlphaLong);
        m.putString("operator-alpha-short", this.mVoiceOperatorAlphaShort);
        m.putString("operator-numeric", this.mVoiceOperatorNumeric);
        m.putString("data-operator-alpha-long", this.mDataOperatorAlphaLong);
        m.putString("data-operator-alpha-short", this.mDataOperatorAlphaShort);
        m.putString("data-operator-numeric", this.mDataOperatorNumeric);
        m.putBoolean("manual", this.mIsManualNetworkSelection);
        m.putInt("radioTechnology", this.getRilVoiceRadioTechnology());
        m.putInt("dataRadioTechnology", this.getRadioTechnology());
        m.putBoolean("cssIndicator", this.mCssIndicator);
        m.putInt("networkId", this.mNetworkId);
        m.putInt("systemId", this.mSystemId);
        m.putInt("cdmaRoamingIndicator", this.mCdmaRoamingIndicator);
        m.putInt("cdmaDefaultRoamingIndicator", this.mCdmaDefaultRoamingIndicator);
        m.putBoolean("emergencyOnly", this.mIsEmergencyOnly);
        m.putBoolean("isDataRoamingFromRegistration", this.getDataRoamingFromRegistration());
        m.putBoolean("isUsingCarrierAggregation", this.isUsingCarrierAggregation());
        m.putInt("LteEarfcnRsrpBoost", this.mLteEarfcnRsrpBoost);
        m.putInt("ChannelNumber", this.mChannelNumber);
        m.putIntArray("CellBandwidths", this.mCellBandwidths);
        m.putInt("mNrFrequencyRange", this.mNrFrequencyRange);
        m.putString("operator-alpha-long-raw", this.mOperatorAlphaLongRaw);
        m.putString("operator-alpha-short-raw", this.mOperatorAlphaShortRaw);
    }

    public void setRilVoiceRadioTechnology(int rt) {
        Rlog.e(LOG_TAG, "ServiceState.setRilVoiceRadioTechnology() called. It's encouraged to use addNetworkRegistrationInfo() instead *******");
        NetworkRegistrationInfo regInfo = this.getNetworkRegistrationInfo(1, 1);
        if (regInfo == null) {
            regInfo = new NetworkRegistrationInfo.Builder().setDomain(1).setTransportType(1).build();
        }
        regInfo.setAccessNetworkTechnology(ServiceState.rilRadioTechnologyToNetworkType(rt));
        this.addNetworkRegistrationInfo(regInfo);
    }

    public void setRilDataRadioTechnology(int rt) {
        Rlog.e(LOG_TAG, "ServiceState.setRilDataRadioTechnology() called. It's encouraged to use addNetworkRegistrationInfo() instead *******");
        NetworkRegistrationInfo regInfo = this.getNetworkRegistrationInfo(2, 1);
        if (regInfo == null) {
            regInfo = new NetworkRegistrationInfo.Builder().setDomain(2).setTransportType(1).build();
        }
        regInfo.setAccessNetworkTechnology(ServiceState.rilRadioTechnologyToNetworkType(rt));
        this.addNetworkRegistrationInfo(regInfo);
    }

    public boolean isUsingCarrierAggregation() {
        DataSpecificRegistrationInfo dsri;
        NetworkRegistrationInfo nri = this.getNetworkRegistrationInfo(2, 1);
        if (nri != null && (dsri = nri.getDataSpecificInfo()) != null) {
            return dsri.isUsingCarrierAggregation();
        }
        return false;
    }

    public void setIsUsingCarrierAggregation(boolean ca) {
        DataSpecificRegistrationInfo dsri;
        NetworkRegistrationInfo nri = this.getNetworkRegistrationInfo(2, 1);
        if (nri != null && (dsri = nri.getDataSpecificInfo()) != null) {
            dsri.setIsUsingCarrierAggregation(ca);
        }
    }

    public int getNrFrequencyRange() {
        return this.mNrFrequencyRange;
    }

    public int getNrState() {
        NetworkRegistrationInfo regInfo = this.getNetworkRegistrationInfo(2, 1);
        if (regInfo == null) {
            return -1;
        }
        return regInfo.getNrState();
    }

    public void setNrFrequencyRange(int nrFrequencyRange) {
        this.mNrFrequencyRange = nrFrequencyRange;
    }

    public int getLteEarfcnRsrpBoost() {
        return this.mLteEarfcnRsrpBoost;
    }

    public void setLteEarfcnRsrpBoost(int LteEarfcnRsrpBoost) {
        this.mLteEarfcnRsrpBoost = LteEarfcnRsrpBoost;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCssIndicator(int css) {
        this.mCssIndicator = css != 0;
    }

    public void setCdmaSystemAndNetworkId(int systemId, int networkId) {
        this.mSystemId = systemId;
        this.mNetworkId = networkId;
    }

    @UnsupportedAppUsage
    public int getRilVoiceRadioTechnology() {
        NetworkRegistrationInfo wwanRegInfo = this.getNetworkRegistrationInfo(1, 1);
        if (wwanRegInfo != null) {
            return ServiceState.networkTypeToRilRadioTechnology(wwanRegInfo.getAccessNetworkTechnology());
        }
        return 0;
    }

    @UnsupportedAppUsage
    public int getRilDataRadioTechnology() {
        return ServiceState.networkTypeToRilRadioTechnology(this.getDataNetworkType());
    }

    @UnsupportedAppUsage
    public int getRadioTechnology() {
        Rlog.e(LOG_TAG, "ServiceState.getRadioTechnology() DEPRECATED will be removed *******");
        return this.getRilDataRadioTechnology();
    }

    public static int rilRadioTechnologyToNetworkType(int rat) {
        switch (rat) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 13;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
        }
        return 0;
    }

    public static int rilRadioTechnologyToAccessNetworkType(int rt) {
        switch (rt) {
            case 1: 
            case 2: 
            case 16: {
                return 1;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                return 4;
            }
            case 14: 
            case 19: {
                return 3;
            }
            case 18: {
                return 5;
            }
        }
        return 0;
    }

    public static int networkTypeToRilRadioTechnology(int networkType) {
        switch (networkType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 12: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
        }
        return 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getDataNetworkType() {
        NetworkRegistrationInfo iwlanRegInfo = this.getNetworkRegistrationInfo(2, 2);
        NetworkRegistrationInfo wwanRegInfo = this.getNetworkRegistrationInfo(2, 1);
        if (iwlanRegInfo == null || !iwlanRegInfo.isInService()) {
            return wwanRegInfo != null ? wwanRegInfo.getAccessNetworkTechnology() : 0;
        }
        if (!wwanRegInfo.isInService() || this.mIsIwlanPreferred) {
            return iwlanRegInfo.getAccessNetworkTechnology();
        }
        return wwanRegInfo.getAccessNetworkTechnology();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getVoiceNetworkType() {
        NetworkRegistrationInfo regState = this.getNetworkRegistrationInfo(1, 1);
        if (regState != null) {
            return regState.getAccessNetworkTechnology();
        }
        return 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getCssIndicator() {
        return this.mCssIndicator ? 1 : 0;
    }

    public int getCdmaNetworkId() {
        return this.mNetworkId;
    }

    public int getCdmaSystemId() {
        return this.mSystemId;
    }

    @UnsupportedAppUsage
    public static boolean isGsm(int radioTechnology) {
        return radioTechnology == 1 || radioTechnology == 2 || radioTechnology == 3 || radioTechnology == 9 || radioTechnology == 10 || radioTechnology == 11 || radioTechnology == 14 || radioTechnology == 15 || radioTechnology == 16 || radioTechnology == 17 || radioTechnology == 18 || radioTechnology == 19;
    }

    @UnsupportedAppUsage
    public static boolean isCdma(int radioTechnology) {
        return radioTechnology == 4 || radioTechnology == 5 || radioTechnology == 6 || radioTechnology == 7 || radioTechnology == 8 || radioTechnology == 12 || radioTechnology == 13;
    }

    public static boolean isLte(int radioTechnology) {
        return radioTechnology == 14 || radioTechnology == 19;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static boolean bearerBitmapHasCdma(int networkTypeBitmask) {
        return (0x18F8 & ServiceState.convertNetworkTypeBitmaskToBearerBitmask(networkTypeBitmask)) != 0;
    }

    @UnsupportedAppUsage
    public static boolean bitmaskHasTech(int bearerBitmask, int radioTech) {
        if (bearerBitmask == 0) {
            return true;
        }
        if (radioTech >= 1) {
            return (bearerBitmask & 1 << radioTech - 1) != 0;
        }
        return false;
    }

    public static int getBitmaskForTech(int radioTech) {
        if (radioTech >= 1) {
            return 1 << radioTech - 1;
        }
        return 0;
    }

    public static int getBitmaskFromString(String bearerList) {
        String[] bearers = bearerList.split("\\|");
        int bearerBitmask = 0;
        for (String bearer : bearers) {
            int bearerInt = 0;
            try {
                bearerInt = Integer.parseInt(bearer.trim());
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
            if (bearerInt == 0) {
                return 0;
            }
            bearerBitmask |= ServiceState.getBitmaskForTech(bearerInt);
        }
        return bearerBitmask;
    }

    public static int convertNetworkTypeBitmaskToBearerBitmask(int networkTypeBitmask) {
        if (networkTypeBitmask == 0) {
            return 0;
        }
        int bearerBitmask = 0;
        for (int bearerInt = 0; bearerInt < 21; ++bearerInt) {
            if (!ServiceState.bitmaskHasTech(networkTypeBitmask, ServiceState.rilRadioTechnologyToNetworkType(bearerInt))) continue;
            bearerBitmask |= ServiceState.getBitmaskForTech(bearerInt);
        }
        return bearerBitmask;
    }

    public static int convertBearerBitmaskToNetworkTypeBitmask(int bearerBitmask) {
        if (bearerBitmask == 0) {
            return 0;
        }
        int networkTypeBitmask = 0;
        for (int bearerInt = 0; bearerInt < 21; ++bearerInt) {
            if (!ServiceState.bitmaskHasTech(bearerBitmask, bearerInt)) continue;
            networkTypeBitmask |= ServiceState.getBitmaskForTech(ServiceState.rilRadioTechnologyToNetworkType(bearerInt));
        }
        return networkTypeBitmask;
    }

    @UnsupportedAppUsage
    public static ServiceState mergeServiceStates(ServiceState baseSs, ServiceState voiceSs) {
        if (voiceSs.mVoiceRegState != 0) {
            return baseSs;
        }
        ServiceState newSs = new ServiceState(baseSs);
        newSs.mVoiceRegState = voiceSs.mVoiceRegState;
        newSs.mIsEmergencyOnly = false;
        return newSs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public List<NetworkRegistrationInfo> getNetworkRegistrationInfoList() {
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            ArrayList<NetworkRegistrationInfo> newList = new ArrayList<NetworkRegistrationInfo>();
            for (NetworkRegistrationInfo nri : this.mNetworkRegistrationInfos) {
                newList.add(new NetworkRegistrationInfo(nri));
            }
            return newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public List<NetworkRegistrationInfo> getNetworkRegistrationInfoListForTransportType(int transportType) {
        ArrayList<NetworkRegistrationInfo> list = new ArrayList<NetworkRegistrationInfo>();
        List<NetworkRegistrationInfo> list2 = this.mNetworkRegistrationInfos;
        synchronized (list2) {
            for (NetworkRegistrationInfo networkRegistrationInfo : this.mNetworkRegistrationInfos) {
                if (networkRegistrationInfo.getTransportType() != transportType) continue;
                list.add(new NetworkRegistrationInfo(networkRegistrationInfo));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public List<NetworkRegistrationInfo> getNetworkRegistrationInfoListForDomain(int domain) {
        ArrayList<NetworkRegistrationInfo> list = new ArrayList<NetworkRegistrationInfo>();
        List<NetworkRegistrationInfo> list2 = this.mNetworkRegistrationInfos;
        synchronized (list2) {
            for (NetworkRegistrationInfo networkRegistrationInfo : this.mNetworkRegistrationInfos) {
                if (networkRegistrationInfo.getDomain() != domain) continue;
                list.add(new NetworkRegistrationInfo(networkRegistrationInfo));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public NetworkRegistrationInfo getNetworkRegistrationInfo(int domain, int transportType) {
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            for (NetworkRegistrationInfo networkRegistrationInfo : this.mNetworkRegistrationInfos) {
                if (networkRegistrationInfo.getTransportType() != transportType || networkRegistrationInfo.getDomain() != domain) continue;
                return new NetworkRegistrationInfo(networkRegistrationInfo);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkRegistrationInfo(NetworkRegistrationInfo nri) {
        if (nri == null) {
            return;
        }
        List<NetworkRegistrationInfo> list = this.mNetworkRegistrationInfos;
        synchronized (list) {
            for (int i = 0; i < this.mNetworkRegistrationInfos.size(); ++i) {
                NetworkRegistrationInfo curRegState = this.mNetworkRegistrationInfos.get(i);
                if (curRegState.getTransportType() != nri.getTransportType() || curRegState.getDomain() != nri.getDomain()) continue;
                this.mNetworkRegistrationInfos.remove(i);
                break;
            }
            this.mNetworkRegistrationInfos.add(new NetworkRegistrationInfo(nri));
        }
    }

    public static int getBetterNRFrequencyRange(int range1, int range2) {
        return FREQUENCY_RANGE_ORDER.indexOf(range1) > FREQUENCY_RANGE_ORDER.indexOf(range2) ? range1 : range2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceState sanitizeLocationInfo(boolean removeCoarseLocation) {
        ServiceState state = new ServiceState(this);
        List<NetworkRegistrationInfo> list = state.mNetworkRegistrationInfos;
        synchronized (list) {
            List networkRegistrationInfos = state.mNetworkRegistrationInfos.stream().map(NetworkRegistrationInfo::sanitizeLocationInfo).collect(Collectors.toList());
            state.mNetworkRegistrationInfos.clear();
            state.mNetworkRegistrationInfos.addAll(networkRegistrationInfos);
        }
        if (!removeCoarseLocation) {
            return state;
        }
        state.mDataOperatorAlphaLong = null;
        state.mDataOperatorAlphaShort = null;
        state.mDataOperatorNumeric = null;
        state.mVoiceOperatorAlphaLong = null;
        state.mVoiceOperatorAlphaShort = null;
        state.mVoiceOperatorNumeric = null;
        return state;
    }

    public void setOperatorAlphaLongRaw(String operatorAlphaLong) {
        this.mOperatorAlphaLongRaw = operatorAlphaLong;
    }

    public String getOperatorAlphaLongRaw() {
        return this.mOperatorAlphaLongRaw;
    }

    public void setOperatorAlphaShortRaw(String operatorAlphaShort) {
        this.mOperatorAlphaShortRaw = operatorAlphaShort;
    }

    public String getOperatorAlphaShortRaw() {
        return this.mOperatorAlphaShortRaw;
    }

    public void setIwlanPreferred(boolean isIwlanPreferred) {
        this.mIsIwlanPreferred = isIwlanPreferred;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RoamingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RilRadioTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DuplexMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrequencyRange {
    }
}

