/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.hardware.radio.V1_0.TdScdmaSignalStrength;
import android.hardware.radio.V1_2.TdscdmaSignalStrength;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import java.util.Objects;

public class CellSignalStrengthTdscdma
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthTdscdma";
    private static final boolean DBG = false;
    private static final int TDSCDMA_RSCP_MAX = -24;
    private static final int TDSCDMA_RSCP_GREAT = -49;
    private static final int TDSCDMA_RSCP_GOOD = -73;
    private static final int TDSCDMA_RSCP_MODERATE = -97;
    private static final int TDSCDMA_RSCP_POOR = -110;
    private static final int TDSCDMA_RSCP_MIN = -120;
    private int mRssi;
    private int mBitErrorRate;
    private int mRscp;
    private int mLevel;
    private static final CellSignalStrengthTdscdma sInvalid = new CellSignalStrengthTdscdma();
    public static final Parcelable.Creator<CellSignalStrengthTdscdma> CREATOR = new Parcelable.Creator<CellSignalStrengthTdscdma>(){

        @Override
        public CellSignalStrengthTdscdma createFromParcel(Parcel in) {
            return new CellSignalStrengthTdscdma(in);
        }

        public CellSignalStrengthTdscdma[] newArray(int size) {
            return new CellSignalStrengthTdscdma[size];
        }
    };

    public CellSignalStrengthTdscdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthTdscdma(int rssi, int ber, int rscp) {
        this.mRssi = CellSignalStrengthTdscdma.inRangeOrUnavailable(rssi, -113, -51);
        this.mBitErrorRate = CellSignalStrengthTdscdma.inRangeOrUnavailable(ber, 0, 7, 99);
        this.mRscp = CellSignalStrengthTdscdma.inRangeOrUnavailable(rscp, -120, -24);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthTdscdma(TdScdmaSignalStrength tdscdma) {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, tdscdma.rscp != Integer.MAX_VALUE ? -tdscdma.rscp : tdscdma.rscp);
        if (this.mRssi == Integer.MAX_VALUE && this.mRscp == Integer.MAX_VALUE) {
            this.setDefaultValues();
        }
    }

    public CellSignalStrengthTdscdma(TdscdmaSignalStrength tdscdma) {
        this(CellSignalStrengthTdscdma.getRssiDbmFromAsu(tdscdma.signalStrength), tdscdma.bitErrorRate, CellSignalStrengthTdscdma.getRscpDbmFromAsu(tdscdma.rscp));
        if (this.mRssi == Integer.MAX_VALUE && this.mRscp == Integer.MAX_VALUE) {
            this.setDefaultValues();
        }
    }

    public CellSignalStrengthTdscdma(CellSignalStrengthTdscdma s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthTdscdma s) {
        this.mRssi = s.mRssi;
        this.mBitErrorRate = s.mBitErrorRate;
        this.mRscp = s.mRscp;
        this.mLevel = s.mLevel;
    }

    @Override
    public CellSignalStrengthTdscdma copy() {
        return new CellSignalStrengthTdscdma(this);
    }

    @Override
    public void setDefaultValues() {
        this.mRssi = Integer.MAX_VALUE;
        this.mBitErrorRate = Integer.MAX_VALUE;
        this.mRscp = Integer.MAX_VALUE;
        this.mLevel = 0;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        this.mLevel = this.mRscp > -24 ? 0 : (this.mRscp >= -49 ? 4 : (this.mRscp >= -73 ? 3 : (this.mRscp >= -97 ? 2 : (this.mRscp >= -110 ? 1 : 0))));
    }

    @Override
    public int getDbm() {
        return this.mRscp;
    }

    public int getRscp() {
        return this.mRscp;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getBitErrorRate() {
        return this.mBitErrorRate;
    }

    @Override
    public int getAsuLevel() {
        if (this.mRscp != Integer.MAX_VALUE) {
            return CellSignalStrengthTdscdma.getAsuFromRscpDbm(this.mRscp);
        }
        if (this.mRssi != Integer.MAX_VALUE) {
            return CellSignalStrengthTdscdma.getAsuFromRssiDbm(this.mRssi);
        }
        return CellSignalStrengthTdscdma.getAsuFromRscpDbm(Integer.MAX_VALUE);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mRssi, this.mBitErrorRate, this.mRscp, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CellSignalStrengthTdscdma)) {
            return false;
        }
        CellSignalStrengthTdscdma s = (CellSignalStrengthTdscdma)o;
        return this.mRssi == s.mRssi && this.mBitErrorRate == s.mBitErrorRate && this.mRscp == s.mRscp && this.mLevel == s.mLevel;
    }

    public String toString() {
        return "CellSignalStrengthTdscdma: rssi=" + this.mRssi + " ber=" + this.mBitErrorRate + " rscp=" + this.mRscp + " level=" + this.mLevel;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mBitErrorRate);
        dest.writeInt(this.mRscp);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthTdscdma(Parcel in) {
        this.mRssi = in.readInt();
        this.mBitErrorRate = in.readInt();
        this.mRscp = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

