/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ComponentName;
import android.net.Uri;
import android.text.TextUtils;
import com.android.internal.util.ArrayUtils;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingsValidators {
    public static final Validator BOOLEAN_VALIDATOR = new DiscreteValueValidator(new String[]{"0", "1"});
    public static final Validator ANY_STRING_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            return true;
        }
    };
    public static final Validator NON_NEGATIVE_INTEGER_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            try {
                return Integer.parseInt(value) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Validator ANY_INTEGER_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Validator URI_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            try {
                Uri.decode(value);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    };
    public static final Validator COMPONENT_NAME_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            return value != null && ComponentName.unflattenFromString(value) != null;
        }
    };
    public static final Validator NULLABLE_COMPONENT_NAME_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            return value == null || COMPONENT_NAME_VALIDATOR.validate(value);
        }
    };
    public static final Validator PACKAGE_NAME_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            return value != null && this.isStringPackageName(value);
        }

        private boolean isStringPackageName(String value) {
            if (value == null) {
                return false;
            }
            String[] subparts = value.split("\\.");
            boolean isValidPackageName = true;
            for (String subpart : subparts) {
                if (!(isValidPackageName &= this.isSubpartValidForPackageName(subpart))) break;
            }
            return isValidPackageName;
        }

        private boolean isSubpartValidForPackageName(String subpart) {
            if (subpart.length() == 0) {
                return false;
            }
            boolean isValidSubpart = Character.isLetter(subpart.charAt(0));
            for (int i = 1; i < subpart.length() && (isValidSubpart &= Character.isLetterOrDigit(subpart.charAt(i)) || subpart.charAt(i) == '_'); ++i) {
            }
            return isValidSubpart;
        }
    };
    public static final Validator LENIENT_IP_ADDRESS_VALIDATOR = new Validator(){
        private static final int MAX_IPV6_LENGTH = 45;

        @Override
        public boolean validate(String value) {
            if (value == null) {
                return false;
            }
            return value.length() <= 45;
        }
    };
    public static final Validator LOCALE_VALIDATOR = new Validator(){

        @Override
        public boolean validate(String value) {
            Locale[] validLocales;
            if (value == null) {
                return false;
            }
            for (Locale locale : validLocales = Locale.getAvailableLocales()) {
                if (!value.equals(locale.toString())) continue;
                return true;
            }
            return false;
        }
    };
    public static final Validator JSON_OBJECT_VALIDATOR = value -> {
        if (TextUtils.isEmpty(value)) {
            return false;
        }
        try {
            new JSONObject(value);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    };

    public static class PackageNameListValidator
    implements Validator {
        private final String mSeparator;

        public PackageNameListValidator(String separator) {
            this.mSeparator = separator;
        }

        @Override
        public boolean validate(String value) {
            String[] elements;
            if (value == null) {
                return false;
            }
            for (String element : elements = value.split(this.mSeparator)) {
                if (PACKAGE_NAME_VALIDATOR.validate(element)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ComponentNameListValidator
    implements Validator {
        private final String mSeparator;

        public ComponentNameListValidator(String separator) {
            this.mSeparator = separator;
        }

        @Override
        public boolean validate(String value) {
            String[] elements;
            if (value == null) {
                return false;
            }
            for (String element : elements = value.split(this.mSeparator)) {
                if (COMPONENT_NAME_VALIDATOR.validate(element)) continue;
                return false;
            }
            return true;
        }
    }

    public static class InclusiveFloatRangeValidator
    implements Validator {
        private final float mMin;
        private final float mMax;

        public InclusiveFloatRangeValidator(float min, float max) {
            this.mMin = min;
            this.mMax = max;
        }

        @Override
        public boolean validate(String value) {
            try {
                float floatValue = Float.parseFloat(value);
                return floatValue >= this.mMin && floatValue <= this.mMax;
            }
            catch (NullPointerException | NumberFormatException e) {
                return false;
            }
        }
    }

    public static class InclusiveIntegerRangeValidator
    implements Validator {
        private final int mMin;
        private final int mMax;

        public InclusiveIntegerRangeValidator(int min, int max) {
            this.mMin = min;
            this.mMax = max;
        }

        @Override
        public boolean validate(String value) {
            try {
                int intValue = Integer.parseInt(value);
                return intValue >= this.mMin && intValue <= this.mMax;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    public static class DiscreteValueValidator
    implements Validator {
        private final String[] mValues;

        public DiscreteValueValidator(String[] values) {
            this.mValues = values;
        }

        @Override
        public boolean validate(String value) {
            return ArrayUtils.contains(this.mValues, value);
        }
    }

    public static interface Validator {
        public boolean validate(String var1);
    }
}

